/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.server;

import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.Database;
import org.apache.xindice.xml.TextWriter;
import org.w3c.dom.Document;

public class UglyBrowser {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$server$UglyBrowser == null ? (class$org$apache$xindice$server$UglyBrowser = UglyBrowser.class$("org.apache.xindice.server.UglyBrowser")) : class$org$apache$xindice$server$UglyBrowser));
    static /* synthetic */ Class class$org$apache$xindice$server$UglyBrowser;

    public static void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String contextPath = request.getContextPath();
            StringBuffer sb = new StringBuffer();
            String path = request.getQueryString();
            sb.append("<html><body><center>");
            if (path == null) {
                sb.append("<h2>THIS IS AN UGLY DEBUG TOOL!</h2><p>");
                sb.append("To browse the database, follow the link: ");
                String[] databases = Database.listDatabases();
                for (int i = 0; i < databases.length; ++i) {
                    String db = databases[i];
                    sb.append("<a href=\"" + contextPath + "/?/" + db + "\">" + db + "</a> ");
                }
            } else {
                XPathPseudoParser parser = new XPathPseudoParser(path);
                Database db = Database.getDatabase(parser.getDatabase());
                sb.append("<table border=\"1\" width=\"90%\">\n");
                sb.append("<tr><td rowspan=\"1\" colspan=\"2\">" + UglyBrowser.getPathNavigation(parser, contextPath) + "</td></tr>\n");
                sb.append("<tr><td valign=\"top\">" + UglyBrowser.getHierarchy(parser, contextPath, db) + "</td>");
                sb.append("<td valign=\"top\">" + UglyBrowser.getDetailView(parser, db) + "</td></tr>\n");
                sb.append("</table>\n");
            }
            sb.append("</center>");
            sb.append("<p><font size=\"-1\">Ugly Browser version: $Revision: 1.13 $ </font>\n</p>");
            sb.append("</body></html>");
            response.setContentType("text/html; charset=utf-8");
            byte[] resultBytes = sb.toString().getBytes("utf-8");
            response.setContentLength(resultBytes.length);
            ServletOutputStream output = response.getOutputStream();
            output.write(resultBytes);
            output.flush();
        }
        catch (Exception e) {
            throw new ServletException("argh!", (Throwable)e);
        }
    }

    protected static String getPathNavigation(XPathPseudoParser parser, String contextPath) {
        String path = parser.getQuery();
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(path, "/");
        String currentPath = "<a href=\"" + contextPath + "/?";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.indexOf("&") > 0) {
                token = token.substring(0, token.indexOf("&"));
            }
            currentPath = currentPath + "/" + token;
            result.append(currentPath + "\">" + token + "</a>&nbsp;-&nbsp;");
        }
        return result.toString();
    }

    protected static String getHierarchy(XPathPseudoParser parser, String contextPath, Database db) throws DBException, Exception {
        StringBuffer result;
        block8: {
            result = new StringBuffer();
            String path = parser.getPath();
            Collection col = !path.equals("") ? db.getCollection(parser.getPath()) : db;
            if (col == null) {
                result.append("Collection not found! " + parser.getPath());
                return result.toString();
            }
            String[] cols = col.listCollections();
            String dbLoc = parser.getDatabase();
            String parserPath = parser.getPath();
            StringBuffer baseHref = new StringBuffer();
            baseHref.append("<a href=\"" + contextPath + "/?/" + dbLoc);
            if (parserPath.startsWith("/") || dbLoc.endsWith("/")) {
                baseHref.append(parserPath);
            } else {
                baseHref.append("/" + parserPath);
            }
            for (int i = 0; i < cols.length; ++i) {
                result.append(baseHref);
                if (!baseHref.toString().endsWith("/")) {
                    result.append("/");
                }
                result.append(cols[i]);
                result.append("\">");
                result.append(cols[i]);
                result.append("</a><br>");
            }
            try {
                String[] docs = col.listDocuments();
                for (int i = 0; i < docs.length; ++i) {
                    result.append(baseHref);
                    result.append("&");
                    result.append(docs[i]);
                    result.append("\">");
                    result.append(docs[i]);
                    result.append("</a><br>");
                }
            }
            catch (DBException e) {
                if (!log.isWarnEnabled()) break block8;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
        return result.toString();
    }

    protected static String getDetailView(XPathPseudoParser parser, Database db) throws Exception {
        Collection col = db.getCollection(parser.getPath());
        String document = parser.getDocument();
        if (document == null) {
            return "";
        }
        Document doc = col.getDocument(document);
        if (doc == null) {
            return "Document '" + document + "' not found";
        }
        return "Document '" + document + "'<p>\n" + UglyBrowser.escapeHtml(TextWriter.toString(doc));
    }

    public static String escapeHtml(String value) {
        StringBuffer buf = new StringBuffer();
        block7: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                default: {
                    if (UglyBrowser.isLegalCharacter(c)) {
                        buf.append(c);
                        continue block7;
                    }
                    buf.append("&#");
                    buf.append(String.valueOf(c));
                    buf.append(";");
                }
            }
        }
        return buf.toString();
    }

    public static boolean isLegalCharacter(char c) {
        return c > '\u0007' && c < '\u0080';
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class XPathPseudoParser {
        private String query;

        public XPathPseudoParser(String query) throws Exception {
            this.query = query;
        }

        public String getQuery() {
            return this.query;
        }

        public String getDatabase() {
            int max = this.query.indexOf("/", 1);
            String db = max > 1 ? this.query.substring(0, max) : this.query;
            if (db.startsWith("/")) {
                db = db.substring(1);
            }
            return db;
        }

        public String getPath() {
            int min = this.query.indexOf("/", 1);
            if (min <= 0) {
                return "";
            }
            int max = this.query.indexOf("&");
            if (max > 1) {
                return this.query.substring(min + 1, max);
            }
            return this.query.substring(min + 1);
        }

        public String getDocument() {
            int pos = this.query.indexOf("&");
            if (pos > 0) {
                return this.query.substring(pos + 1);
            }
            return null;
        }
    }
}

