/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client;

import com.google.gdata.data.Category;
import com.google.gdata.data.DateTime;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    public static int UNDEFINED = -1;
    private URL feedUrl;
    private List<CategoryFilter> categoryFilters = new LinkedList<CategoryFilter>();
    private String queryString;
    private String author;
    private DateTime updatedMin;
    private DateTime updatedMax;
    private DateTime publishedMin;
    private DateTime publishedMax;
    private int startIndex = UNDEFINED;
    private int maxResults = UNDEFINED;
    private ResultFormat resultFormat = ResultFormat.ATOM;
    private List<CustomParameter> customParameters = new ArrayList<CustomParameter>();

    public Query(URL uRL) {
        this.feedUrl = uRL;
    }

    public void setFullTextQuery(String string) {
        this.queryString = string;
    }

    public String getFullTextQuery() {
        return this.queryString;
    }

    public void addCategoryFilter(CategoryFilter categoryFilter) {
        this.categoryFilters.add(categoryFilter);
    }

    public List<CategoryFilter> getCategoryFilters() {
        return Collections.unmodifiableList(this.categoryFilters);
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setUpdatedMin(DateTime dateTime) {
        this.updatedMin = dateTime;
    }

    public DateTime getUpdatedMin() {
        return this.updatedMin;
    }

    public void setUpdatedMax(DateTime dateTime) {
        this.updatedMax = dateTime;
    }

    public DateTime getUpdatedMax() {
        return this.updatedMax;
    }

    public void setPublishedMin(DateTime dateTime) {
        this.publishedMin = dateTime;
    }

    public DateTime getPublishedMin() {
        return this.publishedMin;
    }

    public void setPublishedMax(DateTime dateTime) {
        this.publishedMax = dateTime;
    }

    public DateTime getPublishedMax() {
        return this.publishedMax;
    }

    public void setStartIndex(int n) {
        if (n != UNDEFINED && n < 1) {
            throw new IllegalArgumentException("Start index must be positive");
        }
        this.startIndex = n;
    }

    public int getStartIndex() {
        return this.startIndex == UNDEFINED ? 1 : this.startIndex;
    }

    public void setMaxResults(int n) {
        if (n != UNDEFINED && n < 0) {
            throw new IllegalArgumentException("Max results must be zero or larger");
        }
        this.maxResults = n;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setResultFormat(ResultFormat resultFormat) {
        this.resultFormat = resultFormat;
    }

    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    public void addCustomParameter(CustomParameter customParameter) {
        if (customParameter == null) {
            throw new NullPointerException("Null custom parameter");
        }
        this.customParameters.add(customParameter);
    }

    public List<CustomParameter> getCustomParameters() {
        return this.customParameters;
    }

    public List<CustomParameter> getCustomParameters(String string) {
        ArrayList<CustomParameter> arrayList = new ArrayList<CustomParameter>();
        for (CustomParameter customParameter : this.customParameters) {
            if (!customParameter.name.equals(string)) continue;
            arrayList.add(customParameter);
        }
        return arrayList;
    }

    public URI getQueryUri() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.categoryFilters.size() != 0) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("/");
            }
            stringBuilder.append("-");
        }
        for (CategoryFilter object : this.categoryFilters) {
            stringBuilder.append("/");
            stringBuilder.append(URLEncoder.encode(object.toString()));
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        if (this.queryString != null) {
            stringBuilder2.append(stringBuilder2.length() != 0 ? (char)'&' : '?');
            stringBuilder2.append("q=");
            stringBuilder2.append(URLEncoder.encode(this.queryString));
        }
        if (this.author != null) {
            stringBuilder2.append(stringBuilder2.length() != 0 ? (char)'&' : '?');
            stringBuilder2.append("author=");
            stringBuilder2.append(URLEncoder.encode(this.author));
        }
        if (this.resultFormat != ResultFormat.ATOM) {
            stringBuilder2.append(stringBuilder2.length() != 0 ? (char)'&' : '?');
            stringBuilder2.append("alt=");
            stringBuilder2.append(this.resultFormat.paramValue());
        }
        if (this.updatedMin != null) {
            stringBuilder2.append(stringBuilder2.length() != 0 ? (char)'&' : '?');
            stringBuilder2.append("updated-min=");
            stringBuilder2.append(this.updatedMin.toString());
        }
        if (this.updatedMax != null) {
            stringBuilder2.append(stringBuilder2.length() != 0 ? (char)'&' : '?');
            stringBuilder2.append("updated-max=");
            stringBuilder2.append(this.updatedMax.toString());
        }
        if (this.publishedMin != null) {
            stringBuilder2.append(stringBuilder2.length() != 0 ? (char)'&' : '?');
            stringBuilder2.append("published-min=");
            stringBuilder2.append(this.publishedMin.toString());
        }
        if (this.publishedMax != null) {
            stringBuilder2.append(stringBuilder2.length() != 0 ? (char)'&' : '?');
            stringBuilder2.append("published-max=");
            stringBuilder2.append(this.publishedMax.toString());
        }
        if (this.startIndex != UNDEFINED) {
            stringBuilder2.append(stringBuilder2.length() != 0 ? (char)'&' : '?');
            stringBuilder2.append("start-index=" + this.startIndex);
        }
        if (this.maxResults != UNDEFINED) {
            stringBuilder2.append(stringBuilder2.length() != 0 ? (char)'&' : '?');
            stringBuilder2.append("max-results=" + this.maxResults);
        }
        for (CustomParameter customParameter : this.customParameters) {
            stringBuilder2.append(stringBuilder2.length() != 0 ? (char)'&' : '?');
            stringBuilder2.append(URLEncoder.encode(customParameter.name));
            stringBuilder2.append('=');
            stringBuilder2.append(URLEncoder.encode(customParameter.value));
        }
        try {
            return new URI(stringBuilder.toString() + stringBuilder2.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException("Unable to construct query URI", uRISyntaxException);
        }
    }

    public URL getUrl() {
        try {
            String string = this.getQueryUri().toString();
            if (string.length() == 0) {
                return this.feedUrl;
            }
            String string2 = this.feedUrl.toString();
            StringBuilder stringBuilder = new StringBuilder(string2);
            if (!string2.endsWith("/") && !string.startsWith("?")) {
                stringBuilder.append('/');
            }
            stringBuilder.append(string);
            return new URL(stringBuilder.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException("Unable to create query URL", malformedURLException);
        }
    }

    public final void setStringCustomParameter(String string, String string2) {
        List<CustomParameter> list = this.getCustomParameters();
        for (CustomParameter customParameter : this.getCustomParameters(string)) {
            list.remove(customParameter);
        }
        if (string2 != null) {
            list.add(new CustomParameter(string, string2));
        }
    }

    public final String getStringCustomParameter(String string) {
        List<CustomParameter> list = this.getCustomParameters(string);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0).getValue();
    }

    public final void setIntegerCustomParameter(String string, Integer n) {
        if (n == null) {
            this.setStringCustomParameter(string, null);
        } else {
            this.setStringCustomParameter(string, n.toString());
        }
    }

    public final Integer getIntegerCustomParameter(String string) {
        Integer n;
        String string2 = this.getStringCustomParameter(string);
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = null;
            }
        } else {
            n = null;
        }
        return n;
    }

    public static class CustomParameter {
        private String name;
        private String value;

        public CustomParameter(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CategoryFilter {
        private List<Category> categories;
        private List<Category> excludeCategories;

        public CategoryFilter() {
            this.categories = new LinkedList<Category>();
            this.excludeCategories = new LinkedList<Category>();
        }

        public CategoryFilter(List<Category> list, List<Category> list2) {
            this.categories = list != null ? list : new LinkedList<Category>();
            this.excludeCategories = list2 != null ? list2 : new LinkedList<Category>();
        }

        public CategoryFilter(Category category) {
            this.categories.add(category);
        }

        public void addCategory(Category category) {
            this.categories.add(category);
        }

        public void addExcludeCategory(Category category) {
            this.excludeCategories.add(category);
        }

        private String getQueryString(Category category) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = category.getScheme();
            if (string != null) {
                stringBuilder.append('{');
                stringBuilder.append(string);
                stringBuilder.append('}');
            }
            stringBuilder.append(category.getTerm());
            return stringBuilder.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (Category category : this.categories) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append("|");
                }
                stringBuilder.append(this.getQueryString(category));
            }
            for (Category category : this.excludeCategories) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append("|");
                }
                stringBuilder.append("-");
                stringBuilder.append(this.getQueryString(category));
            }
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResultFormat {
        ATOM("atom"),
        RSS("rss"),
        JSON("json"),
        ATOM_IN_SCRIPT("atom-in-script"),
        RSS_IN_SCRIPT("rss-in-script"),
        JSON_IN_SCRIPT("json-in-script");

        private String paramValue;

        private ResultFormat(String string2) {
            this.paramValue = string2;
        }

        public String paramValue() {
            return this.paramValue;
        }
    }
}

