/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.Kind;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceConfigurationException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.base.Pair;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionProfile {
    private HashSet<Class<Kind.Adaptor>> declared = new HashSet();
    private final Map<Class, ExtensionPoint.Manifest> profile = new HashMap<Class, ExtensionPoint.Manifest>();
    private Collection<XmlWriter.Namespace> additionalNamespaces = new ArrayList<XmlWriter.Namespace>();
    private ExtensionProfile feedLinkProfile;
    private ExtensionProfile entryLinkProfile;
    private Collection<XmlWriter.Namespace> nsDecls = null;
    private boolean isAutoExtending = false;

    public void addDeclarations(Kind.Adaptor adaptor) {
        Class<?> clazz = adaptor.getClass();
        if (!this.declared.contains(clazz)) {
            adaptor.declareExtensions(this);
            this.declared.add(clazz);
        }
    }

    public synchronized void declare(Class<? extends ExtensionPoint> clazz, ExtensionDescription extensionDescription) {
        ExtensionPoint.Manifest manifest = this.getOrCreateManifest(clazz);
        Pair<String, String> pair = new Pair<String, String>(extensionDescription.getNamespace().getUri(), extensionDescription.getLocalName());
        manifest.supportedExtensions.put(pair, extensionDescription);
        this.profile.put(clazz, manifest);
        this.nsDecls = null;
    }

    public synchronized void declareFeedExtension(ExtensionDescription extensionDescription) {
        this.declare(BaseFeed.class, extensionDescription);
    }

    public synchronized void declareFeedExtension(Class<? extends Extension> clazz) {
        this.declare(BaseFeed.class, ExtensionDescription.getDefaultDescription(clazz));
    }

    public synchronized void declareEntryExtension(ExtensionDescription extensionDescription) {
        this.declare(BaseEntry.class, extensionDescription);
    }

    public synchronized void declareEntryExtension(Class<? extends Extension> clazz) {
        this.declare(BaseEntry.class, ExtensionDescription.getDefaultDescription(clazz));
    }

    public synchronized void declareArbitraryXmlExtension(Class clazz) {
        ExtensionPoint.Manifest manifest = this.getOrCreateManifest(clazz);
        manifest.arbitraryXml = true;
        this.profile.put(clazz, manifest);
        this.nsDecls = null;
    }

    public synchronized void declareAdditionalNamespace(XmlWriter.Namespace namespace) {
        this.additionalNamespaces.add(namespace);
    }

    public synchronized void declareFeedLinkProfile(ExtensionProfile extensionProfile) {
        this.feedLinkProfile = extensionProfile;
        this.nsDecls = null;
    }

    public synchronized ExtensionProfile getFeedLinkProfile() {
        return this.feedLinkProfile;
    }

    public synchronized void declareEntryLinkProfile(ExtensionProfile extensionProfile) {
        this.entryLinkProfile = extensionProfile;
        this.nsDecls = null;
    }

    public synchronized ExtensionProfile getEntryLinkProfile() {
        return this.entryLinkProfile;
    }

    public ExtensionPoint.Manifest getManifest(Class clazz) {
        ExtensionPoint.Manifest manifest = null;
        while (clazz != null) {
            manifest = this.profile.get(clazz);
            if (manifest != null) {
                return manifest;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public synchronized Collection<XmlWriter.Namespace> getNamespaceDecls() {
        if (this.nsDecls == null) {
            this.nsDecls = this.computeNamespaceDecls();
        }
        return this.nsDecls;
    }

    public void setAutoExtending(boolean bl) {
        this.isAutoExtending = bl;
    }

    public boolean isAutoExtending() {
        return this.isAutoExtending;
    }

    private ExtensionPoint.Manifest getOrCreateManifest(Class clazz) {
        ExtensionPoint.Manifest manifest = this.getManifest(clazz);
        if (manifest != null) {
            return manifest;
        }
        return new ExtensionPoint.Manifest();
    }

    private synchronized Collection<XmlWriter.Namespace> computeNamespaceDecls() {
        HashSet<XmlWriter.Namespace> hashSet = new HashSet<XmlWriter.Namespace>();
        hashSet.addAll(this.additionalNamespaces);
        for (ExtensionPoint.Manifest manifest : this.profile.values()) {
            hashSet.addAll(manifest.getNamespaceDecls());
        }
        if (this.feedLinkProfile != null) {
            hashSet.addAll(this.feedLinkProfile.computeNamespaceDecls());
        }
        if (this.entryLinkProfile != null) {
            hashSet.addAll(this.entryLinkProfile.computeNamespaceDecls());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public void parseConfig(ExtensionProfile extensionProfile, ClassLoader classLoader, InputStream inputStream) throws IOException, ParseException {
        Handler handler = new Handler(extensionProfile, classLoader);
        new XmlParser().parse(inputStream, (XmlParser.ElementHandler)handler, "http://schemas.google.com/gdata/config/2005", "extensionProfile");
    }

    public void generateConfig(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        xmlWriter.startElement(Namespaces.gdataConfigNs, "extensionProfile", null, this.nsDecls);
        for (XmlWriter.Namespace iterator2 : this.additionalNamespaces) {
            ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
            arrayList.add(new XmlWriter.Attribute("alias", iterator2.getAlias()));
            arrayList.add(new XmlWriter.Attribute("uri", iterator2.getUri()));
            xmlWriter.simpleElement(Namespaces.gdataConfigNs, "namespaceDescription", arrayList, null);
        }
        TreeSet<Class> treeSet = new TreeSet<Class>(new Comparator<Class>(){

            @Override
            public int compare(Class clazz, Class clazz2) {
                return clazz.getName().compareTo(clazz2.getName());
            }

            public boolean equals(Comparator comparator) {
                return this.getClass().equals(comparator.getClass());
            }
        });
        for (Class clazz : this.profile.keySet()) {
            treeSet.add(clazz);
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            ExtensionPoint.Manifest manifest = this.profile.get(clazz);
            ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
            arrayList.add(new XmlWriter.Attribute("extendedClass", clazz.getName()));
            arrayList.add(new XmlWriter.Attribute("arbitraryXml", manifest.arbitraryXml));
            xmlWriter.startElement(Namespaces.gdataConfigNs, "extensionPoint", arrayList, null);
            TreeSet<ExtensionDescription> treeSet2 = new TreeSet<ExtensionDescription>();
            for (ExtensionDescription extensionDescription : manifest.getSupportedExtensions().values()) {
                treeSet2.add(extensionDescription);
            }
            for (ExtensionDescription extensionDescription : treeSet2) {
                extensionDescription.generateConfig(xmlWriter, extensionProfile);
            }
            xmlWriter.endElement(Namespaces.gdataConfigNs, "extensionPoint");
        }
        xmlWriter.endElement(Namespaces.gdataConfigNs, "extensionProfile");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExtensionPointHandler
    extends XmlParser.ElementHandler {
        private ExtensionProfile configProfile;
        private ClassLoader configLoader;
        private Class extensionPoint;
        private boolean arbitraryXml;
        private List<ExtensionDescription> extDescriptions = new ArrayList<ExtensionDescription>();
        private List<XmlWriter.Namespace> namespaces;

        public ExtensionPointHandler(ExtensionProfile extensionProfile2, ClassLoader classLoader, List<XmlWriter.Namespace> list, Attributes attributes) throws ParseException, IOException {
            this.configProfile = extensionProfile2;
            this.configLoader = classLoader;
            this.namespaces = list;
            String string = attributes.getValue("", "extendedClass");
            if (string == null) {
                throw new ParseException("ExtensionPoint extendedClass attribute is missing");
            }
            try {
                this.extensionPoint = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ParseException("Unable to load ExtensionPoint class", classNotFoundException);
            }
            if (!ExtensionPoint.class.isAssignableFrom(this.extensionPoint)) {
                throw new ParseException("Extended classes must extend ExtensionPoint");
            }
            String string2 = attributes.getValue("", "arbitraryXml");
            if (string2 != null) {
                if (string2.equals("true") || string2.equals("1")) {
                    this.arbitraryXml = true;
                } else if (string2.equals("false") || string2.equals("0")) {
                    this.arbitraryXml = false;
                } else {
                    throw new ParseException("Invalid value for arbitaryXml: " + this.arbitraryXml);
                }
            }
        }

        @Override
        public void processEndElement() throws ParseException {
            if (this.arbitraryXml) {
                ExtensionProfile.this.declareArbitraryXmlExtension(this.extensionPoint);
            }
            for (ExtensionDescription extensionDescription : this.extDescriptions) {
                ExtensionProfile.this.declare(this.extensionPoint, extensionDescription);
            }
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String string, String string2, Attributes attributes) throws ParseException, IOException {
            if (string.equals("http://schemas.google.com/gdata/config/2005") && string2.equals("extensionDescription")) {
                ExtensionDescription extensionDescription = new ExtensionDescription();
                this.extDescriptions.add(extensionDescription);
                ExtensionDescription extensionDescription2 = extensionDescription;
                extensionDescription2.getClass();
                return extensionDescription2.new ExtensionDescription.Handler(this.configProfile, this.configLoader, this.namespaces, attributes);
            }
            return super.getChildHandler(string, string2, attributes);
        }
    }

    public class Handler
    extends XmlParser.ElementHandler {
        private ExtensionProfile configProfile;
        private ClassLoader configLoader;
        private List<XmlWriter.Namespace> namespaces = new ArrayList<XmlWriter.Namespace>();

        public Handler(ExtensionProfile extensionProfile2, ClassLoader classLoader) throws IOException {
            this.configProfile = extensionProfile2;
            this.configLoader = classLoader;
        }

        public void validate() throws ServiceConfigurationException {
        }

        public void processEndElement() throws ParseException {
            try {
                this.validate();
            }
            catch (ServiceConfigurationException serviceConfigurationException) {
                throw new ParseException(serviceConfigurationException);
            }
        }

        public XmlParser.ElementHandler getChildHandler(String string, String string2, Attributes attributes) throws ParseException, IOException {
            if (string.equals("http://schemas.google.com/gdata/config/2005")) {
                if (string2.equals("namespaceDescription")) {
                    String string3 = attributes.getValue("", "alias");
                    if (string3 == null) {
                        throw new ParseException("NamespaceDescription alias attribute is missing");
                    }
                    String string4 = attributes.getValue("", "uri");
                    if (string4 == null) {
                        throw new ParseException("NamespaceDescription uri attribute is missing");
                    }
                    XmlWriter.Namespace namespace = new XmlWriter.Namespace(string3, string4);
                    this.namespaces.add(namespace);
                    ExtensionProfile.this.declareAdditionalNamespace(namespace);
                    return new XmlParser.ElementHandler();
                }
                if (string2.equals("extensionPoint")) {
                    return new ExtensionPointHandler(this.configProfile, this.configLoader, this.namespaces, attributes);
                }
            }
            return super.getChildHandler(string, string2, attributes);
        }
    }
}

