/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;

public class Link
extends ExtensionPoint {
    protected String rel;
    protected String type;
    protected String href;
    protected String hrefLang;
    protected String title;
    protected String titleLang;
    protected long length = -1L;

    public Link() {
    }

    public Link(String string, String string2, String string3) {
        this.rel = string;
        this.type = string2;
        this.setHref(string3);
    }

    public String getRel() {
        return this.rel != null ? this.rel : "alternate";
    }

    public void setRel(String string) {
        this.rel = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String string) {
        this.href = string;
    }

    public String getHrefLang() {
        return this.hrefLang;
    }

    public void setHrefLang(String string) {
        this.hrefLang = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitleLang() {
        return this.titleLang;
    }

    public void setTitleLang(String string) {
        this.titleLang = string;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long l) {
        this.length = l;
    }

    public void generateAtom(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>(3);
        if (this.rel != null) {
            arrayList.add(new XmlWriter.Attribute("rel", this.rel));
        }
        if (this.type != null) {
            arrayList.add(new XmlWriter.Attribute("type", this.type));
        }
        if (this.href != null) {
            arrayList.add(new XmlWriter.Attribute("href", this.href));
        }
        if (this.hrefLang != null) {
            arrayList.add(new XmlWriter.Attribute("hreflang", this.hrefLang));
        }
        if (this.title != null) {
            arrayList.add(new XmlWriter.Attribute("title", this.title));
        }
        if (this.titleLang != null) {
            arrayList.add(new XmlWriter.Attribute("xml:lang", this.titleLang));
        }
        if (this.length != -1L) {
            arrayList.add(new XmlWriter.Attribute("length", String.valueOf(this.length)));
        }
        this.generateStartElement(xmlWriter, Namespaces.atomNs, "link", arrayList, null);
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.endElement(Namespaces.atomNs, "link");
    }

    public void generateRss(XmlWriter xmlWriter) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>(3);
        if (this.rel != null && this.rel.equals("enclosure")) {
            if (this.type != null) {
                arrayList.add(new XmlWriter.Attribute("type", this.type));
            }
            if (this.href != null) {
                arrayList.add(new XmlWriter.Attribute("url", this.href));
            }
            if (this.length != -1L) {
                arrayList.add(new XmlWriter.Attribute("length", String.valueOf(this.length)));
            }
            xmlWriter.simpleElement(Namespaces.rssNs, "enclosure", arrayList, null);
        } else if ("comments".equals(this.rel)) {
            xmlWriter.simpleElement(Namespaces.rssNs, "comments", null, this.href);
        } else if ("alternate".equals(this.rel)) {
            xmlWriter.simpleElement(Namespaces.rssNs, "link", null, this.href);
        } else if ("via".equals(this.rel) && this.href != null) {
            arrayList.add(new XmlWriter.Attribute("url", this.href));
            xmlWriter.simpleElement(Namespaces.rssNs, "source", arrayList, null);
        }
    }

    public class AtomHandler
    extends ExtensionPoint.ExtensionHandler {
        public AtomHandler(ExtensionProfile extensionProfile) throws IOException {
            super(extensionProfile, Link.class);
        }

        public void processAttribute(String string, String string2, String string3) throws ParseException {
            if (string.equals("") && string2.equals("rel")) {
                Link.this.rel = string3;
            } else if (string.equals("") && string2.equals("type")) {
                Link.this.type = string3;
            } else if (string.equals("") && string2.equals("href")) {
                Link.this.href = this.getAbsoluteUri(string3);
            } else if (string.equals("") && string2.equals("hreflang")) {
                Link.this.hrefLang = string3;
            } else if (string.equals("") && string2.equals("title")) {
                Link.this.title = string3;
            } else if (string.equals("") && string2.equals("length")) {
                try {
                    Link.this.length = Integer.valueOf(string3).longValue();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Length must be an integer");
                }
            }
        }

        public void processEndElement() throws ParseException {
            if (Link.this.href == null) {
                throw new ParseException("Link must have an 'href' attribute.");
            }
            Link.this.titleLang = this.xmlLang;
        }
    }

    public static final class Type {
        public static final String ATOM = "application/atom+xml";
        public static final String HTML = "text/html";
    }

    public static final class Rel {
        public static final String SELF = "self";
        public static final String PREVIOUS = "previous";
        public static final String NEXT = "next";
        public static final String ALTERNATE = "alternate";
        public static final String RELATED = "related";
        public static final String FEED = "http://schemas.google.com/g/2005#feed";
        public static final String ENTRY_POST = "http://schemas.google.com/g/2005#post";
        public static final String ENTRY_EDIT = "edit";
        public static final String MEDIA_EDIT = "media-edit";
        public static final String FEED_BATCH = "http://schemas.google.com/g/2005#batch";
        public static final String VIA = "via";
    }
}

