/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.batch;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.batch.BatchOperationType;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.xml.sax.Attributes;

public class BatchOperation
extends ExtensionPoint
implements Extension {
    private BatchOperationType type;

    public BatchOperation(BatchOperationType batchOperationType) {
        this.type = batchOperationType;
    }

    public BatchOperation() {
    }

    public static ExtensionDescription getDefaultDescription() {
        ExtensionDescription extensionDescription = new ExtensionDescription();
        extensionDescription.setExtensionClass(BatchOperation.class);
        extensionDescription.setNamespace(Namespaces.batchNs);
        extensionDescription.setLocalName("operation");
        extensionDescription.setRepeatable(false);
        return extensionDescription;
    }

    public BatchOperationType getType() {
        return this.type;
    }

    public void setType(BatchOperationType batchOperationType) {
        this.type = batchOperationType;
    }

    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        List<XmlWriter.Attribute> list = null;
        if (this.type != null) {
            list = Collections.singletonList(new XmlWriter.Attribute("type", this.type.getName()));
        }
        this.generateStartElement(xmlWriter, Namespaces.batchNs, "operation", list, null);
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.endElement(Namespaces.batchNs, "operation");
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extensionProfile, String string, String string2, Attributes attributes) throws ParseException, IOException {
        return new BatchOperationHandler(extensionProfile, attributes);
    }

    private class BatchOperationHandler
    extends ExtensionPoint.ExtensionHandler {
        public BatchOperationHandler(ExtensionProfile extensionProfile, Attributes attributes) throws IOException, ParseException {
            super(extensionProfile, BatchOperation.class);
            String string = attributes.getValue("type");
            BatchOperationType batchOperationType = BatchOperationType.forName(string);
            if (batchOperationType == null) {
                throw new ParseException("Invalid type for batch:operation: '" + string + "'");
            }
            BatchOperation.this.type = batchOperationType;
        }
    }
}

