/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.batch;

import com.google.gdata.util.Namespaces;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BatchOperationType {
    QUERY("query"),
    INSERT("insert"),
    UPDATE("update"),
    DELETE("delete");

    private static final Map<String, BatchOperationType> BY_NAME;
    private final String name;

    private BatchOperationType(String string2) {
        this.name = string2;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static BatchOperationType forName(String string) {
        return BY_NAME.get(string);
    }

    public void generateAtom(XmlWriter xmlWriter) throws IOException {
        List<XmlWriter.Attribute> list = Collections.singletonList(new XmlWriter.Attribute("type", this.getName()));
        xmlWriter.simpleElement(Namespaces.batchNs, "operation", list, null);
    }

    static {
        BY_NAME = new HashMap<String, BatchOperationType>();
        for (BatchOperationType batchOperationType : BatchOperationType.values()) {
            BY_NAME.put(batchOperationType.getName(), batchOperationType);
        }
    }
}

