/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.extensions.Email;
import com.google.gdata.data.extensions.GeoPt;
import com.google.gdata.data.extensions.Im;
import com.google.gdata.data.extensions.PhoneNumber;
import com.google.gdata.data.extensions.PostalAddress;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/g/2005#contact")
public class ContactEntry
extends BaseEntry<ContactEntry> {
    public static final String CONTACT_KIND = "http://schemas.google.com/g/2005#contact";
    public static final Category CONTACT_CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/g/2005#contact");

    public ContactEntry() {
        this.getCategories().add(CONTACT_CATEGORY);
    }

    public ContactEntry(BaseEntry baseEntry) {
        super(baseEntry);
        this.getCategories().add(CONTACT_CATEGORY);
    }

    @Override
    public void declareExtensions(ExtensionProfile extensionProfile) {
        extensionProfile.declareEntryExtension(Email.getDefaultDescription());
        extensionProfile.declareEntryExtension(Im.getDefaultDescription());
        extensionProfile.declareEntryExtension(PhoneNumber.getDefaultDescription());
        extensionProfile.declareEntryExtension(PostalAddress.getDefaultDescription());
        extensionProfile.declareEntryExtension(GeoPt.getDefaultDescription());
    }

    public List<Email> getEmailAddresses() {
        return this.getRepeatingExtension(Email.class);
    }

    public void addEmailAddress(Email email) {
        this.getEmailAddresses().add(email);
    }

    public List<Im> getImAddresses() {
        return this.getRepeatingExtension(Im.class);
    }

    public void addImAddress(Im im) {
        this.getImAddresses().add(im);
    }

    public List<PhoneNumber> getPhoneNumbers() {
        return this.getRepeatingExtension(PhoneNumber.class);
    }

    public void addPhoneNumber(PhoneNumber phoneNumber) {
        this.getPhoneNumbers().add(phoneNumber);
    }

    public List<PostalAddress> getPostalAddresses() {
        return this.getRepeatingExtension(PostalAddress.class);
    }

    public void addPostalAddress(PostalAddress postalAddress) {
        this.getPostalAddresses().add(postalAddress);
    }

    public List<GeoPt> getLocations() {
        return this.getRepeatingExtension(GeoPt.class);
    }

    public void addLocation(GeoPt geoPt) {
        this.getLocations().add(geoPt);
    }
}

