/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class Reminder
extends ExtensionPoint
implements Extension {
    protected Integer days;
    protected Integer hours;
    protected Integer minutes;
    protected DateTime absoluteTime;

    public Integer getDays() {
        return this.days;
    }

    public void setDays(Integer n) {
        this.days = n;
    }

    public Integer getHours() {
        return this.hours;
    }

    public void setHours(Integer n) {
        this.hours = n;
    }

    public Integer getMinutes() {
        return this.minutes;
    }

    public void setMinutes(Integer n) {
        this.minutes = n;
    }

    public DateTime getAbsoluteTime() {
        return this.absoluteTime;
    }

    public void setAbsoluteTime(DateTime dateTime) {
        this.absoluteTime = dateTime;
    }

    public static ExtensionDescription getDefaultDescription() {
        ExtensionDescription extensionDescription = new ExtensionDescription();
        extensionDescription.setExtensionClass(Reminder.class);
        extensionDescription.setNamespace(Namespaces.gNs);
        extensionDescription.setLocalName("reminder");
        extensionDescription.setRepeatable(true);
        return extensionDescription;
    }

    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
        if (this.days != null) {
            arrayList.add(new XmlWriter.Attribute("days", this.days.toString()));
        }
        if (this.hours != null) {
            arrayList.add(new XmlWriter.Attribute("hours", this.hours.toString()));
        }
        if (this.minutes != null) {
            arrayList.add(new XmlWriter.Attribute("minutes", this.minutes.toString()));
        }
        if (this.absoluteTime != null) {
            arrayList.add(new XmlWriter.Attribute("absoluteTime", this.absoluteTime.toString()));
        }
        this.generateStartElement(xmlWriter, Namespaces.gNs, "reminder", arrayList, null);
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.endElement(Namespaces.gNs, "reminder");
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extensionProfile, String string, String string2, Attributes attributes) throws ParseException, IOException {
        return new Handler(extensionProfile);
    }

    private class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extensionProfile) throws ParseException, IOException {
            super(extensionProfile, Reminder.class);
        }

        public void processAttribute(String string, String string2, String string3) throws ParseException {
            if (string.equals("")) {
                if (string2.equals("days")) {
                    try {
                        Reminder.this.days = Integer.valueOf(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Invalid g:reminder/@days.", numberFormatException);
                    }
                }
                if (string2.equals("hours")) {
                    try {
                        Reminder.this.hours = Integer.valueOf(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Invalid g:reminder/@hours.", numberFormatException);
                    }
                }
                if (string2.equals("minutes")) {
                    try {
                        Reminder.this.minutes = Integer.valueOf(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Invalid g:reminder/@minutes.", numberFormatException);
                    }
                }
                if (string2.equals("absoluteTime")) {
                    try {
                        Reminder.this.absoluteTime = DateTime.parseDateTime(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Invalid g:reminder/@absoluteTime.", numberFormatException);
                    }
                }
            }
        }

        public void processEndElement() throws ParseException {
            if ((Reminder.this.days == null ? 0 : 1) + (Reminder.this.hours == null ? 0 : 1) + (Reminder.this.minutes == null ? 0 : 1) + (Reminder.this.absoluteTime == null ? 0 : 1) != 1) {
                throw new ParseException("g:reminder must have exactly one attribute.");
            }
            super.processEndElement();
        }
    }
}

