/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.introspection;

import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.introspection.Workspace;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDocument
extends ExtensionPoint {
    List<Workspace> workspaces = new ArrayList<Workspace>();

    public List<Workspace> getWorkspaces() {
        return this.workspaces;
    }

    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        xmlWriter.startElement(Namespaces.atomPubNs, "service", null, null);
        xmlWriter.startRepeatingElement();
        for (Workspace workspace : this.workspaces) {
            workspace.generate(xmlWriter, extensionProfile);
        }
        xmlWriter.endRepeatingElement();
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.endElement(Namespaces.atomPubNs, "service");
    }

    public void parse(ExtensionProfile extensionProfile, Reader reader) throws IOException, ParseException {
        new XmlParser().parse(reader, (XmlParser.ElementHandler)new Handler(extensionProfile), "http://purl.org/atom/app#", "service");
    }

    public void parse(ExtensionProfile extensionProfile, InputStream inputStream) throws IOException, ParseException {
        new XmlParser().parse(inputStream, (XmlParser.ElementHandler)new Handler(extensionProfile), "http://purl.org/atom/app#", "service");
    }

    public void processEndElement() throws ParseException {
        if (this.workspaces.size() == 0) {
            throw new ParseException("Service must contain at least one workspace");
        }
    }

    public class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extensionProfile) throws IOException {
            super(extensionProfile, ServiceDocument.class);
        }

        public XmlParser.ElementHandler getChildHandler(String string, String string2, Attributes attributes) throws ParseException, IOException {
            if (string.equals("http://purl.org/atom/app#")) {
                if (string2.equals("workspace")) {
                    String string3 = attributes.getValue("", "title");
                    if (string3 == null) {
                        throw new ParseException("Title missing for app:workspace element");
                    }
                    Workspace workspace = new Workspace(string3);
                    ServiceDocument.this.workspaces.add(workspace);
                    Workspace workspace2 = workspace;
                    workspace2.getClass();
                    return new Workspace.Handler(workspace2, this.extProfile);
                }
                throw new ParseException("Unrecognized element: namespace: " + string + ",localName: " + string2);
            }
            return super.getChildHandler(string, string2, attributes);
        }
    }
}

