/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.common.xml;

import com.google.gdata.util.common.base.StringUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlWriter {
    protected final Writer writer;
    private final Stack<Element> elementStack;
    private String defaultNamespace;
    private String nextDefaultNamespace = null;

    public XmlWriter(Writer writer) throws IOException {
        this.writer = writer;
        this.elementStack = new Stack();
        this.elementStack.push(this.createElement(null, null, null));
    }

    public XmlWriter(Writer writer, String string) throws IOException {
        this(writer);
        this.writeHeader(string);
    }

    public XmlWriter(Writer writer, boolean bl) throws IOException {
        this(writer);
        if (bl) {
            this.writeHeader(null);
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void setDefaultNamespace(Namespace namespace) {
        if (!namespace.uri.equals(this.defaultNamespace)) {
            this.nextDefaultNamespace = namespace.uri;
            this.defaultNamespace = namespace.uri;
        }
    }

    protected Element createElement(String string, String string2, String string3) {
        return new Element(string, string2, string3);
    }

    protected Element currentElement() {
        try {
            return this.elementStack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    public void startElement(String string) throws IOException {
        this.startElement(null, string, null, null);
    }

    public void startElement(Namespace namespace, String string, Collection<Attribute> collection, Collection<Namespace> collection2) throws IOException {
        Element element = namespace != null ? this.createElement(namespace.alias, namespace.uri, string) : this.createElement(null, null, string);
        Element element2 = this.currentElement();
        if (element2 != null) {
            element.xmlLang = element2.xmlLang;
            if (element2.repeatingCount != -1) {
                element.repeatingIndex = element2.repeatingCount++;
            }
        }
        this.elementStack.push(element);
        if (this.nextDefaultNamespace != null) {
            Iterator<Object> iterator = new Namespace(null, this.nextDefaultNamespace);
            element.addNamespace((Namespace)((Object)iterator));
            this.nextDefaultNamespace = null;
        }
        if (collection2 != null) {
            for (Namespace object : collection2) {
                this.ensureNamespace(object);
            }
        }
        if (namespace != null) {
            element.nsAlias = this.ensureNamespace(namespace);
        }
        this.writeOpenTagStart(element.nsAlias, string);
        for (Namespace namespace2 : element.nsDecls) {
            if (namespace2.alias != null && namespace2.alias.length() > 0) {
                this.writeAttribute("xmlns", namespace2.alias, namespace2.uri);
                continue;
            }
            this.writeAttribute(null, "xmlns", namespace2.uri);
        }
        if (collection != null) {
            for (Attribute attribute : collection) {
                if (attribute.name.equals("lang") && "xml".equals(attribute.nsAlias)) {
                    if (attribute.value.equals(element.xmlLang)) continue;
                    element.xmlLang = attribute.value;
                }
                this.writeAttribute(attribute.nsAlias, attribute.name, attribute.value);
            }
        }
        this.writeOpenTagEnd();
    }

    public void endElement(Namespace namespace, String string) throws IOException {
        Element element = this.currentElement();
        assert (namespace == null || element.nsUri.equals(namespace.uri));
        assert (element.name.equals(string));
        this.endElement();
    }

    public void endElement() throws IOException {
        Element element = this.currentElement();
        this.writeCloseTag(element.nsAlias, element.name);
        this.elementStack.pop();
        if (this.elementStack.size() == 1) {
            this.writeFooter();
        }
    }

    public void simpleElement(String string, String string2) throws IOException {
        this.simpleElement(null, string, null, string2);
    }

    public void startRepeatingElement() throws IOException {
        Element element = this.currentElement();
        if (element.repeatingCount != -1) {
            throw new IllegalStateException("Existing repeating element is active");
        }
        element.repeatingCount = 0;
    }

    public void endRepeatingElement() throws IOException {
        this.currentElement().repeatingCount = -1;
    }

    public void simpleElement(Namespace namespace, String string, List<Attribute> list, String string2) throws IOException {
        this.startElement(namespace, string, list, null);
        this.characters(string2);
        this.endElement(namespace, string);
    }

    private String checkNamespace(String string) {
        for (int i = this.elementStack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.elementStack.get(i);
            for (Namespace namespace : element.nsDecls) {
                if (namespace.alias == null || !namespace.uri.equals(string)) continue;
                return namespace.alias;
            }
        }
        return null;
    }

    private String ensureNamespace(Namespace namespace) {
        if (namespace.uri.equals(this.defaultNamespace)) {
            return null;
        }
        String string = this.checkNamespace(namespace.uri);
        if (string == null) {
            Element element = this.currentElement();
            this.ensureUniqueNamespaceAlias(element, namespace);
            element.addNamespace(namespace);
            string = namespace.alias;
        }
        return string;
    }

    private void ensureUniqueNamespaceAlias(Element element, Namespace namespace) {
        boolean bl;
        int n = 0;
        block0: do {
            bl = true;
            for (Namespace namespace2 : element.nsDecls) {
                if (!namespace.alias.equals(namespace2.alias)) continue;
                bl = false;
                namespace.alias = "ns" + String.valueOf(++n);
                continue block0;
            }
        } while (!bl);
    }

    protected void writeHeader(String string) throws IOException {
        this.writer.write("<?xml");
        this.writeAttribute("version", "1.0");
        if (string != null) {
            this.writeAttribute("encoding", string);
        }
        this.writer.write("?>");
    }

    protected void writeFooter() throws IOException {
    }

    protected void writeQualifiedName(String string, String string2) throws IOException {
        if (string != null && string.length() > 0) {
            this.writer.write(string);
            this.writer.write(58);
        }
        this.writer.write(string2);
    }

    protected void writeOpenTagStart(String string, String string2) throws IOException {
        this.writer.write(60);
        this.writeQualifiedName(string, string2);
    }

    protected void writeOpenTagEnd() throws IOException {
        this.writer.write(62);
    }

    protected void writeCloseTag(String string, String string2) throws IOException {
        this.writer.write("</");
        this.writeQualifiedName(string, string2);
        this.writer.write(">");
    }

    protected void writeAttribute(String string, String string2) throws IOException {
        this.writeAttribute(null, string, string2);
    }

    protected void writeAttribute(String string, String string2, String string3) throws IOException {
        this.writer.write(" ");
        this.writeQualifiedName(string, string2);
        this.writer.write(61);
        this.writer.write(39);
        if (string3 != null) {
            this.writer.write(StringUtil.xmlEscape(string3));
        }
        this.writer.write(39);
    }

    public void characters(String string) throws IOException {
        if (string == null) {
            return;
        }
        this.writer.write(StringUtil.xmlContentEscape(string));
    }

    public void innerXml(String string) throws IOException {
        if (string != null) {
            this.writer.write(string);
        }
    }

    public void writeUnescaped(String string) throws IOException {
        this.writer.write(string);
    }

    protected static class Element {
        public static final int NOT_REPEATING = -1;
        public List<Namespace> nsDecls = new ArrayList<Namespace>();
        public String nsAlias;
        public final String nsUri;
        public final String name;
        public String xmlLang;
        public boolean hasAttributes;
        public int repeatingCount = -1;
        public int repeatingIndex = -1;

        protected Element(String string, String string2, String string3) {
            this.nsAlias = string;
            this.nsUri = string2;
            this.name = string3;
        }

        void addNamespace(Namespace namespace) {
            if (!this.nsDecls.contains(namespace)) {
                this.nsDecls.add(namespace);
            }
        }
    }

    public static final class Attribute {
        final String nsAlias;
        final String name;
        final String value;

        public Attribute(String string, String string2) {
            this(null, string, string2);
        }

        public Attribute(String string, String string2, String string3) {
            int n;
            if (string == null && (n = string2.indexOf(58)) > 0) {
                string = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            }
            this.nsAlias = string;
            this.name = string2;
            this.value = string3;
        }

        public Attribute(String string, boolean bl) {
            this(null, string, bl ? "true" : "false");
        }
    }

    public static final class Namespace {
        String alias;
        final String uri;

        public Namespace(String string, String string2) {
            this.alias = string;
            this.uri = string2;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final String getUri() {
            return this.uri;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Namespace)) {
                return false;
            }
            Namespace namespace = (Namespace)object;
            if (this.alias == null) {
                return namespace.alias == null && this.uri.equals(namespace.uri);
            }
            return this.alias.equals(namespace.alias) && this.uri.equals(namespace.uri);
        }

        public int hashCode() {
            if (this.alias == null) {
                return this.uri.hashCode();
            }
            return this.alias.hashCode() & this.uri.hashCode();
        }
    }
}

