/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.HDLAYOUT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMHEADER;
import org.eclipse.swt.internal.win32.NMRGINFO;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.NMTVCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMTVDISPINFO;
import org.eclipse.swt.internal.win32.NMTVITEMCHANGE;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.TVHITTESTINFO;
import org.eclipse.swt.internal.win32.TVINSERTSTRUCT;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    TreeItem[] items;
    TreeColumn[] columns;
    ImageList imageList;
    ImageList headerImageList;
    TreeItem currentItem;
    TreeColumn sortColumn;
    int hwndParent;
    int hwndHeader;
    int hAnchor;
    int hInsert;
    int lastID;
    int hSelect;
    int hFirstIndexOf;
    int hLastIndexOf;
    int lastIndexOf;
    int itemCount;
    int sortDirection;
    boolean dragStarted;
    boolean gestureCompleted;
    boolean insertAfter;
    boolean shrink;
    boolean ignoreShrink;
    boolean ignoreSelect;
    boolean ignoreExpand;
    boolean ignoreDeselect;
    boolean ignoreResize;
    boolean lockSelection;
    boolean oldSelected;
    boolean newSelected;
    boolean ignoreColumnMove;
    boolean linesVisible;
    boolean customDraw;
    boolean printClient;
    boolean painted;
    boolean ignoreItemHeight;
    boolean ignoreCustomDraw;
    boolean ignoreDrawForeground;
    boolean ignoreDrawBackground;
    boolean ignoreDrawSelection;
    boolean ignoreFullSelection;
    int scrollWidth;
    int itemToolTipHandle;
    int headerToolTipHandle;
    int selectionForeground;
    static final int INSET = 3;
    static final int GRID_WIDTH = 1;
    static final int SORT_WIDTH = 10;
    static final int HEADER_MARGIN = 12;
    static final int HEADER_EXTRA = 3;
    static final int INCREMENT = 5;
    static final int TreeProc;
    static final TCHAR TreeClass;
    static final int HeaderProc;
    static final TCHAR HeaderClass;

    static {
        TreeClass = new TCHAR(0, "SysTreeView32", true);
        HeaderClass = new TCHAR(0, "SysHeader32", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, TreeClass, lpWndClass);
        TreeProc = lpWndClass.lpfnWndProc;
        OS.GetClassInfo(0, HeaderClass, lpWndClass);
        HeaderProc = lpWndClass.lpfnWndProc;
    }

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    static int checkStyle(int style) {
        return Tree.checkBits(style |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    void _addListener(int eventType, Listener listener) {
        super._addListener(eventType, listener);
        switch (eventType) {
            case 29: {
                int bits = OS.GetWindowLong(this.handle, -16);
                OS.SetWindowLong(this.handle, -16, bits &= 0xFFFFFFEF);
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                int oldBits;
                this.customDraw = true;
                this.style |= 0x20000000;
                OS.SendMessage(this.handle, 4385, 0, 0);
                int newBits = oldBits = OS.GetWindowLong(this.handle, -16);
                newBits |= 0x8080;
                if ((this.style & 0x10000) != 0 && eventType != 41) {
                    newBits &= 0xFFFFEFFF;
                }
                if (newBits == oldBits) break;
                OS.SetWindowLong(this.handle, -16, newBits);
                OS.InvalidateRect(this.handle, null, true);
                int count = OS.SendMessage(this.handle, 4357, 0, 0);
                if (count == 0 || OS.IsWinCE) break;
                OS.ShowScrollBar(this.handle, 0, false);
            }
        }
    }

    TreeItem _getItem(int hItem) {
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        tvItem.hItem = hItem;
        if (OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem) != 0) {
            return this._getItem(tvItem.hItem, tvItem.lParam);
        }
        return null;
    }

    TreeItem _getItem(int hItem, int id) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[id];
        }
        return id != -1 ? this.items[id] : new TreeItem(this, 0, -1, -1, hItem);
    }

    void _setBackgroundPixel(int newPixel) {
        int oldPixel = OS.SendMessage(this.handle, 4383, 0, 0);
        if (oldPixel != newPixel) {
            if (oldPixel != -1) {
                OS.SendMessage(this.handle, 4381, 0, -1);
            }
            OS.SendMessage(this.handle, 4381, 0, newPixel);
            if ((this.style & 0x20) != 0) {
                this.setCheckboxImageList();
            }
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int borderHandle() {
        return this.hwndParent != 0 ? this.hwndParent : this.handle;
    }

    LRESULT CDDS_ITEMPOSTPAINT(int wParam, int lParam) {
        TreeItem item;
        if (this.ignoreCustomDraw) {
            return null;
        }
        NMTVCUSTOMDRAW nmcd = new NMTVCUSTOMDRAW();
        OS.MoveMemory(nmcd, lParam, NMTVCUSTOMDRAW.sizeof);
        int hDC = nmcd.hdc;
        OS.RestoreDC(hDC, -1);
        int id = nmcd.lItemlParam;
        if ((this.style & 0x10000000) != 0 && id == -1) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 20;
            tvItem.hItem = nmcd.dwItemSpec;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            id = tvItem.lParam;
        }
        if ((item = this._getItem(nmcd.dwItemSpec, id)) == null) {
            return null;
        }
        if (nmcd.left >= nmcd.right || nmcd.top >= nmcd.bottom) {
            return null;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return null;
        }
        if (this.findImageControl() != null || this.ignoreDrawSelection) {
            OS.SetBkMode(hDC, 1);
        }
        boolean selected = false;
        if (OS.IsWindowEnabled(this.handle)) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 24;
            tvItem.hItem = item.handle;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if ((tvItem.state & 0xA) != 0) {
                selected = true;
                if (this.handle == OS.GetFocus()) {
                    if (OS.GetTextColor(hDC) != OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT)) {
                        selected = false;
                    } else if (OS.GetBkColor(hDC) != OS.GetSysColor(OS.COLOR_HIGHLIGHT)) {
                        selected = false;
                    }
                }
            } else if (OS.GetTextColor(hDC) == OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT) && OS.GetBkColor(hDC) == OS.GetSysColor(OS.COLOR_HIGHLIGHT)) {
                selected = true;
            }
        }
        int count = 0;
        int[] order = null;
        RECT clientRect = new RECT();
        RECT focusRect = null;
        OS.GetClientRect(this.scrolledHandle(), clientRect);
        if (this.hwndHeader != 0) {
            OS.MapWindowPoints(this.hwndParent, this.handle, clientRect, 2);
            count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
            if (count != 0) {
                order = new int[count];
                OS.SendMessage(this.hwndHeader, 4625, count, order);
            }
        }
        int sortIndex = -1;
        int clrSortBk = -1;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && this.findImageControl() == null) {
            sortIndex = this.indexOf(this.sortColumn);
            clrSortBk = this.getSortColumnPixel();
        }
        Point size = null;
        int x = 0;
        int gridWidth = this.linesVisible ? 1 : 0;
        int i = 0;
        while (i < Math.max(1, count)) {
            RECT rect;
            int index = order == null ? i : order[i];
            int width = nmcd.right - nmcd.left;
            if (count > 0 && this.hwndHeader != 0) {
                HDITEM hdItem = new HDITEM();
                hdItem.mask = 1;
                OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, index, hdItem);
                width = hdItem.cxy;
            }
            if (i == 0) {
                rect = new RECT();
                if ((this.style & 0x10000) != 0) {
                    OS.SetRect(rect, width, nmcd.top, nmcd.right, nmcd.bottom);
                    if (!(!selected && this.findImageControl() != null || this.ignoreDrawSelection || this.ignoreDrawBackground)) {
                        this.fillBackground(hDC, OS.GetBkColor(hDC), rect);
                    }
                }
            }
            if (x + width > clientRect.left) {
                Event event;
                int hFont;
                rect = new RECT();
                RECT backgroundRect = null;
                boolean drawItem = true;
                boolean drawText = true;
                boolean drawImage = true;
                boolean drawBackground = false;
                if (i == 0) {
                    drawText = false;
                    drawImage = false;
                    drawItem = false;
                    if (this.findImageControl() != null) {
                        drawBackground = true;
                        drawText = true;
                        drawItem = true;
                        rect = item.getBounds(index, true, false, false, false, true, hDC);
                        if (this.linesVisible) {
                            ++rect.right;
                            ++rect.bottom;
                        }
                    }
                    if (selected && !this.ignoreDrawSelection && !this.ignoreDrawBackground) {
                        this.fillBackground(hDC, OS.GetBkColor(hDC), rect);
                        drawBackground = false;
                    }
                    backgroundRect = rect;
                    if (this.hooks(40)) {
                        drawImage = true;
                        drawText = true;
                        drawItem = true;
                        rect = item.getBounds(index, true, true, false, false, true, hDC);
                        backgroundRect = (this.style & 0x10000) != 0 ? rect : item.getBounds(index, true, false, false, false, true, hDC);
                    }
                } else {
                    this.selectionForeground = -1;
                    this.ignoreDrawSelection = false;
                    this.ignoreDrawBackground = false;
                    this.ignoreDrawForeground = false;
                    OS.SetRect(rect, x, nmcd.top, x + width, nmcd.bottom - gridWidth);
                    backgroundRect = rect;
                }
                int clrText = -1;
                int clrTextBk = -1;
                int n = hFont = item.cellFont != null ? item.cellFont[index] : -1;
                if (hFont == -1) {
                    hFont = item.font;
                }
                if (this.selectionForeground != -1) {
                    clrText = this.selectionForeground;
                }
                if (OS.IsWindowEnabled(this.handle)) {
                    boolean drawForeground = false;
                    if (selected) {
                        if (i != 0 && (this.style & 0x10000) == 0) {
                            OS.SetTextColor(hDC, this.getForegroundPixel());
                            OS.SetBkColor(hDC, this.getBackgroundPixel());
                            drawBackground = true;
                            drawForeground = true;
                        }
                    } else {
                        drawBackground = true;
                        drawForeground = true;
                    }
                    if (drawForeground) {
                        int n2 = clrText = item.cellForeground != null ? item.cellForeground[index] : -1;
                        if (clrText == -1) {
                            clrText = item.foreground;
                        }
                    }
                    if (drawBackground) {
                        int n3 = clrTextBk = item.cellBackground != null ? item.cellBackground[index] : -1;
                        if (clrTextBk == -1) {
                            clrTextBk = item.background;
                        }
                        if (index == sortIndex) {
                            clrTextBk = clrSortBk;
                        }
                    }
                } else if (index == sortIndex) {
                    drawBackground = true;
                    clrTextBk = clrSortBk;
                }
                if (drawItem) {
                    if (i != 0) {
                        GC gc;
                        GCData data;
                        int nSavedDC;
                        if (this.hooks(41)) {
                            RECT itemRect = item.getBounds(index, true, true, false, false, false, hDC);
                            nSavedDC = OS.SaveDC(hDC);
                            data = new GCData();
                            data.device = this.display;
                            data.hFont = hFont;
                            gc = GC.win32_new(hDC, data);
                            event = new Event();
                            event.item = item;
                            event.index = index;
                            event.gc = gc;
                            event.x = itemRect.left;
                            event.y = itemRect.top;
                            event.width = itemRect.right - itemRect.left;
                            event.height = itemRect.bottom - itemRect.top;
                            this.sendEvent(41, event);
                            event.gc = null;
                            gc.dispose();
                            OS.RestoreDC(hDC, nSavedDC);
                            if (this.isDisposed() || item.isDisposed()) break;
                            if (event.height > this.getItemHeight()) {
                                this.setItemHeight(event.height);
                            }
                        }
                        if (this.hooks(40)) {
                            int uiState;
                            RECT cellRect = item.getBounds(index, true, true, true, true, true, hDC);
                            nSavedDC = OS.SaveDC(hDC);
                            data = new GCData();
                            data.device = this.display;
                            data.foreground = OS.GetTextColor(hDC);
                            data.background = OS.GetBkColor(hDC);
                            if (!selected || (this.style & 0x10000) == 0) {
                                if (clrText != -1) {
                                    data.foreground = clrText;
                                }
                                if (clrTextBk != -1) {
                                    data.background = clrTextBk;
                                }
                            }
                            data.hPen = OS.CreatePen(0, 0, data.foreground);
                            data.hBrush = OS.CreateSolidBrush(data.background);
                            data.hFont = hFont;
                            gc = GC.win32_new(hDC, data);
                            event = new Event();
                            event.item = item;
                            event.index = index;
                            event.gc = gc;
                            event.detail |= 0x10;
                            if (clrTextBk != -1) {
                                event.detail |= 8;
                            }
                            if (selected && (this.style & 0x10000) != 0) {
                                event.detail |= 2;
                            }
                            if ((nmcd.uItemState & 0x10) != 0 && (this.style & 0x10000) != 0 && this.handle == OS.GetFocus() && ((uiState = OS.SendMessage(this.handle, 297, 0, 0)) & 1) == 0) {
                                event.detail |= 4;
                            }
                            event.x = cellRect.left;
                            event.y = cellRect.top;
                            event.width = cellRect.right - cellRect.left;
                            event.height = cellRect.bottom - cellRect.top;
                            gc.setClipping(event.x, event.y, event.width, event.height);
                            this.sendEvent(40, event);
                            event.gc = null;
                            int newTextClr = OS.GetTextColor(hDC);
                            gc.dispose();
                            OS.RestoreDC(hDC, nSavedDC);
                            if (this.isDisposed() || item.isDisposed()) break;
                            if (event.doit) {
                                this.ignoreDrawForeground = (event.detail & 0x10) == 0;
                                this.ignoreDrawBackground = (event.detail & 8) == 0;
                                this.ignoreDrawSelection = (event.detail & 2) == 0;
                            } else {
                                this.ignoreDrawSelection = true;
                                this.ignoreDrawBackground = true;
                                this.ignoreDrawForeground = true;
                            }
                            if ((this.style & 0x10000) != 0) {
                                if (this.ignoreDrawSelection) {
                                    this.ignoreFullSelection = true;
                                }
                                if (!this.ignoreDrawSelection) {
                                    if (!selected) {
                                        this.selectionForeground = OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                                    } else {
                                        drawBackground = true;
                                        this.ignoreDrawBackground = false;
                                        clrTextBk = this.handle == OS.GetFocus() && OS.IsWindowEnabled(this.handle) ? OS.GetSysColor(OS.COLOR_HIGHLIGHT) : OS.GetSysColor(OS.COLOR_3DFACE);
                                        if (!this.ignoreFullSelection && index == count - 1) {
                                            RECT selectionRect = new RECT();
                                            OS.SetRect(selectionRect, backgroundRect.left, backgroundRect.top, nmcd.right, backgroundRect.bottom);
                                            backgroundRect = selectionRect;
                                        }
                                    }
                                } else if (selected) {
                                    this.selectionForeground = newTextClr;
                                    if (clrTextBk == -1 && OS.IsWindowEnabled(this.handle)) {
                                        Control control = this.findBackgroundControl();
                                        if (control == null) {
                                            control = this;
                                        }
                                        clrTextBk = control.getBackgroundPixel();
                                    }
                                }
                            }
                        }
                        if (this.selectionForeground != -1) {
                            clrText = this.selectionForeground;
                        }
                    }
                    if (!this.ignoreDrawBackground) {
                        if (clrTextBk != -1) {
                            if (drawBackground) {
                                this.fillBackground(hDC, clrTextBk, backgroundRect);
                            }
                        } else {
                            Control control = this.findImageControl();
                            if (control != null) {
                                if (i == 0) {
                                    int hItem;
                                    int uiState;
                                    int right = Math.min(rect.right, width);
                                    OS.SetRect(rect, rect.left, rect.top, right, rect.bottom);
                                    if (drawBackground) {
                                        this.fillImageBackground(hDC, control, rect);
                                    }
                                    if (!this.ignoreDrawSelection && this.handle == OS.GetFocus() && ((uiState = OS.SendMessage(this.handle, 297, 0, 0)) & 1) == 0 && (hItem = OS.SendMessage(this.handle, 4362, 9, 0)) == item.handle) {
                                        if ((this.style & 0x10000) != 0) {
                                            focusRect = new RECT();
                                            OS.SetRect(focusRect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                                        } else {
                                            focusRect = item.getBounds(index, true, false, false, false, true, hDC);
                                        }
                                    }
                                } else if (drawBackground) {
                                    this.fillImageBackground(hDC, control, rect);
                                }
                            }
                        }
                    }
                    if (drawImage) {
                        int inset;
                        Image image = null;
                        if (index == 0) {
                            image = item.image;
                        } else {
                            Image[] images = item.images;
                            if (images != null) {
                                image = images[index];
                            }
                        }
                        int n4 = inset = i != 0 ? 3 : 0;
                        if (image != null) {
                            if (index == 0) {
                                rect.left = Math.min(rect.right, rect.left + 2);
                            }
                            Rectangle bounds = image.getBounds();
                            if (size == null) {
                                size = this.getImageSize();
                            }
                            int y = rect.top;
                            if (!this.ignoreDrawForeground) {
                                GCData data = new GCData();
                                data.device = this.display;
                                GC gc = GC.win32_new(hDC, data);
                                gc.drawImage(image, 0, 0, bounds.width, bounds.height, rect.left, y, size.x, size.y);
                                gc.dispose();
                            }
                            OS.SetRect(rect, rect.left + size.x + 3, rect.top, rect.right - inset, rect.bottom);
                        } else {
                            OS.SetRect(rect, rect.left + 3, rect.top, rect.right - inset, rect.bottom);
                            if (i == 0 && OS.SendMessage(this.handle, 4360, 0, 0) != 0) {
                                if (size == null) {
                                    size = this.getImageSize();
                                }
                                rect.left = Math.min(rect.left + size.x, rect.right);
                            }
                        }
                    }
                    if (drawText && rect.left < rect.right) {
                        String string = null;
                        if (index == 0) {
                            string = item.text;
                            rect.left = Math.min(rect.right, rect.left + 2);
                        } else {
                            String[] strings = item.strings;
                            if (strings != null) {
                                string = strings[index];
                            }
                        }
                        if (string != null) {
                            TreeColumn column;
                            if (hFont != -1) {
                                hFont = OS.SelectObject(hDC, hFont);
                            }
                            if (clrText != -1) {
                                clrText = OS.SetTextColor(hDC, clrText);
                            }
                            if (clrTextBk != -1) {
                                clrTextBk = OS.SetBkColor(hDC, clrTextBk);
                            }
                            int flags = 2084;
                            if (i != 0) {
                                flags |= 0x8000;
                            }
                            TreeColumn treeColumn = column = this.columns != null ? this.columns[index] : null;
                            if (column != null) {
                                if ((column.style & 0x1000000) != 0) {
                                    flags |= 1;
                                }
                                if ((column.style & 0x20000) != 0) {
                                    flags |= 2;
                                }
                            }
                            TCHAR buffer = new TCHAR(this.getCodePage(), string, false);
                            if (!this.ignoreDrawForeground) {
                                OS.DrawText(hDC, buffer, buffer.length(), rect, flags);
                            }
                            OS.DrawText(hDC, buffer, buffer.length(), rect, flags | 0x400);
                            if (hFont != -1) {
                                hFont = OS.SelectObject(hDC, hFont);
                            }
                            if (clrText != -1) {
                                clrText = OS.SetTextColor(hDC, clrText);
                            }
                            if (clrTextBk != -1) {
                                clrTextBk = OS.SetBkColor(hDC, clrTextBk);
                            }
                        }
                    }
                }
                if (this.selectionForeground != -1) {
                    clrText = this.selectionForeground;
                }
                if (this.hooks(42)) {
                    int uiState;
                    RECT itemRect = item.getBounds(index, true, true, false, false, false, hDC);
                    int nSavedDC = OS.SaveDC(hDC);
                    GCData data = new GCData();
                    data.device = this.display;
                    data.hFont = hFont;
                    data.foreground = OS.GetTextColor(hDC);
                    data.background = OS.GetBkColor(hDC);
                    if (selected && (this.style & 0x10000) != 0) {
                        if (this.selectionForeground != -1) {
                            data.foreground = this.selectionForeground;
                        }
                    } else {
                        if (clrText != -1) {
                            data.foreground = clrText;
                        }
                        if (clrTextBk != -1) {
                            data.background = clrTextBk;
                        }
                    }
                    data.hPen = OS.CreatePen(0, 0, data.foreground);
                    data.hBrush = OS.CreateSolidBrush(data.background);
                    OS.SelectObject(hDC, data.hPen);
                    OS.SelectObject(hDC, data.hBrush);
                    GC gc = GC.win32_new(hDC, data);
                    event = new Event();
                    event.item = item;
                    event.index = index;
                    event.gc = gc;
                    event.detail |= 0x10;
                    if (clrTextBk != -1) {
                        event.detail |= 8;
                    }
                    if (selected && (i == 0 || (this.style & 0x10000) != 0)) {
                        event.detail |= 2;
                    }
                    if ((nmcd.uItemState & 0x10) != 0 && (i == 0 || (this.style & 0x10000) != 0) && this.handle == OS.GetFocus() && ((uiState = OS.SendMessage(this.handle, 297, 0, 0)) & 1) == 0) {
                        event.detail |= 4;
                    }
                    event.x = itemRect.left;
                    event.y = itemRect.top;
                    event.width = itemRect.right - itemRect.left;
                    event.height = itemRect.bottom - itemRect.top;
                    RECT cellRect = item.getBounds(index, true, true, true, true, true, hDC);
                    int cellWidth = cellRect.right - cellRect.left;
                    int cellHeight = cellRect.bottom - cellRect.top;
                    gc.setClipping(cellRect.left, cellRect.top, cellWidth, cellHeight);
                    this.sendEvent(42, event);
                    event.gc = null;
                    gc.dispose();
                    OS.RestoreDC(hDC, nSavedDC);
                    if (this.isDisposed() || item.isDisposed()) break;
                }
            }
            if ((x += width) > clientRect.right) break;
            ++i;
        }
        if (this.linesVisible) {
            if ((this.style & 0x10000) != 0 && this.hwndHeader != 0 && OS.SendMessage(this.hwndHeader, 4608, 0, 0) != 0) {
                HDITEM hdItem = new HDITEM();
                hdItem.mask = 1;
                OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, 0, hdItem);
                RECT rect = new RECT();
                OS.SetRect(rect, nmcd.left + hdItem.cxy, nmcd.top, nmcd.right, nmcd.bottom);
                OS.DrawEdge(hDC, rect, 8, 8);
            }
            RECT rect = new RECT();
            OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
            OS.DrawEdge(hDC, rect, 8, 8);
        }
        if (focusRect != null) {
            OS.DrawFocusRect(hDC, focusRect);
        }
        return new LRESULT(0);
    }

    LRESULT CDDS_ITEMPREPAINT(int wParam, int lParam) {
        int hFont;
        NMTVCUSTOMDRAW nmcd = new NMTVCUSTOMDRAW();
        OS.MoveMemory(nmcd, lParam, NMTVCUSTOMDRAW.sizeof);
        int id = nmcd.lItemlParam;
        if ((this.style & 0x10000000) != 0 && id == -1) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 20;
            tvItem.hItem = nmcd.dwItemSpec;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            id = tvItem.lParam;
        }
        TreeItem item = this._getItem(nmcd.dwItemSpec, id);
        if (this.ignoreCustomDraw) {
            int hFont2;
            int hDC = nmcd.hdc;
            int index = this.hwndHeader != 0 ? OS.SendMessage(this.hwndHeader, 4623, 0, 0) : 0;
            int n = hFont2 = item.cellFont != null ? item.cellFont[index] : -1;
            if (hFont2 == -1) {
                hFont2 = item.font;
            }
            if (hFont2 != -1) {
                OS.SelectObject(hDC, hFont2);
            }
            return new LRESULT(hFont2 == -1 ? 0 : 2);
        }
        if (item == null) {
            return null;
        }
        RECT clipRect = null;
        int index = 0;
        int count = 0;
        if (this.hwndHeader != 0) {
            index = OS.SendMessage(this.hwndHeader, 4623, 0, 0);
            count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
            if (count != 0 && !this.printClient) {
                clipRect = new RECT();
                HDITEM hdItem = new HDITEM();
                hdItem.mask = 1;
                OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, index, hdItem);
                OS.SetRect(clipRect, nmcd.left, nmcd.top, nmcd.left + hdItem.cxy, nmcd.bottom);
            }
        }
        int clrText = -1;
        int clrTextBk = -1;
        int n = hFont = item.cellFont != null ? item.cellFont[index] : -1;
        if (hFont == -1) {
            hFont = item.font;
        }
        if (OS.IsWindowEnabled(this.handle)) {
            int n2 = clrText = item.cellForeground != null ? item.cellForeground[index] : -1;
            if (clrText == -1) {
                clrText = item.foreground;
            }
            int n3 = clrTextBk = item.cellBackground != null ? item.cellBackground[index] : -1;
            if (clrTextBk == -1) {
                clrTextBk = item.background;
            }
        }
        int clrSortBk = -1;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && this.findImageControl() == null && this.indexOf(this.sortColumn) == index) {
            clrTextBk = clrSortBk = this.getSortColumnPixel();
        }
        int hDC = nmcd.hdc;
        boolean selected = false;
        if (OS.IsWindowEnabled(this.handle)) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 24;
            tvItem.hItem = item.handle;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if ((tvItem.state & 0xA) != 0) {
                selected = true;
                if (this.handle == OS.GetFocus()) {
                    if (OS.GetTextColor(hDC) != OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT)) {
                        selected = false;
                    } else if (OS.GetBkColor(hDC) != OS.GetSysColor(OS.COLOR_HIGHLIGHT)) {
                        selected = false;
                    }
                }
            }
        }
        if (OS.IsWindowVisible(this.handle) && nmcd.left < nmcd.right && nmcd.top < nmcd.bottom) {
            int bits;
            RECT rect;
            if (hFont != -1) {
                OS.SelectObject(hDC, hFont);
            }
            if (this.linesVisible) {
                rect = new RECT();
                OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                OS.DrawEdge(hDC, rect, 8, 8);
            }
            if (this.hooks(41)) {
                RECT itemRect = item.getBounds(index, true, true, false, false, false, hDC);
                int nSavedDC = OS.SaveDC(hDC);
                GCData data = new GCData();
                data.device = this.display;
                data.hFont = hFont;
                GC gc = GC.win32_new(hDC, data);
                Event event = new Event();
                event.item = item;
                event.gc = gc;
                event.index = index;
                event.x = itemRect.left;
                event.y = itemRect.top;
                event.width = itemRect.right - itemRect.left;
                event.height = itemRect.bottom - itemRect.top;
                this.sendEvent(41, event);
                event.gc = null;
                gc.dispose();
                OS.RestoreDC(hDC, nSavedDC);
                if (this.isDisposed() || item.isDisposed()) {
                    return null;
                }
                if (this.hwndHeader != 0 && count == 0 && event.x + event.width > this.scrollWidth) {
                    this.scrollWidth = event.x + event.width;
                    this.setScrollWidth(this.scrollWidth);
                }
                if (event.height > this.getItemHeight()) {
                    this.setItemHeight(event.height);
                }
            }
            this.selectionForeground = -1;
            this.ignoreDrawBackground = false;
            this.ignoreFullSelection = false;
            this.ignoreDrawSelection = false;
            this.ignoreDrawForeground = false;
            if (this.hooks(40)) {
                RECT textRect;
                int uiState;
                rect = new RECT();
                OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                if (OS.IsWindowEnabled(this.handle) || this.findImageControl() != null) {
                    this.drawBackground(hDC, rect);
                } else {
                    this.fillBackground(hDC, OS.GetBkColor(hDC), rect);
                }
                RECT cellRect = item.getBounds(index, true, true, true, true, true, hDC);
                if (clrSortBk != -1) {
                    RECT fullRect = item.getBounds(index, true, true, true, true, true, hDC);
                    this.drawBackground(hDC, fullRect, clrSortBk);
                }
                int nSavedDC = OS.SaveDC(hDC);
                GCData data = new GCData();
                data.device = this.display;
                data.foreground = OS.GetTextColor(hDC);
                data.background = OS.GetBkColor(hDC);
                if (!selected) {
                    if (clrText != -1) {
                        data.foreground = clrText;
                    }
                    if (clrTextBk != -1) {
                        data.background = clrTextBk;
                    }
                }
                data.hPen = OS.CreatePen(0, 0, data.foreground);
                data.hBrush = OS.CreateSolidBrush(data.background);
                if (hFont != -1) {
                    data.hFont = hFont;
                }
                OS.SelectObject(hDC, data.hPen);
                OS.SelectObject(hDC, data.hBrush);
                GC gc = GC.win32_new(hDC, data);
                Event event = new Event();
                event.index = index;
                event.item = item;
                event.gc = gc;
                event.detail |= 0x10;
                if (clrTextBk != -1) {
                    event.detail |= 8;
                }
                if (selected) {
                    event.detail |= 2;
                }
                if ((nmcd.uItemState & 0x10) != 0 && (this.style & 0x10000) != 0 && this.handle == OS.GetFocus() && ((uiState = OS.SendMessage(this.handle, 297, 0, 0)) & 1) == 0) {
                    event.detail |= 4;
                }
                event.x = cellRect.left;
                event.y = cellRect.top;
                event.width = cellRect.right - cellRect.left;
                event.height = cellRect.bottom - cellRect.top;
                gc.setClipping(event.x, event.y, event.width, event.height);
                this.sendEvent(40, event);
                event.gc = null;
                int newTextClr = OS.GetTextColor(hDC);
                gc.dispose();
                OS.RestoreDC(hDC, nSavedDC);
                if (this.isDisposed() || item.isDisposed()) {
                    return null;
                }
                if (event.doit) {
                    this.ignoreDrawForeground = (event.detail & 0x10) == 0;
                    this.ignoreDrawSelection = (event.detail & 2) == 0;
                    this.ignoreDrawBackground = (event.detail & 8) == 0;
                } else {
                    this.ignoreDrawBackground = true;
                    this.ignoreDrawSelection = true;
                    this.ignoreDrawForeground = true;
                }
                if (!this.ignoreDrawBackground && clrTextBk != -1) {
                    if (count == 0) {
                        if ((this.style & 0x10000) != 0) {
                            this.fillBackground(hDC, clrTextBk, rect);
                        } else {
                            textRect = item.getBounds(index, true, false, true, false, true, hDC);
                            this.fillBackground(hDC, clrTextBk, textRect);
                        }
                    } else {
                        this.fillBackground(hDC, clrTextBk, cellRect);
                    }
                }
                if (this.ignoreDrawSelection) {
                    this.ignoreFullSelection = true;
                }
                if (!this.ignoreDrawSelection) {
                    if (!selected) {
                        this.selectionForeground = clrText = OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                    }
                    if ((this.style & 0x10000) != 0) {
                        if ((this.style & 0x10000) != 0 && count == 0) {
                            this.fillBackground(hDC, OS.GetBkColor(hDC), rect);
                        } else {
                            this.fillBackground(hDC, OS.GetBkColor(hDC), cellRect);
                        }
                    } else {
                        textRect = item.getBounds(index, true, false, false, false, true, hDC);
                        this.fillBackground(hDC, OS.GetBkColor(hDC), textRect);
                    }
                } else if (selected) {
                    this.selectionForeground = clrText = newTextClr;
                    this.ignoreDrawSelection = true;
                }
                RECT itemRect = item.getBounds(index, true, true, false, false, false, hDC);
                OS.SaveDC(hDC);
                OS.SelectClipRgn(hDC, 0);
                ++itemRect.right;
                if (this.linesVisible) {
                    ++itemRect.bottom;
                }
                if (clipRect != null) {
                    OS.IntersectClipRect(hDC, clipRect.left, clipRect.top, clipRect.right, clipRect.bottom);
                }
                OS.ExcludeClipRect(hDC, itemRect.left, itemRect.top, itemRect.right, itemRect.bottom);
                return new LRESULT(16);
            }
            if ((this.style & 0x10000) != 0 && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x1000) == 0) {
                RECT rect2 = new RECT();
                OS.SetRect(rect2, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                if (selected) {
                    this.fillBackground(hDC, OS.GetBkColor(hDC), rect2);
                } else if (OS.IsWindowEnabled(this.handle)) {
                    this.drawBackground(hDC, rect2);
                }
                nmcd.uItemState &= 0xFFFFFFEF;
                OS.MoveMemory(lParam, nmcd, 60);
            }
        }
        LRESULT result = null;
        if (clrText == -1 && clrTextBk == -1 && hFont == -1) {
            result = new LRESULT(16);
        } else {
            result = new LRESULT(18);
            if (hFont != -1) {
                OS.SelectObject(hDC, hFont);
            }
            if (OS.IsWindowEnabled(this.handle) && OS.IsWindowVisible(this.handle)) {
                int bits;
                if (clrTextBk != -1 && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x1000) == 0) {
                    RECT rect;
                    if (count != 0 && this.hwndHeader != 0) {
                        rect = new RECT();
                        HDITEM hdItem = new HDITEM();
                        hdItem.mask = 1;
                        OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, index, hdItem);
                        OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.left + hdItem.cxy, nmcd.bottom);
                        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
                            RECT itemRect = new RECT();
                            itemRect.left = item.handle;
                            if (OS.SendMessage(this.handle, 4356, 1, itemRect) != 0) {
                                rect.left = Math.min(itemRect.left, rect.right);
                            }
                        }
                        if ((this.style & 0x10000) != 0) {
                            if (!selected) {
                                this.fillBackground(hDC, clrTextBk, rect);
                            }
                        } else {
                            this.fillBackground(hDC, clrTextBk, rect);
                        }
                    } else if ((this.style & 0x10000) != 0) {
                        rect = new RECT();
                        OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                        if (!selected) {
                            this.fillBackground(hDC, clrTextBk, rect);
                        }
                    }
                }
                if (!selected) {
                    nmcd.clrText = clrText == -1 ? this.getForegroundPixel() : clrText;
                    nmcd.clrTextBk = clrTextBk == -1 ? this.getBackgroundPixel() : clrTextBk;
                    OS.MoveMemory(lParam, nmcd, NMTVCUSTOMDRAW.sizeof);
                }
            }
        }
        if (!OS.IsWindowEnabled(this.handle) && clrSortBk != -1) {
            RECT rect = new RECT();
            HDITEM hdItem = new HDITEM();
            hdItem.mask = 1;
            OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, index, hdItem);
            OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.left + hdItem.cxy, nmcd.bottom);
            this.fillBackground(hDC, clrSortBk, rect);
        }
        OS.SaveDC(hDC);
        if (clipRect != null) {
            int hRgn = OS.CreateRectRgn(clipRect.left, clipRect.top, clipRect.right, clipRect.bottom);
            OS.SelectClipRgn(hDC, hRgn);
            OS.DeleteObject(hRgn);
        }
        return result;
    }

    LRESULT CDDS_POSTPAINT(int wParam, int lParam) {
        if (this.ignoreCustomDraw) {
            return null;
        }
        if (OS.IsWindowVisible(this.handle)) {
            int index;
            if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && this.findImageControl() == null && (index = this.indexOf(this.sortColumn)) != -1) {
                RECT rect;
                NMTVCUSTOMDRAW nmcd = new NMTVCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, NMTVCUSTOMDRAW.sizeof);
                int top = nmcd.top;
                int hItem = OS.SendMessage(this.handle, 4362, 10, 0);
                if (hItem != 0) {
                    rect = new RECT();
                    rect.left = hItem;
                    if (OS.SendMessage(this.handle, 4356, 0, rect) != 0) {
                        top = rect.bottom;
                    }
                }
                rect = new RECT();
                OS.SetRect(rect, nmcd.left, top, nmcd.right, nmcd.bottom);
                RECT headerRect = new RECT();
                OS.SendMessage(this.hwndHeader, 4615, index, headerRect);
                rect.left = headerRect.left;
                rect.right = headerRect.right;
                this.fillBackground(nmcd.hdc, this.getSortColumnPixel(), rect);
            }
            if (this.linesVisible) {
                NMTVCUSTOMDRAW nmcd = new NMTVCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, NMTVCUSTOMDRAW.sizeof);
                int hDC = nmcd.hdc;
                if (this.hwndHeader != 0) {
                    int x = 0;
                    RECT rect = new RECT();
                    HDITEM hdItem = new HDITEM();
                    hdItem.mask = 1;
                    int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
                    int i = 0;
                    while (i < count) {
                        int index2 = OS.SendMessage(this.hwndHeader, 4623, i, 0);
                        OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, index2, hdItem);
                        OS.SetRect(rect, x, nmcd.top, x + hdItem.cxy, nmcd.bottom);
                        OS.DrawEdge(hDC, rect, 8, 4);
                        x += hdItem.cxy;
                        ++i;
                    }
                }
                int height = 0;
                RECT rect = new RECT();
                int hItem = OS.SendMessage(this.handle, 4362, 10, 0);
                if (hItem != 0) {
                    rect.left = hItem;
                    if (OS.SendMessage(this.handle, 4356, 0, rect) != 0) {
                        height = rect.bottom - rect.top;
                    }
                }
                if (height == 0) {
                    height = OS.SendMessage(this.handle, 4380, 0, 0);
                    OS.GetClientRect(this.handle, rect);
                    OS.SetRect(rect, rect.left, rect.top, rect.right, rect.top + height);
                    OS.DrawEdge(hDC, rect, 8, 8);
                }
                while (rect.bottom < nmcd.bottom) {
                    int top = rect.top + height;
                    OS.SetRect(rect, rect.left, top, rect.right, top + height);
                    OS.DrawEdge(hDC, rect, 8, 8);
                }
            }
        }
        return new LRESULT(0);
    }

    LRESULT CDDS_PREPAINT(int wParam, int lParam) {
        return new LRESULT(48);
    }

    int callWindowProc(int hwnd, int msg, int wParam, int lParam) {
        int hItem;
        if (this.handle == 0) {
            return 0;
        }
        if (this.hwndParent != 0 && hwnd == this.hwndParent) {
            return OS.DefWindowProc(hwnd, msg, wParam, lParam);
        }
        if (this.hwndHeader != 0 && hwnd == this.hwndHeader) {
            return OS.CallWindowProc(HeaderProc, hwnd, msg, wParam, lParam);
        }
        switch (msg) {
            case 7: {
                if ((this.style & 4) != 0 || (hItem = OS.SendMessage(this.handle, 4362, 9, 0)) != 0 || (hItem = OS.SendMessage(this.handle, 4362, 5, 0)) == 0) break;
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 24;
                tvItem.hItem = hItem;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                this.hSelect = hItem;
                this.lockSelection = true;
                this.ignoreSelect = true;
                this.ignoreDeselect = true;
                OS.SendMessage(this.handle, 4363, 9, hItem);
                this.lockSelection = false;
                this.ignoreSelect = false;
                this.ignoreDeselect = false;
                this.hSelect = 0;
                if ((tvItem.state & 2) != 0) break;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            }
        }
        hItem = 0;
        boolean redraw = false;
        switch (msg) {
            case 256: {
                if (wParam == 17 || wParam == 16) break;
            }
            case 5: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 277: 
            case 646: {
                boolean bl = redraw = this.findImageControl() != null && this.drawCount == 0 && OS.IsWindowVisible(this.handle);
                if (redraw) {
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                }
            }
            case 48: 
            case 275: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 673: 
            case 675: {
                if (this.findImageControl() == null) break;
                hItem = OS.SendMessage(this.handle, 4362, 5, 0);
            }
        }
        int code = OS.CallWindowProc(TreeProc, hwnd, msg, wParam, lParam);
        switch (msg) {
            case 256: {
                if (wParam == 17 || wParam == 16) break;
            }
            case 5: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 277: 
            case 646: {
                if (redraw) {
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    OS.InvalidateRect(this.handle, null, true);
                    if (this.hwndHeader != 0) {
                        OS.InvalidateRect(this.hwndHeader, null, true);
                    }
                }
            }
            case 48: 
            case 275: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 673: 
            case 675: {
                if (this.findImageControl() != null && hItem != OS.SendMessage(this.handle, 4362, 5, 0)) {
                    OS.InvalidateRect(this.handle, null, true);
                }
                this.updateScrollBar();
                break;
            }
            case 15: {
                this.painted = true;
            }
        }
        return code;
    }

    void checkBuffered() {
        super.checkBuffered();
        if ((this.style & 0x10000000) != 0) {
            this.style |= 0x20000000;
            OS.SendMessage(this.handle, 4385, 0, 0);
        }
    }

    boolean checkData(TreeItem item, boolean redraw) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        TreeItem parentItem = item.getParentItem();
        return this.checkData(item, parentItem == null ? this.indexOf(item) : parentItem.indexOf(item), redraw);
    }

    boolean checkData(TreeItem item, int index, boolean redraw) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        if (!item.cached) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            event.index = index;
            TreeItem oldItem = this.currentItem;
            this.currentItem = item;
            this.sendEvent(36, event);
            this.currentItem = oldItem;
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
            if (redraw) {
                item.redraw();
            }
        }
        return true;
    }

    boolean checkHandle(int hwnd) {
        return hwnd == this.handle || this.hwndParent != 0 && hwnd == this.hwndParent || this.hwndHeader != 0 && hwnd == this.hwndHeader;
    }

    boolean checkScroll(int hItem) {
        if (this.drawCount == 0) {
            return false;
        }
        int hRoot = OS.SendMessage(this.handle, 4362, 0, 0);
        int hParent = OS.SendMessage(this.handle, 4362, 3, hItem);
        while (hParent != hRoot && hParent != 0) {
            hParent = OS.SendMessage(this.handle, 4362, 3, hParent);
        }
        return hParent == 0;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
        if (hItem == 0) {
            this.error(6);
        }
        if ((hItem = this.findItem(hItem, index)) == 0) {
            this.error(6);
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        this.clear(hItem, tvItem);
        if (all) {
            hItem = OS.SendMessage(this.handle, 4362, 4, hItem);
            this.clearAll(hItem, tvItem, all);
        }
    }

    void clear(int hItem, TVITEM tvItem) {
        tvItem.hItem = hItem;
        TreeItem item = null;
        if (OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem) != 0) {
            TreeItem treeItem = item = tvItem.lParam != -1 ? this.items[tvItem.lParam] : null;
        }
        if (item != null) {
            item.clear();
            item.redraw();
        }
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
        if (hItem == 0) {
            return;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        this.clearAll(hItem, tvItem, all);
    }

    void clearAll(int hItem, TVITEM tvItem, boolean all) {
        while (hItem != 0) {
            this.clear(hItem, tvItem);
            int hFirstItem = OS.SendMessage(this.handle, 4362, 4, hItem);
            if (all) {
                this.clearAll(hFirstItem, tvItem, all);
            }
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (this.hwndHeader != 0) {
            HDITEM hdItem = new HDITEM();
            hdItem.mask = 1;
            int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
            int i = 0;
            while (i < count) {
                OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, i, hdItem);
                width += hdItem.cxy;
                ++i;
            }
            RECT rect = new RECT();
            OS.GetWindowRect(this.hwndHeader, rect);
            height += rect.bottom - rect.top;
        }
        RECT rect = new RECT();
        int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
        while (hItem != 0) {
            if ((this.style & 0x10000000) == 0 && !this.painted) {
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 17;
                tvItem.hItem = hItem;
                tvItem.pszText = -1;
                this.ignoreCustomDraw = true;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                this.ignoreCustomDraw = false;
            }
            rect.left = hItem;
            if (OS.SendMessage(this.handle, 4356, 1, rect) != 0) {
                width = Math.max(width, rect.right);
                height += rect.bottom - rect.top;
            }
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            height += OS.GetSystemMetrics(3);
        }
        return new Point(width, height);
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if (!OS.IsWinCE && OS.COMCTL32_MAJOR < 6) {
            OS.SendMessage(this.handle, 8199, 5, 0);
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
        int hFont = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, hFont, 0);
    }

    void createHeaderToolTips() {
        if (OS.IsWinCE) {
            return;
        }
        if (this.headerToolTipHandle != 0) {
            return;
        }
        this.headerToolTipHandle = OS.CreateWindowEx(0, new TCHAR(0, "tooltips_class32", true), null, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, this.handle, 0, OS.GetModuleHandle(null), null);
        if (this.headerToolTipHandle == 0) {
            this.error(2);
        }
        OS.SendMessage(this.headerToolTipHandle, 1048, 0, Short.MAX_VALUE);
    }

    void createItem(TreeColumn column, int index) {
        RECT rect;
        if (this.hwndHeader == 0) {
            this.createParent();
        }
        int columnCount = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        if (index < 0 || index > columnCount) {
            this.error(6);
        }
        if (columnCount == this.columns.length) {
            TreeColumn[] newColumns = new TreeColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                int[] temp;
                Image[] images;
                String[] strings = item.strings;
                if (strings != null) {
                    String[] temp2 = new String[columnCount + 1];
                    System.arraycopy(strings, 0, temp2, 0, index);
                    System.arraycopy(strings, index, temp2, index + 1, columnCount - index);
                    item.strings = temp2;
                }
                if ((images = item.images) != null) {
                    Image[] temp3 = new Image[columnCount + 1];
                    System.arraycopy(images, 0, temp3, 0, index);
                    System.arraycopy(images, index, temp3, index + 1, columnCount - index);
                    item.images = temp3;
                }
                if (index == 0 && columnCount != 0) {
                    if (strings == null) {
                        item.strings = new String[columnCount + 1];
                        item.strings[1] = item.text;
                    }
                    item.text = "";
                    if (images == null) {
                        item.images = new Image[columnCount + 1];
                        item.images[1] = item.image;
                    }
                    item.image = null;
                }
                if (item.cellBackground != null) {
                    int[] cellBackground = item.cellBackground;
                    temp = new int[columnCount + 1];
                    System.arraycopy(cellBackground, 0, temp, 0, index);
                    System.arraycopy(cellBackground, index, temp, index + 1, columnCount - index);
                    temp[index] = -1;
                    item.cellBackground = temp;
                }
                if (item.cellForeground != null) {
                    int[] cellForeground = item.cellForeground;
                    temp = new int[columnCount + 1];
                    System.arraycopy(cellForeground, 0, temp, 0, index);
                    System.arraycopy(cellForeground, index, temp, index + 1, columnCount - index);
                    temp[index] = -1;
                    item.cellForeground = temp;
                }
                if (item.cellFont != null) {
                    int[] cellFont = item.cellFont;
                    temp = new int[columnCount + 1];
                    System.arraycopy(cellFont, 0, temp, 0, index);
                    System.arraycopy(cellFont, index, temp, index + 1, columnCount - index);
                    temp[index] = -1;
                    item.cellFont = temp;
                }
            }
            ++i;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, columnCount - index);
        this.columns[index] = column;
        int hHeap = OS.GetProcessHeap();
        int pszText = OS.HeapAlloc(hHeap, 8, TCHAR.sizeof);
        HDITEM hdItem = new HDITEM();
        hdItem.mask = 6;
        hdItem.pszText = pszText;
        if ((column.style & 0x4000) == 16384) {
            hdItem.fmt = 0;
        }
        if ((column.style & 0x1000000) == 0x1000000) {
            hdItem.fmt = 2;
        }
        if ((column.style & 0x20000) == 131072) {
            hdItem.fmt = 1;
        }
        OS.SendMessage(this.hwndHeader, OS.HDM_INSERTITEM, index, hdItem);
        if (pszText != 0) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        if (columnCount == 0) {
            this.scrollWidth = 0;
            int bits = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, bits |= 0x8000);
            int count = OS.SendMessage(this.handle, 4357, 0, 0);
            if (count != 0 && !OS.IsWinCE) {
                OS.ShowScrollBar(this.handle, 0, false);
            }
        }
        this.setScrollWidth();
        this.updateImageList();
        this.updateScrollBar();
        if (columnCount == 0 && OS.SendMessage(this.handle, 4357, 0, 0) != 0) {
            OS.InvalidateRect(this.handle, null, true);
        }
        if (this.headerToolTipHandle != 0 && OS.SendMessage(this.hwndHeader, 4615, index, rect = new RECT()) != 0) {
            TOOLINFO lpti = new TOOLINFO();
            lpti.cbSize = TOOLINFO.sizeof;
            lpti.uFlags = 16;
            lpti.hwnd = this.hwndHeader;
            column.id = this.display.nextToolTipId++;
            lpti.uId = column.id;
            lpti.left = rect.left;
            lpti.top = rect.top;
            lpti.right = rect.right;
            lpti.bottom = rect.bottom;
            lpti.lpszText = -1;
            OS.SendMessage(this.headerToolTipHandle, OS.TTM_ADDTOOL, 0, lpti);
        }
    }

    void createItem(TreeItem item, int hParent, int hInsertAfter, int hItem) {
        boolean fixParent;
        int id = -1;
        if (item != null) {
            id = this.lastID < this.items.length ? this.lastID : 0;
            while (id < this.items.length && this.items[id] != null) {
                ++id;
            }
            if (id == this.items.length) {
                int length = 0;
                if (this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                    length = this.items.length + 4;
                } else {
                    this.shrink = true;
                    length = Math.max(4, this.items.length * 3 / 2);
                }
                TreeItem[] newItems = new TreeItem[length];
                System.arraycopy(this.items, 0, newItems, 0, this.items.length);
                this.items = newItems;
            }
            this.lastID = id + 1;
        }
        int hNewItem = 0;
        int hFirstItem = OS.SendMessage(this.handle, 4362, 4, hParent);
        boolean bl = fixParent = hFirstItem == 0;
        if (hItem == 0) {
            TVINSERTSTRUCT tvInsert = new TVINSERTSTRUCT();
            tvInsert.hParent = hParent;
            tvInsert.hInsertAfter = hInsertAfter;
            tvInsert.lParam = id;
            tvInsert.pszText = -1;
            tvInsert.iSelectedImage = -1;
            tvInsert.iImage = -1;
            tvInsert.mask = 55;
            if ((this.style & 0x20) != 0) {
                tvInsert.mask |= 8;
                tvInsert.state = 4096;
                tvInsert.stateMask = 61440;
            }
            if ((hNewItem = OS.SendMessage(this.handle, OS.TVM_INSERTITEM, 0, tvInsert)) == 0) {
                this.error(14);
            }
        } else {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 20;
            tvItem.hItem = hNewItem = hItem;
            tvItem.lParam = id;
            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
        }
        if (item != null) {
            item.handle = hNewItem;
            this.items[id] = item;
        }
        if (hFirstItem == 0) {
            switch (hInsertAfter) {
                case -65535: 
                case -65534: {
                    this.hLastIndexOf = hFirstItem = hNewItem;
                    this.hFirstIndexOf = hFirstItem;
                    this.lastIndexOf = 0;
                    this.itemCount = 0;
                }
            }
        }
        if (hFirstItem == this.hFirstIndexOf && this.itemCount != -1) {
            ++this.itemCount;
        }
        if (hItem == 0) {
            RECT rect;
            if (fixParent && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                rect = new RECT();
                rect.left = hParent;
                if (OS.SendMessage(this.handle, 4356, 0, rect) != 0) {
                    OS.InvalidateRect(this.handle, rect, true);
                }
            }
            if ((this.style & 0x10000000) != 0 && this.currentItem != null) {
                RECT damageRect;
                boolean damaged;
                rect = new RECT();
                rect.left = hNewItem;
                if (OS.SendMessage(this.handle, 4356, 0, rect) != 0 && (damaged = OS.GetUpdateRect(this.handle, damageRect = new RECT(), true)) && damageRect.top < rect.bottom) {
                    if (OS.IsWinCE) {
                        OS.OffsetRect(damageRect, 0, rect.bottom - rect.top);
                        OS.InvalidateRect(this.handle, damageRect, true);
                    } else {
                        int rgn = OS.CreateRectRgn(0, 0, 0, 0);
                        int result = OS.GetUpdateRgn(this.handle, rgn, true);
                        if (result != 1) {
                            OS.OffsetRgn(rgn, 0, rect.bottom - rect.top);
                            OS.InvalidateRgn(this.handle, rgn, true);
                        }
                        OS.DeleteObject(rgn);
                    }
                }
            }
            this.updateScrollBar();
        }
    }

    void createItemToolTips() {
        if (OS.IsWinCE) {
            return;
        }
        if (this.itemToolTipHandle != 0) {
            return;
        }
        int bits = OS.GetWindowLong(this.handle, -16);
        OS.SetWindowLong(this.handle, -16, bits |= 0x80);
        this.itemToolTipHandle = OS.CreateWindowEx(0, new TCHAR(0, "tooltips_class32", true), null, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, this.handle, 0, OS.GetModuleHandle(null), null);
        if (this.itemToolTipHandle == 0) {
            this.error(2);
        }
        OS.SendMessage(this.itemToolTipHandle, 1048, 0, Short.MAX_VALUE);
        TOOLINFO lpti = new TOOLINFO();
        lpti.cbSize = TOOLINFO.sizeof;
        lpti.hwnd = this.handle;
        lpti.uId = this.handle;
        lpti.uFlags = 272;
        lpti.lpszText = -1;
        OS.SendMessage(this.itemToolTipHandle, OS.TTM_ADDTOOL, 0, lpti);
    }

    void createParent() {
        int hwndFocus;
        int hFont;
        this.forceResize();
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        OS.MapWindowPoints(0, this.parent.handle, rect, 2);
        int oldStyle = OS.GetWindowLong(this.handle, -16);
        int newStyle = super.widgetStyle() & 0xEFFFFFFF;
        if ((oldStyle & 0x4000000) != 0) {
            newStyle |= 0x4000000;
        }
        this.hwndParent = OS.CreateWindowEx(super.widgetExtStyle(), super.windowClass(), null, newStyle, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, this.parent.handle, 0, OS.GetModuleHandle(null), null);
        if (this.hwndParent == 0) {
            this.error(2);
        }
        OS.SetWindowLong(this.hwndParent, -12, this.hwndParent);
        int bits = 0;
        if (OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            bits |= 0x100000;
            if ((this.style & 0x4000000) != 0) {
                bits |= 0x400000;
            }
        }
        this.hwndHeader = OS.CreateWindowEx(bits, HeaderClass, null, 1140850890, 0, 0, 0, 0, this.hwndParent, 0, OS.GetModuleHandle(null), null);
        if (this.hwndHeader == 0) {
            this.error(2);
        }
        OS.SetWindowLong(this.hwndHeader, -12, this.hwndHeader);
        if (OS.IsDBLocale) {
            int hIMC = OS.ImmGetContext(this.handle);
            OS.ImmAssociateContext(this.hwndParent, hIMC);
            OS.ImmAssociateContext(this.hwndHeader, hIMC);
            OS.ImmReleaseContext(this.handle, hIMC);
        }
        if (!OS.IsPPC && (this.style & 0x800) != 0) {
            int oldExStyle = OS.GetWindowLong(this.handle, -20);
            OS.SetWindowLong(this.handle, -20, oldExStyle &= 0xFFFFFDFF);
        }
        if ((hFont = OS.SendMessage(this.handle, 49, 0, 0)) != 0) {
            OS.SendMessage(this.hwndHeader, 48, hFont, 0);
        }
        int hwndInsertAfter = OS.GetWindow(this.handle, 3);
        int flags = 19;
        this.SetWindowPos(this.hwndParent, hwndInsertAfter, 0, 0, 0, 0, flags);
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        info.fMask = 3;
        OS.GetScrollInfo(this.hwndParent, 0, info);
        info.nPage = info.nMax + 1;
        OS.SetScrollInfo(this.hwndParent, 0, info, true);
        OS.GetScrollInfo(this.hwndParent, 1, info);
        info.nPage = info.nMax + 1;
        OS.SetScrollInfo(this.hwndParent, 1, info, true);
        this.customDraw = true;
        this.deregister();
        if ((oldStyle & 0x10000000) != 0) {
            OS.ShowWindow(this.hwndParent, 5);
        }
        if ((hwndFocus = OS.GetFocus()) == this.handle) {
            OS.SetFocus(this.hwndParent);
        }
        OS.SetParent(this.handle, this.hwndParent);
        if (hwndFocus == this.handle) {
            OS.SetFocus(this.handle);
        }
        this.register();
        this.subclass();
        this.createItemToolTips();
    }

    void createWidget() {
        super.createWidget();
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
        this.itemCount = -1;
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    void deregister() {
        super.deregister();
        if (this.hwndParent != 0) {
            this.display.removeControl(this.hwndParent);
        }
        if (this.hwndHeader != 0) {
            this.display.removeControl(this.hwndHeader);
        }
    }

    void deselect(int hItem, TVITEM tvItem, int hIgnoreItem) {
        while (hItem != 0) {
            if (hItem != hIgnoreItem) {
                tvItem.hItem = hItem;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            }
            int hFirstItem = OS.SendMessage(this.handle, 4362, 4, hItem);
            this.deselect(hFirstItem, tvItem, hIgnoreItem);
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 2;
        if ((this.style & 4) != 0) {
            int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
            if (hItem != 0) {
                tvItem.hItem = hItem;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            }
        } else {
            int oldProc = OS.GetWindowLong(this.handle, -4);
            OS.SetWindowLong(this.handle, -4, TreeProc);
            if ((this.style & 0x10000000) != 0) {
                int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
                this.deselect(hItem, tvItem, 0);
            } else {
                int i = 0;
                while (i < this.items.length) {
                    TreeItem item = this.items[i];
                    if (item != null) {
                        tvItem.hItem = item.handle;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                    ++i;
                }
            }
            OS.SetWindowLong(this.handle, -4, oldProc);
        }
    }

    void destroyItem(TreeColumn column) {
        if (this.hwndHeader == 0) {
            this.error(15);
        }
        int columnCount = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        int index = 0;
        while (index < columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        int[] oldOrder = new int[columnCount];
        OS.SendMessage(this.hwndHeader, 4625, columnCount, oldOrder);
        int orderIndex = 0;
        while (orderIndex < columnCount) {
            if (oldOrder[orderIndex] == index) break;
            ++orderIndex;
        }
        RECT headerRect = new RECT();
        OS.SendMessage(this.hwndHeader, 4615, index, headerRect);
        if (OS.SendMessage(this.hwndHeader, 4610, index, 0) == 0) {
            this.error(15);
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --columnCount - index);
        this.columns[columnCount] = null;
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                if (columnCount == 0) {
                    item.strings = null;
                    item.images = null;
                    item.cellBackground = null;
                    item.cellForeground = null;
                    item.cellFont = null;
                } else {
                    Object[] temp;
                    if (item.strings != null) {
                        String[] strings = item.strings;
                        if (index == 0) {
                            item.text = strings[1] != null ? strings[1] : "";
                        }
                        temp = new String[columnCount];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index + 1, temp, index, columnCount - index);
                        item.strings = temp;
                    } else if (index == 0) {
                        item.text = "";
                    }
                    if (item.images != null) {
                        Image[] images = item.images;
                        if (index == 0) {
                            item.image = images[1];
                        }
                        temp = new Image[columnCount];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index + 1, temp, index, columnCount - index);
                        item.images = temp;
                    } else if (index == 0) {
                        item.image = null;
                    }
                    if (item.cellBackground != null) {
                        int[] cellBackground = item.cellBackground;
                        temp = new int[columnCount];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index + 1, temp, index, columnCount - index);
                        item.cellBackground = (int[])temp;
                    }
                    if (item.cellForeground != null) {
                        int[] cellForeground = item.cellForeground;
                        temp = new int[columnCount];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index + 1, temp, index, columnCount - index);
                        item.cellForeground = (int[])temp;
                    }
                    if (item.cellFont != null) {
                        int[] cellFont = item.cellFont;
                        temp = new int[columnCount];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index + 1, temp, index, columnCount - index);
                        item.cellFont = (int[])temp;
                    }
                }
            }
            ++i;
        }
        if (columnCount == 0) {
            this.scrollWidth = 0;
            if (!(this.hooks(41) || this.hooks(40) || this.hooks(42))) {
                int bits = OS.GetWindowLong(this.handle, -16);
                OS.SetWindowLong(this.handle, -16, bits &= 0xFFFF7FFF);
                OS.InvalidateRect(this.handle, null, true);
            }
        } else {
            if (index == 0) {
                this.columns[0].style &= 0xFEFDBFFF;
                this.columns[0].style |= 0x4000;
                HDITEM hdItem = new HDITEM();
                hdItem.mask = 36;
                OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, index, hdItem);
                hdItem.fmt &= 0xFFFFFFFC;
                hdItem.fmt |= 0;
                OS.SendMessage(this.hwndHeader, OS.HDM_SETITEM, index, hdItem);
            }
            RECT rect = new RECT();
            OS.GetClientRect(this.handle, rect);
            rect.left = headerRect.left;
            OS.InvalidateRect(this.handle, rect, true);
        }
        this.setScrollWidth();
        this.updateImageList();
        if (columnCount != 0) {
            int[] newOrder = new int[columnCount];
            OS.SendMessage(this.hwndHeader, 4625, columnCount, newOrder);
            TreeColumn[] newColumns = new TreeColumn[columnCount - orderIndex];
            int i2 = orderIndex;
            while (i2 < newOrder.length) {
                newColumns[i2 - orderIndex] = this.columns[newOrder[i2]];
                newColumns[i2 - orderIndex].updateToolTip(newOrder[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < newColumns.length) {
                if (!newColumns[i2].isDisposed()) {
                    newColumns[i2].sendEvent(10);
                }
                ++i2;
            }
        }
        if (this.headerToolTipHandle != 0) {
            TOOLINFO lpti = new TOOLINFO();
            lpti.cbSize = TOOLINFO.sizeof;
            lpti.uId = column.id;
            lpti.hwnd = this.hwndHeader;
            OS.SendMessage(this.headerToolTipHandle, OS.TTM_DELTOOL, 0, lpti);
        }
    }

    void destroyItem(TreeItem item, int hItem) {
        int count;
        RECT rect;
        this.hLastIndexOf = 0;
        this.hFirstIndexOf = 0;
        this.itemCount = -1;
        int hParent = 0;
        boolean fixRedraw = false;
        if ((this.style & 0x20000000) == 0 && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
            rect = new RECT();
            rect.left = hItem;
            boolean bl = fixRedraw = OS.SendMessage(this.handle, 4356, 0, rect) == 0;
        }
        if (fixRedraw) {
            hParent = OS.SendMessage(this.handle, 4362, 3, hItem);
            OS.UpdateWindow(this.handle);
            OS.DefWindowProc(this.handle, 11, 0, 0);
        }
        if ((this.style & 2) != 0) {
            this.lockSelection = true;
            this.ignoreSelect = true;
            this.ignoreDeselect = true;
        }
        this.ignoreShrink = true;
        this.shrink = true;
        OS.SendMessage(this.handle, 4353, 0, hItem);
        this.ignoreShrink = false;
        if ((this.style & 2) != 0) {
            this.lockSelection = false;
            this.ignoreSelect = false;
            this.ignoreDeselect = false;
        }
        if (fixRedraw) {
            OS.DefWindowProc(this.handle, 11, 1, 0);
            OS.ValidateRect(this.handle, null);
            if (OS.SendMessage(this.handle, 4362, 4, hParent) == 0) {
                rect = new RECT();
                rect.left = hParent;
                if (OS.SendMessage(this.handle, 4356, 0, rect) != 0) {
                    OS.InvalidateRect(this.handle, rect, true);
                }
            }
        }
        if ((count = OS.SendMessage(this.handle, 4357, 0, 0)) == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 4361, 0, 0);
                this.display.releaseImageList(this.imageList);
            }
            this.imageList = null;
            if (!(this.hwndParent != 0 || this.linesVisible || this.hooks(41) || this.hooks(40) || this.hooks(42))) {
                this.customDraw = false;
            }
            this.items = new TreeItem[4];
            this.scrollWidth = 0;
        }
        this.updateScrollBar();
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage == null) {
            this._setBackgroundPixel(enabled ? control.getBackgroundPixel() : -1);
        }
        if (this.hwndParent != 0) {
            OS.EnableWindow(this.hwndParent, enabled);
        }
        this.updateFullSelection();
    }

    int findIndex(int hFirstItem, int hItem) {
        if (hFirstItem == 0) {
            return -1;
        }
        if (hFirstItem == this.hFirstIndexOf) {
            if (this.hFirstIndexOf == hItem) {
                this.hLastIndexOf = this.hFirstIndexOf;
                this.lastIndexOf = 0;
                return 0;
            }
            if (this.hLastIndexOf == hItem) {
                return this.lastIndexOf;
            }
            int hPrevItem = OS.SendMessage(this.handle, 4362, 2, this.hLastIndexOf);
            if (hPrevItem == hItem) {
                this.hLastIndexOf = hPrevItem;
                return --this.lastIndexOf;
            }
            int hNextItem = OS.SendMessage(this.handle, 4362, 1, this.hLastIndexOf);
            if (hNextItem == hItem) {
                this.hLastIndexOf = hNextItem;
                return ++this.lastIndexOf;
            }
            int previousIndex = this.lastIndexOf - 1;
            while (hPrevItem != 0 && hPrevItem != hItem) {
                hPrevItem = OS.SendMessage(this.handle, 4362, 2, hPrevItem);
                --previousIndex;
            }
            if (hPrevItem == hItem) {
                this.hLastIndexOf = hPrevItem;
                this.lastIndexOf = previousIndex;
                return this.lastIndexOf;
            }
            int nextIndex = this.lastIndexOf + 1;
            while (hNextItem != 0 && hNextItem != hItem) {
                hNextItem = OS.SendMessage(this.handle, 4362, 1, hNextItem);
                ++nextIndex;
            }
            if (hNextItem == hItem) {
                this.hLastIndexOf = hNextItem;
                this.lastIndexOf = nextIndex;
                return this.lastIndexOf;
            }
            return -1;
        }
        int index = 0;
        int hNextItem = hFirstItem;
        while (hNextItem != 0 && hNextItem != hItem) {
            hNextItem = OS.SendMessage(this.handle, 4362, 1, hNextItem);
            ++index;
        }
        if (hNextItem == hItem) {
            this.itemCount = -1;
            this.hFirstIndexOf = hFirstItem;
            this.hLastIndexOf = hNextItem;
            this.lastIndexOf = index;
            return this.lastIndexOf;
        }
        return -1;
    }

    Widget findItem(int hItem) {
        return this._getItem(hItem);
    }

    int findItem(int hFirstItem, int index) {
        if (hFirstItem == 0) {
            return 0;
        }
        if (hFirstItem == this.hFirstIndexOf) {
            if (index == 0) {
                this.lastIndexOf = 0;
                this.hLastIndexOf = this.hFirstIndexOf;
                return this.hLastIndexOf;
            }
            if (this.lastIndexOf == index) {
                return this.hLastIndexOf;
            }
            if (this.lastIndexOf - 1 == index) {
                --this.lastIndexOf;
                this.hLastIndexOf = OS.SendMessage(this.handle, 4362, 2, this.hLastIndexOf);
                return this.hLastIndexOf;
            }
            if (this.lastIndexOf + 1 == index) {
                ++this.lastIndexOf;
                this.hLastIndexOf = OS.SendMessage(this.handle, 4362, 1, this.hLastIndexOf);
                return this.hLastIndexOf;
            }
            if (index < this.lastIndexOf) {
                int previousIndex = this.lastIndexOf - 1;
                int hPrevItem = OS.SendMessage(this.handle, 4362, 2, this.hLastIndexOf);
                while (hPrevItem != 0 && index < previousIndex) {
                    hPrevItem = OS.SendMessage(this.handle, 4362, 2, hPrevItem);
                    --previousIndex;
                }
                if (index == previousIndex) {
                    this.lastIndexOf = previousIndex;
                    this.hLastIndexOf = hPrevItem;
                    return this.hLastIndexOf;
                }
            } else {
                int nextIndex = this.lastIndexOf + 1;
                int hNextItem = OS.SendMessage(this.handle, 4362, 1, this.hLastIndexOf);
                while (hNextItem != 0 && nextIndex < index) {
                    hNextItem = OS.SendMessage(this.handle, 4362, 1, hNextItem);
                    ++nextIndex;
                }
                if (index == nextIndex) {
                    this.lastIndexOf = nextIndex;
                    this.hLastIndexOf = hNextItem;
                    return this.hLastIndexOf;
                }
            }
            return 0;
        }
        int nextIndex = 0;
        int hNextItem = hFirstItem;
        while (hNextItem != 0 && nextIndex < index) {
            hNextItem = OS.SendMessage(this.handle, 4362, 1, hNextItem);
            ++nextIndex;
        }
        if (index == nextIndex) {
            this.itemCount = -1;
            this.lastIndexOf = nextIndex;
            this.hFirstIndexOf = hFirstItem;
            this.hLastIndexOf = hNextItem;
            return this.hLastIndexOf;
        }
        return 0;
    }

    TreeItem getFocusItem() {
        int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
        return hItem != 0 ? this._getItem(hItem) : null;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (this.hwndHeader == 0) {
            return 0;
        }
        RECT rect = new RECT();
        OS.GetWindowRect(this.hwndHeader, rect);
        return rect.bottom - rect.top;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        if (this.hwndHeader == 0) {
            return false;
        }
        int bits = OS.GetWindowLong(this.hwndHeader, -16);
        return (bits & 0x10000000) != 0;
    }

    Point getImageSize() {
        if (this.imageList != null) {
            return this.imageList.getImageSize();
        }
        return new Point(0, this.getItemHeight());
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (this.hwndHeader == 0) {
            this.error(6);
        }
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        if (this.hwndHeader == 0) {
            return 0;
        }
        return OS.SendMessage(this.hwndHeader, 4608, 0, 0);
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.hwndHeader == 0) {
            return new int[0];
        }
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        int[] order = new int[count];
        OS.SendMessage(this.hwndHeader, 4625, count, order);
        return order;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        if (this.hwndHeader == 0) {
            return new TreeColumn[0];
        }
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        TreeColumn[] result = new TreeColumn[count];
        System.arraycopy(this.columns, 0, result, 0, count);
        return result;
    }

    public TreeItem getItem(int index) {
        int hItem;
        int hFirstItem;
        this.checkWidget();
        if (index < 0) {
            this.error(6);
        }
        if ((hFirstItem = OS.SendMessage(this.handle, 4362, 0, 0)) == 0) {
            this.error(6);
        }
        if ((hItem = this.findItem(hFirstItem, index)) == 0) {
            this.error(6);
        }
        return this._getItem(hItem);
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = point.x;
        lpht.y = point.y;
        OS.SendMessage(this.handle, 4369, 0, lpht);
        if (lpht.hItem != 0 && ((this.style & 0x10000) != 0 || (lpht.flags & 0x46) != 0)) {
            return this._getItem(lpht.hItem);
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
        if (hItem == 0) {
            return 0;
        }
        return this.getItemCount(hItem);
    }

    int getItemCount(int hItem) {
        int count = 0;
        int hFirstItem = hItem;
        if (hItem == this.hFirstIndexOf) {
            if (this.itemCount != -1) {
                return this.itemCount;
            }
            hFirstItem = this.hLastIndexOf;
            count = this.lastIndexOf;
        }
        while (hFirstItem != 0) {
            hFirstItem = OS.SendMessage(this.handle, 4362, 1, hFirstItem);
            ++count;
        }
        if (hItem == this.hFirstIndexOf) {
            this.itemCount = count;
        }
        return count;
    }

    public int getItemHeight() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4380, 0, 0);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
        if (hItem == 0) {
            return new TreeItem[0];
        }
        return this.getItems(hItem);
    }

    TreeItem[] getItems(int hTreeItem) {
        int count = 0;
        int hItem = hTreeItem;
        while (hItem != 0) {
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
            ++count;
        }
        int index = 0;
        TreeItem[] result = new TreeItem[count];
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        tvItem.hItem = hTreeItem;
        while (tvItem.hItem != 0) {
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            TreeItem item = this._getItem(tvItem.hItem, tvItem.lParam);
            if (item != null) {
                result[index++] = item;
            }
            tvItem.hItem = OS.SendMessage(this.handle, 4362, 1, tvItem.hItem);
        }
        if (index != count) {
            TreeItem[] newResult = new TreeItem[index];
            System.arraycopy(result, 0, newResult, 0, index);
            result = newResult;
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    int getNextSelection(int hItem) {
        while (hItem != 0) {
            int state = OS.SendMessage(this.handle, 4391, hItem, 2);
            if ((state & 2) != 0) {
                return hItem;
            }
            int hFirstItem = OS.SendMessage(this.handle, 4362, 4, hItem);
            int hSelected = this.getNextSelection(hFirstItem);
            if (hSelected != 0) {
                return hSelected;
            }
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
        }
        return 0;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    int getSelection(int hItem, TVITEM tvItem, TreeItem[] selection, int count) {
        while (hItem != 0) {
            if (tvItem != null && selection != null && count < selection.length) {
                tvItem.hItem = hItem;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                if ((tvItem.state & 2) != 0) {
                    selection[count++] = this._getItem(hItem, tvItem.lParam);
                }
            } else {
                int state = OS.SendMessage(this.handle, 4391, hItem, 2);
                if ((state & 2) != 0) {
                    ++count;
                }
            }
            int hFirstItem = OS.SendMessage(this.handle, 4362, 4, hItem);
            count = this.getSelection(hFirstItem, tvItem, selection, count);
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
        }
        return count;
    }

    public TreeItem[] getSelection() {
        int hItem;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int hItem2 = OS.SendMessage(this.handle, 4362, 9, 0);
            if (hItem2 == 0) {
                return new TreeItem[0];
            }
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 28;
            tvItem.hItem = hItem2;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if ((tvItem.state & 2) == 0) {
                return new TreeItem[0];
            }
            return new TreeItem[]{this._getItem(tvItem.hItem, tvItem.lParam)};
        }
        int count = 0;
        TreeItem[] guess = new TreeItem[8];
        int oldProc = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        if ((this.style & 0x10000000) != 0) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 28;
            int hItem3 = OS.SendMessage(this.handle, 4362, 0, 0);
            count = this.getSelection(hItem3, tvItem, guess, 0);
        } else {
            int i = 0;
            while (i < this.items.length) {
                int state;
                TreeItem item = this.items[i];
                if (item != null && ((state = OS.SendMessage(this.handle, 4391, hItem = item.handle, 2)) & 2) != 0) {
                    if (count < guess.length) {
                        guess[count] = item;
                    }
                    ++count;
                }
                ++i;
            }
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
        if (count == 0) {
            return new TreeItem[0];
        }
        if (count == guess.length) {
            return guess;
        }
        TreeItem[] result = new TreeItem[count];
        if (count < guess.length) {
            System.arraycopy(guess, 0, result, 0, count);
            return result;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 28;
        OS.SetWindowLong(this.handle, -4, TreeProc);
        if ((this.style & 0x10000000) != 0) {
            hItem = OS.SendMessage(this.handle, 4362, 0, 0);
            this.getSelection(hItem, tvItem, result, 0);
        } else {
            int index = 0;
            int i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    tvItem.hItem = item.handle;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    if ((tvItem.state & 2) != 0) {
                        result[index++] = item;
                    }
                }
                ++i;
            }
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
            if (hItem == 0) {
                return 0;
            }
            int state = OS.SendMessage(this.handle, 4391, hItem, 2);
            if ((state & 2) == 0) {
                return 0;
            }
            return 1;
        }
        int count = 0;
        int oldProc = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        if ((this.style & 0x10000000) != 0) {
            int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
            count = this.getSelection(hItem, null, null, 0);
        } else {
            int i = 0;
            while (i < this.items.length) {
                int hItem;
                int state;
                TreeItem item = this.items[i];
                if (item != null && ((state = OS.SendMessage(this.handle, 4391, hItem = item.handle, 2)) & 2) != 0) {
                    ++count;
                }
                ++i;
            }
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
        return count;
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    int getSortColumnPixel() {
        int pixel = OS.IsWindowEnabled(this.handle) ? this.getBackgroundPixel() : OS.GetSysColor(OS.COLOR_3DFACE);
        int red = pixel & 0xFF;
        int green = (pixel & 0xFF00) >> 8;
        int blue = (pixel & 0xFF0000) >> 16;
        if (red > 240 && green > 240 && blue > 240) {
            red -= 8;
            green -= 8;
            blue -= 8;
        } else {
            red = Math.min(255, red / 10 + red);
            green = Math.min(255, green / 10 + green);
            blue = Math.min(255, blue / 10 + blue);
        }
        return 0x2000000 | red & 0xFF | (green & 0xFF) << 8 | (blue & 0xFF) << 16;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        int hItem = OS.SendMessage(this.handle, 4362, 5, 0);
        return hItem != 0 ? this._getItem(hItem) : null;
    }

    int imageIndex(Image image, int index) {
        int imageIndex;
        if (image == null) {
            return -2;
        }
        if (this.imageList == null) {
            Rectangle bounds = image.getBounds();
            this.imageList = this.display.getImageList(this.style & 0x4000000, bounds.width, bounds.height);
        }
        if ((imageIndex = this.imageList.indexOf(image)) == -1) {
            imageIndex = this.imageList.add(image);
        }
        if (this.hwndHeader == 0 || OS.SendMessage(this.hwndHeader, 4623, 0, 0) == index) {
            int hImageList = this.imageList.getHandle();
            int hOldImageList = OS.SendMessage(this.handle, 4360, 0, 0);
            if (hOldImageList != hImageList) {
                OS.SendMessage(this.handle, 4361, 0, hImageList);
                this.updateScrollBar();
            }
        }
        return imageIndex;
    }

    int imageIndexHeader(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.headerImageList == null) {
            Rectangle bounds = image.getBounds();
            this.headerImageList = this.display.getImageList(this.style & 0x4000000, bounds.width, bounds.height);
            int index = this.headerImageList.indexOf(image);
            if (index == -1) {
                index = this.headerImageList.add(image);
            }
            int hImageList = this.headerImageList.getHandle();
            if (this.hwndHeader != 0) {
                OS.SendMessage(this.hwndHeader, 4616, 0, hImageList);
            }
            this.updateScrollBar();
            return index;
        }
        int index = this.headerImageList.indexOf(image);
        if (index != -1) {
            return index;
        }
        return this.headerImageList.add(image);
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (this.hwndHeader == 0) {
            return -1;
        }
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        int i = 0;
        while (i < count) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TreeItem item) {
        int hItem;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        return (hItem = OS.SendMessage(this.handle, 4362, 0, 0)) == 0 ? -1 : this.findIndex(hItem, item.handle);
    }

    void register() {
        super.register();
        if (this.hwndParent != 0) {
            this.display.addControl(this.hwndParent, this);
        }
        if (this.hwndHeader != 0) {
            this.display.addControl(this.hwndHeader, this);
        }
    }

    void releaseItem(int hItem, TVITEM tvItem, boolean release) {
        if (hItem == this.hAnchor) {
            this.hAnchor = 0;
        }
        if (hItem == this.hInsert) {
            this.hInsert = 0;
        }
        tvItem.hItem = hItem;
        if (OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem) != 0 && tvItem.lParam != -1) {
            TreeItem item;
            if (tvItem.lParam < this.lastID) {
                this.lastID = tvItem.lParam;
            }
            if (release && (item = this.items[tvItem.lParam]) != null) {
                item.release(false);
            }
            this.items[tvItem.lParam] = null;
        }
    }

    void releaseItems(int hItem, TVITEM tvItem) {
        hItem = OS.SendMessage(this.handle, 4362, 4, hItem);
        while (hItem != 0) {
            this.releaseItems(hItem, tvItem);
            this.releaseItem(hItem, tvItem, true);
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.hwndHeader = 0;
        this.hwndParent = 0;
    }

    void releaseChildren(boolean destroy) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columns.length) {
                TreeColumn column = this.columns[i];
                if (column != null && !column.isDisposed()) {
                    column.release(false);
                }
                ++i;
            }
            this.columns = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.customDraw = false;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4361, 0, 0);
            this.display.releaseImageList(this.imageList);
        }
        if (this.headerImageList != null) {
            if (this.hwndHeader != 0) {
                OS.SendMessage(this.hwndHeader, 4616, 0, 0);
            }
            this.display.releaseImageList(this.headerImageList);
        }
        this.headerImageList = null;
        this.imageList = null;
        int hStateList = OS.SendMessage(this.handle, 4360, 2, 0);
        OS.SendMessage(this.handle, 4361, 2, 0);
        if (hStateList != 0) {
            OS.ImageList_Destroy(hStateList);
        }
        if (this.itemToolTipHandle != 0) {
            OS.DestroyWindow(this.itemToolTipHandle);
        }
        if (this.headerToolTipHandle != 0) {
            OS.DestroyWindow(this.headerToolTipHandle);
        }
        this.headerToolTipHandle = 0;
        this.itemToolTipHandle = 0;
    }

    public void removeAll() {
        boolean redraw;
        this.checkWidget();
        this.hLastIndexOf = 0;
        this.hFirstIndexOf = 0;
        this.itemCount = -1;
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        this.ignoreSelect = true;
        this.ignoreDeselect = true;
        boolean bl = redraw = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
        if (redraw) {
            OS.DefWindowProc(this.handle, 11, 0, 0);
        }
        this.ignoreShrink = true;
        this.shrink = true;
        int result = OS.SendMessage(this.handle, 4353, 0, -65536);
        this.ignoreShrink = false;
        if (redraw) {
            OS.DefWindowProc(this.handle, 11, 1, 0);
            OS.InvalidateRect(this.handle, null, true);
        }
        this.ignoreSelect = false;
        this.ignoreDeselect = false;
        if (result == 0) {
            this.error(15);
        }
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4361, 0, 0);
            this.display.releaseImageList(this.imageList);
        }
        this.imageList = null;
        if (!(this.hwndParent != 0 || this.linesVisible || this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            this.customDraw = false;
        }
        this.hLastIndexOf = 0;
        this.hFirstIndexOf = 0;
        this.hInsert = 0;
        this.hAnchor = 0;
        this.itemCount = -1;
        this.items = new TreeItem[4];
        this.updateScrollBar();
        this.scrollWidth = 0;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        int hItem = 0;
        if (item != null) {
            if (item.isDisposed()) {
                this.error(5);
            }
            hItem = item.handle;
        }
        this.hInsert = hItem;
        this.insertAfter = !before;
        OS.SendMessage(this.handle, 4378, this.insertAfter ? 1 : 0, this.hInsert);
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
        this.setItemCount(count, 0, hItem);
    }

    void setItemCount(int count, int hParent, int hItem) {
        boolean redraw = false;
        if (OS.SendMessage(this.handle, 4357, 0, 0) == 0) {
            boolean bl = redraw = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
            if (redraw) {
                OS.SendMessage(this.handle, 11, 0, 0);
            }
        }
        int itemCount = 0;
        while (hItem != 0 && itemCount < count) {
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
            ++itemCount;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        while (hItem != 0) {
            TreeItem item;
            tvItem.hItem = hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
            TreeItem treeItem = item = tvItem.lParam != -1 ? this.items[tvItem.lParam] : null;
            if (item != null && !item.isDisposed()) {
                item.dispose();
                continue;
            }
            this.releaseItem(tvItem.hItem, tvItem, false);
            this.destroyItem(null, tvItem.hItem);
        }
        if ((this.style & 0x10000000) != 0) {
            int i = itemCount;
            while (i < count) {
                this.createItem(null, hParent, -65534, 0);
                ++i;
            }
        } else {
            this.shrink = true;
            int extra = Math.max(4, (count + 3) / 4 * 4);
            TreeItem[] newItems = new TreeItem[this.items.length + extra];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
            int i = itemCount;
            while (i < count) {
                new TreeItem(this, 0, hParent, -65534, 0);
                ++i;
            }
        }
        if (redraw) {
            OS.SendMessage(this.handle, 11, 1, 0);
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    void setItemHeight(int itemHeight) {
        this.checkWidget();
        if (itemHeight < -1) {
            this.error(5);
        }
        OS.SendMessage(this.handle, 4379, itemHeight, 0);
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        if (this.linesVisible == show) {
            return;
        }
        this.linesVisible = show;
        if (this.hwndParent == 0 && this.linesVisible) {
            this.customDraw = true;
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    int scrolledHandle() {
        if (this.hwndHeader == 0) {
            return this.handle;
        }
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        return count == 0 ? this.handle : this.hwndParent;
    }

    void select(int hItem, TVITEM tvItem) {
        while (hItem != 0) {
            tvItem.hItem = hItem;
            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            int hFirstItem = OS.SendMessage(this.handle, 4362, 4, hItem);
            this.select(hFirstItem, tvItem);
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.state = 2;
        tvItem.stateMask = 2;
        int oldProc = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        if ((this.style & 0x10000000) != 0) {
            int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
            this.select(hItem, tvItem);
        } else {
            int i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    tvItem.hItem = item.handle;
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                }
                ++i;
            }
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
    }

    void setBackgroundImage(int hBitmap) {
        super.setBackgroundImage(hBitmap);
        if (hBitmap != 0) {
            if (OS.COMCTL32_MAJOR < 6 && OS.SendMessage(this.handle, 4383, 0, 0) == -1) {
                OS.SendMessage(this.handle, 4381, 0, -1);
            }
            OS.SendMessage(this.handle, 4381, 0, -1);
        } else {
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            if (control.backgroundImage == null) {
                this.setBackgroundPixel(control.getBackgroundPixel());
            }
        }
        this.updateFullSelection();
    }

    void setBackgroundPixel(int pixel) {
        Control control = this.findImageControl();
        if (control != null) {
            this.setBackgroundImage(control.backgroundImage);
            return;
        }
        if (OS.IsWindowEnabled(this.handle)) {
            this._setBackgroundPixel(pixel);
        }
        this.updateFullSelection();
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        int hItem;
        boolean fixSelection = false;
        if ((flags & 1) == 0 && (width != 0 || height != 0) && OS.SendMessage(this.handle, 4368, 0, 0) == 0) {
            fixSelection = true;
        }
        super.setBounds(x, y, width, height, flags);
        if (fixSelection && (hItem = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
            this.showItem(hItem);
        }
    }

    void setCursor() {
        Cursor cursor = this.findCursor();
        int hCursor = cursor == null ? OS.LoadCursor(0, 32512) : cursor.handle;
        OS.SetCursor(hCursor);
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        int count = 0;
        if (this.hwndHeader != 0) {
            count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        }
        if (count == 0) {
            if (order.length != 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != count) {
            this.error(5);
        }
        int[] oldOrder = new int[count];
        OS.SendMessage(this.hwndHeader, 4625, count, oldOrder);
        boolean reorder = false;
        boolean[] seen = new boolean[count];
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= count) {
                this.error(6);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            if (index != oldOrder[i]) {
                reorder = true;
            }
            ++i;
        }
        if (reorder) {
            RECT[] oldRects = new RECT[count];
            int i2 = 0;
            while (i2 < count) {
                oldRects[i2] = new RECT();
                OS.SendMessage(this.hwndHeader, 4615, i2, oldRects[i2]);
                ++i2;
            }
            OS.SendMessage(this.hwndHeader, 4626, order.length, order);
            OS.InvalidateRect(this.handle, null, true);
            this.updateImageList();
            TreeColumn[] newColumns = new TreeColumn[count];
            System.arraycopy(this.columns, 0, newColumns, 0, count);
            RECT newRect = new RECT();
            int i3 = 0;
            while (i3 < count) {
                TreeColumn column = newColumns[i3];
                if (!column.isDisposed()) {
                    OS.SendMessage(this.hwndHeader, 4615, i3, newRect);
                    if (newRect.left != oldRects[i3].left) {
                        column.updateToolTip(i3);
                        column.sendEvent(10);
                    }
                }
                ++i3;
            }
        }
    }

    void setCheckboxImageList() {
        int height;
        if ((this.style & 0x20) == 0) {
            return;
        }
        int count = 5;
        int flags = 0;
        if (OS.IsWinCE) {
            flags |= 0;
        } else if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            flags |= 0x20;
        } else {
            int hDC = OS.GetDC(this.handle);
            int bits = OS.GetDeviceCaps(hDC, 12);
            int planes = OS.GetDeviceCaps(hDC, 14);
            OS.ReleaseDC(this.handle, hDC);
            int depth = bits * planes;
            switch (depth) {
                case 4: {
                    flags |= 4;
                    break;
                }
                case 8: {
                    flags |= 8;
                    break;
                }
                case 16: {
                    flags |= 0x10;
                    break;
                }
                case 24: {
                    flags |= 0x18;
                    break;
                }
                case 32: {
                    flags |= 0x20;
                    break;
                }
                default: {
                    flags |= 0;
                }
            }
            flags |= 1;
        }
        if ((this.style & 0x4000000) != 0) {
            flags |= 0x2000;
        }
        int width = height = OS.SendMessage(this.handle, 4380, 0, 0);
        int hStateList = OS.ImageList_Create(width, height, flags, count, count);
        int hDC = OS.GetDC(this.handle);
        int memDC = OS.CreateCompatibleDC(hDC);
        int hBitmap = OS.CreateCompatibleBitmap(hDC, width * count, height);
        int hOldBitmap = OS.SelectObject(memDC, hBitmap);
        RECT rect = new RECT();
        OS.SetRect(rect, 0, 0, width * count, height);
        int clrBackground = 0;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            clrBackground = control.getBackgroundPixel();
        } else {
            clrBackground = 0x20000FF;
            if ((clrBackground & 0xFFFFFF) == OS.GetSysColor(OS.COLOR_WINDOW)) {
                clrBackground = 0x200FF00;
            }
        }
        int hBrush = OS.CreateSolidBrush(clrBackground);
        OS.FillRect(memDC, rect, hBrush);
        OS.DeleteObject(hBrush);
        int oldFont = OS.SelectObject(hDC, this.defaultFont());
        TEXTMETRIC tm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(hDC, tm);
        OS.SelectObject(hDC, oldFont);
        int itemWidth = Math.min(tm.tmHeight, width);
        int itemHeight = Math.min(tm.tmHeight, height);
        int left = (width - itemWidth) / 2;
        int top = (height - itemHeight) / 2 + 1;
        OS.SetRect(rect, left + width, top, left + width + itemWidth, top + itemHeight);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int hTheme = OS.OpenThemeData(this.handle, BUTTON);
            OS.DrawThemeBackground(hTheme, memDC, 3, 1, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 5, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 1, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 9, rect, null);
            OS.CloseThemeData(hTheme);
        } else {
            OS.DrawFrameControl(memDC, rect, 4, 16384);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 17408);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 16640);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 17664);
        }
        OS.SelectObject(memDC, hOldBitmap);
        OS.DeleteDC(memDC);
        OS.ReleaseDC(this.handle, hDC);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            OS.ImageList_Add(hStateList, hBitmap, 0);
        } else {
            OS.ImageList_AddMasked(hStateList, hBitmap, clrBackground);
        }
        OS.DeleteObject(hBitmap);
        int hOldStateList = OS.SendMessage(this.handle, 4360, 2, 0);
        OS.SendMessage(this.handle, 4361, 2, hStateList);
        if (hOldStateList != 0) {
            OS.ImageList_Destroy(hOldStateList);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
    }

    void setForegroundPixel(int pixel) {
        OS.SendMessage(this.handle, 4382, 0, pixel);
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        if (this.hwndHeader == 0) {
            if (!show) {
                return;
            }
            this.createParent();
        }
        int bits = OS.GetWindowLong(this.hwndHeader, -16);
        if (show) {
            if ((bits & 8) == 0) {
                return;
            }
            OS.SetWindowLong(this.hwndHeader, -16, bits &= 0xFFFFFFF7);
            OS.ShowWindow(this.hwndHeader, 5);
        } else {
            if ((bits & 8) != 0) {
                return;
            }
            OS.SetWindowLong(this.hwndHeader, -16, bits |= 8);
            OS.ShowWindow(this.hwndHeader, 0);
        }
        this.setScrollWidth();
        this.updateHeaderToolTips();
        this.updateScrollBar();
    }

    public void setRedraw(boolean redraw) {
        int count;
        this.checkWidget();
        int hItem = 0;
        if (redraw && this.drawCount == 1 && (count = OS.SendMessage(this.handle, 4357, 0, 0)) == 0) {
            TVINSERTSTRUCT tvInsert = new TVINSERTSTRUCT();
            tvInsert.hInsertAfter = -65535;
            hItem = OS.SendMessage(this.handle, OS.TVM_INSERTITEM, 0, tvInsert);
        }
        super.setRedraw(redraw);
        if (hItem != 0) {
            this.ignoreShrink = true;
            OS.SendMessage(this.handle, 4353, 0, hItem);
            this.ignoreShrink = false;
        }
    }

    void setScrollWidth() {
        if (this.hwndHeader == 0 || this.hwndParent == 0) {
            return;
        }
        int width = 0;
        HDITEM hdItem = new HDITEM();
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        int i = 0;
        while (i < count) {
            hdItem.mask = 1;
            OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, i, hdItem);
            width += hdItem.cxy;
            ++i;
        }
        this.setScrollWidth(Math.max(this.scrollWidth, width));
    }

    void setScrollWidth(int width) {
        if (this.hwndHeader == 0 || this.hwndParent == 0) {
            return;
        }
        int left = 0;
        RECT rect = new RECT();
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        info.fMask = 3;
        if (width == 0) {
            OS.GetScrollInfo(this.hwndParent, 0, info);
            info.nPage = info.nMax + 1;
            OS.SetScrollInfo(this.hwndParent, 0, info, true);
            OS.GetScrollInfo(this.hwndParent, 1, info);
            info.nPage = info.nMax + 1;
            OS.SetScrollInfo(this.hwndParent, 1, info, true);
        } else {
            OS.GetClientRect(this.hwndParent, rect);
            OS.GetScrollInfo(this.hwndParent, 0, info);
            info.nMax = width;
            info.nPage = rect.right - rect.left + 1;
            OS.SetScrollInfo(this.hwndParent, 0, info, true);
            info.fMask = 4;
            OS.GetScrollInfo(this.hwndParent, 0, info);
            left = info.nPos;
        }
        if (this.horizontalBar != null) {
            this.horizontalBar.setIncrement(5);
            this.horizontalBar.setPageIncrement(info.nPage);
        }
        OS.GetClientRect(this.hwndParent, rect);
        int hHeap = OS.GetProcessHeap();
        HDLAYOUT playout = new HDLAYOUT();
        playout.prc = OS.HeapAlloc(hHeap, 8, 16);
        playout.pwpos = OS.HeapAlloc(hHeap, 8, 28);
        OS.MoveMemory(playout.prc, rect, 16);
        OS.SendMessage(this.hwndHeader, 4613, 0, playout);
        WINDOWPOS pos = new WINDOWPOS();
        OS.MoveMemory(pos, playout.pwpos, 28);
        if (playout.prc != 0) {
            OS.HeapFree(hHeap, 0, playout.prc);
        }
        if (playout.pwpos != 0) {
            OS.HeapFree(hHeap, 0, playout.pwpos);
        }
        this.SetWindowPos(this.hwndHeader, 0, pos.x - left, pos.y, pos.cx + left, pos.cy, 16);
        int w = pos.cx + (width == 0 ? 0 : OS.GetSystemMetrics(2));
        int h = rect.bottom - rect.top - pos.cy;
        boolean oldIgnore = this.ignoreResize;
        this.ignoreResize = true;
        this.SetWindowPos(this.handle, 0, pos.x - left, pos.y + pos.cy, w + left, h, 20);
        this.ignoreResize = oldIgnore;
    }

    void setSelection(int hItem, TVITEM tvItem, TreeItem[] selection) {
        while (hItem != 0) {
            int index = 0;
            while (index < selection.length) {
                TreeItem item = selection[index];
                if (item != null && item.handle == hItem) break;
                ++index;
            }
            tvItem.hItem = hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if ((tvItem.state & 2) != 0) {
                if (index == selection.length) {
                    tvItem.state = 0;
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                }
            } else if (index != selection.length) {
                tvItem.state = 2;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            }
            int hFirstItem = OS.SendMessage(this.handle, 4362, 4, hItem);
            this.setSelection(hFirstItem, tvItem, selection);
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
        }
    }

    public void setSelection(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{item});
    }

    public void setSelection(TreeItem[] items) {
        int length;
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if ((length = items.length) == 0 || (this.style & 4) != 0 && length > 1) {
            this.deselectAll();
            return;
        }
        TreeItem item = items[0];
        if (item != null) {
            if (item.isDisposed()) {
                this.error(5);
            }
            int hOldItem = OS.SendMessage(this.handle, 4362, 9, 0);
            this.hAnchor = item.handle;
            int hNewItem = this.hAnchor;
            boolean fixScroll = this.checkScroll(hNewItem);
            if (fixScroll) {
                OS.SendMessage(this.handle, 11, 1, 0);
                OS.DefWindowProc(this.handle, 11, 0, 0);
            }
            this.hSelect = hNewItem;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4363, 9, hNewItem);
            this.ignoreSelect = false;
            this.hSelect = 0;
            if (OS.SendMessage(this.handle, 4368, 0, 0) == 0) {
                OS.SendMessage(this.handle, 4363, 5, hNewItem);
            }
            if (fixScroll) {
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.SendMessage(this.handle, 11, 0, 0);
            }
            if (hOldItem == hNewItem) {
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 24;
                tvItem.state = 2;
                tvItem.stateMask = 2;
                tvItem.hItem = hNewItem;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                this.showItem(hNewItem);
            }
        }
        if ((this.style & 4) != 0) {
            return;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 2;
        int oldProc = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        if ((this.style & 0x10000000) != 0) {
            int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
            this.setSelection(hItem, tvItem, items);
        } else {
            int i = 0;
            while (i < this.items.length) {
                item = this.items[i];
                if (item != null) {
                    int index = 0;
                    while (index < length) {
                        if (items[index] == item) break;
                        ++index;
                    }
                    tvItem.hItem = item.handle;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    if ((tvItem.state & 2) != 0) {
                        if (index == length) {
                            tvItem.state = 0;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        }
                    } else if (index != length) {
                        tvItem.state = 2;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                }
                ++i;
            }
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
    }

    public void setSortColumn(TreeColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(0);
        }
        this.sortColumn = column;
        if (this.sortColumn != null && this.sortDirection != 0) {
            this.sortColumn.setSortDirection(this.sortDirection);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if ((direction & 0x480) == 0 && direction != 0) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(direction);
        }
    }

    public void setTopItem(TreeItem item) {
        int hItem;
        boolean fixScroll;
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        if (fixScroll = this.checkScroll(hItem = item.handle)) {
            OS.SendMessage(this.handle, 11, 1, 0);
            OS.DefWindowProc(this.handle, 11, 0, 0);
        }
        OS.SendMessage(this.handle, 4363, 5, hItem);
        if (fixScroll) {
            OS.DefWindowProc(this.handle, 11, 1, 0);
            OS.SendMessage(this.handle, 11, 0, 0);
        }
        this.updateScrollBar();
    }

    void showItem(int hItem) {
        if (OS.SendMessage(this.handle, 4368, 0, 0) == 0) {
            boolean fixScroll = this.checkScroll(hItem);
            if (fixScroll) {
                OS.SendMessage(this.handle, 11, 1, 0);
                OS.DefWindowProc(this.handle, 11, 0, 0);
            }
            OS.SendMessage(this.handle, 4363, 5, hItem);
            OS.SendMessage(this.handle, 276, 6, 0);
            if (fixScroll) {
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.SendMessage(this.handle, 11, 0, 0);
            }
        } else {
            boolean scroll = true;
            RECT itemRect = new RECT();
            itemRect.left = hItem;
            if (OS.SendMessage(this.handle, 4356, 1, itemRect) != 0) {
                this.forceResize();
                RECT rect = new RECT();
                OS.GetClientRect(this.handle, rect);
                POINT pt = new POINT();
                pt.x = itemRect.left;
                pt.y = itemRect.top;
                if (OS.PtInRect(rect, pt)) {
                    pt.y = itemRect.bottom;
                    if (OS.PtInRect(rect, pt)) {
                        scroll = false;
                    }
                }
            }
            if (scroll) {
                boolean fixScroll = this.checkScroll(hItem);
                if (fixScroll) {
                    OS.SendMessage(this.handle, 11, 1, 0);
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                }
                OS.SendMessage(this.handle, 4372, 0, hItem);
                if (fixScroll) {
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    OS.SendMessage(this.handle, 11, 0, 0);
                }
            }
        }
        if (this.hwndParent != 0) {
            RECT itemRect = new RECT();
            itemRect.left = hItem;
            if (OS.SendMessage(this.handle, 4356, 1, itemRect) != 0) {
                this.forceResize();
                RECT rect = new RECT();
                OS.GetClientRect(this.hwndParent, rect);
                OS.MapWindowPoints(this.hwndParent, this.handle, rect, 2);
                POINT pt = new POINT();
                pt.x = itemRect.left;
                pt.y = itemRect.top;
                if (!OS.PtInRect(rect, pt)) {
                    pt.y = itemRect.bottom;
                    if (!OS.PtInRect(rect, pt)) {
                        SCROLLINFO info = new SCROLLINFO();
                        info.cbSize = 28;
                        info.fMask = 4;
                        info.nPos = Math.max(0, pt.x - 1);
                        OS.SetScrollInfo(this.hwndParent, 0, info, true);
                        this.setScrollWidth();
                    }
                }
            }
        }
        this.updateScrollBar();
    }

    public void showColumn(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int index = this.indexOf(column);
        if (index == -1) {
            return;
        }
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        if (index >= 0 && index < count && this.hwndParent != 0) {
            boolean scroll;
            this.forceResize();
            RECT rect = new RECT();
            OS.GetClientRect(this.hwndParent, rect);
            OS.MapWindowPoints(this.hwndParent, this.handle, rect, 2);
            RECT headerRect = new RECT();
            OS.SendMessage(this.hwndHeader, 4615, index, headerRect);
            boolean bl = scroll = headerRect.left < rect.left;
            if (!scroll) {
                int width = Math.min(rect.right - rect.left, headerRect.right - headerRect.left);
                boolean bl2 = scroll = headerRect.left + width > rect.right;
            }
            if (scroll) {
                SCROLLINFO info = new SCROLLINFO();
                info.cbSize = 28;
                info.fMask = 4;
                info.nPos = Math.max(0, headerRect.left - 1);
                OS.SetScrollInfo(this.hwndParent, 0, info, true);
                this.setScrollWidth();
            }
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.showItem(item.handle);
    }

    public void showSelection() {
        this.checkWidget();
        int hItem = 0;
        if ((this.style & 4) != 0) {
            hItem = OS.SendMessage(this.handle, 4362, 9, 0);
            if (hItem == 0) {
                return;
            }
            int state = OS.SendMessage(this.handle, 4391, hItem, 2);
            if ((state & 2) == 0) {
                return;
            }
        } else {
            int oldProc = OS.GetWindowLong(this.handle, -4);
            OS.SetWindowLong(this.handle, -4, TreeProc);
            if ((this.style & 0x10000000) != 0) {
                int hRoot = OS.SendMessage(this.handle, 4362, 0, 0);
                hItem = this.getNextSelection(hRoot);
            } else {
                int index = 0;
                while (index < this.items.length) {
                    int state;
                    TreeItem item = this.items[index];
                    if (item != null && ((state = OS.SendMessage(this.handle, 4391, item.handle, 2)) & 2) != 0) {
                        hItem = item.handle;
                        break;
                    }
                    ++index;
                }
            }
            OS.SetWindowLong(this.handle, -4, oldProc);
        }
        if (hItem != 0) {
            this.showItem(hItem);
        }
    }

    void showWidget(boolean visible) {
        super.showWidget(visible);
        if (this.hwndParent != 0) {
            OS.ShowWindow(this.hwndParent, visible ? 5 : 0);
        }
    }

    void subclass() {
        super.subclass();
        if (this.hwndHeader != 0) {
            OS.SetWindowLong(this.hwndHeader, -4, this.display.windowProc);
        }
    }

    String toolTipText(NMTTDISPINFO hdr) {
        int hwndToolTip = OS.SendMessage(this.handle, 4377, 0, 0);
        if (hwndToolTip == hdr.hwndFrom && this.toolTipText != null) {
            return "";
        }
        if (this.headerToolTipHandle == hdr.hwndFrom) {
            int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
            int i = 0;
            while (i < count) {
                TreeColumn column = this.columns[i];
                if (column.id == hdr.idFrom) {
                    return column.toolTipText;
                }
                ++i;
            }
            return super.toolTipText(hdr);
        }
        if (this.itemToolTipHandle == hdr.hwndFrom && this.hwndHeader != 0) {
            if (this.toolTipText != null) {
                return "";
            }
            if (!this.hooks(40) && !this.hooks(42)) {
                int pos = OS.GetMessagePos();
                POINT pt = new POINT();
                pt.x = (short)(pos & 0xFFFF);
                pt.y = (short)(pos >> 16);
                OS.ScreenToClient(this.handle, pt);
                TVHITTESTINFO lpht = new TVHITTESTINFO();
                lpht.x = pt.x;
                lpht.y = pt.y;
                OS.SendMessage(this.handle, 4369, 0, lpht);
                if (lpht.hItem != 0) {
                    int hDC = OS.GetDC(this.handle);
                    int oldFont = 0;
                    int newFont = OS.SendMessage(this.handle, 49, 0, 0);
                    if (newFont != 0) {
                        oldFont = OS.SelectObject(hDC, newFont);
                    }
                    RECT rect = new RECT();
                    OS.GetClientRect(this.hwndParent, rect);
                    OS.MapWindowPoints(this.hwndParent, this.handle, rect, 2);
                    TreeItem item = this._getItem(lpht.hItem);
                    String text = null;
                    int index = 0;
                    int count = Math.max(1, OS.SendMessage(this.hwndHeader, 4608, 0, 0));
                    int[] order = new int[count];
                    OS.SendMessage(this.hwndHeader, 4625, count, order);
                    while (index < count) {
                        int hFont;
                        int n = hFont = item.cellFont != null ? item.cellFont[order[index]] : -1;
                        if (hFont == -1) {
                            hFont = item.font;
                        }
                        if (hFont != -1) {
                            hFont = OS.SelectObject(hDC, hFont);
                        }
                        RECT cellRect = item.getBounds(order[index], true, false, true, false, true, hDC);
                        if (hFont != -1) {
                            OS.SelectObject(hDC, hFont);
                        }
                        if (cellRect.left > rect.right) break;
                        cellRect.right = Math.min(cellRect.right, rect.right);
                        if (OS.PtInRect(cellRect, pt)) {
                            RECT textRect = item.getBounds(order[index], true, false, false, false, false, hDC);
                            if (textRect.right <= cellRect.right) break;
                            if (order[index] == 0) {
                                text = item.text;
                                break;
                            }
                            String[] strings = item.strings;
                            if (strings == null) break;
                            text = strings[order[index]];
                            break;
                        }
                        ++index;
                    }
                    if (newFont != 0) {
                        OS.SelectObject(hDC, oldFont);
                    }
                    OS.ReleaseDC(this.handle, hDC);
                    if (text != null) {
                        return text;
                    }
                }
            }
        }
        return super.toolTipText(hdr);
    }

    int topHandle() {
        return this.hwndParent != 0 ? this.hwndParent : this.handle;
    }

    void updateFullSelection() {
        if ((this.style & 0x10000) != 0) {
            int oldBits = OS.GetWindowLong(this.handle, -16);
            int newBits = oldBits;
            if ((newBits & 0x1000) != 0) {
                if (!OS.IsWindowEnabled(this.handle) || this.findImageControl() != null) {
                    newBits &= 0xFFFFEFFF;
                }
            } else if (OS.IsWindowEnabled(this.handle) && this.findImageControl() == null && !this.hooks(40) && !this.hooks(42)) {
                newBits |= 0x1000;
            }
            if (newBits != oldBits) {
                OS.SetWindowLong(this.handle, -16, newBits);
                OS.InvalidateRect(this.handle, null, true);
            }
        }
    }

    void updateHeaderToolTips() {
        if (this.headerToolTipHandle == 0) {
            return;
        }
        RECT rect = new RECT();
        TOOLINFO lpti = new TOOLINFO();
        lpti.cbSize = TOOLINFO.sizeof;
        lpti.uFlags = 16;
        lpti.hwnd = this.hwndHeader;
        lpti.lpszText = -1;
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        int i = 0;
        while (i < count) {
            TreeColumn column = this.columns[i];
            if (OS.SendMessage(this.hwndHeader, 4615, i, rect) != 0) {
                ++this.display.nextToolTipId;
                lpti.uId = column.id = column.id;
                lpti.left = rect.left;
                lpti.top = rect.top;
                lpti.right = rect.right;
                lpti.bottom = rect.bottom;
                OS.SendMessage(this.headerToolTipHandle, OS.TTM_ADDTOOL, 0, lpti);
            }
            ++i;
        }
    }

    void updateImageList() {
        if (this.imageList == null) {
            return;
        }
        if (this.hwndHeader == 0) {
            return;
        }
        int i = 0;
        int index = OS.SendMessage(this.hwndHeader, 4623, 0, 0);
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                Image image = null;
                if (index == 0) {
                    image = item.image;
                } else {
                    Image[] images = item.images;
                    if (images != null) {
                        image = images[index];
                    }
                }
                if (image != null) break;
            }
            ++i;
        }
        int hImageList = i == this.items.length ? 0 : this.imageList.getHandle();
        int hOldImageList = OS.SendMessage(this.handle, 4360, 0, 0);
        if (hImageList != hOldImageList) {
            OS.SendMessage(this.handle, 4361, 0, hImageList);
        }
    }

    void updateImages() {
        if (this.sortColumn != null && !this.sortColumn.isDisposed() && OS.COMCTL32_MAJOR < 6) {
            switch (this.sortDirection) {
                case 128: 
                case 1024: {
                    this.sortColumn.setImage(this.display.getSortImage(this.sortDirection), true, true);
                }
            }
        }
    }

    void updateScrollBar() {
        int columnCount;
        if (this.hwndParent != 0 && ((columnCount = OS.SendMessage(this.hwndHeader, 4608, 0, 0)) != 0 || this.scrollWidth != 0)) {
            SCROLLINFO info = new SCROLLINFO();
            info.cbSize = 28;
            info.fMask = 23;
            int itemCount = OS.SendMessage(this.handle, 4357, 0, 0);
            if (itemCount == 0) {
                OS.GetScrollInfo(this.hwndParent, 1, info);
                info.nPage = info.nMax + 1;
                OS.SetScrollInfo(this.hwndParent, 1, info, true);
            } else {
                OS.GetScrollInfo(this.handle, 1, info);
                if (info.nPage == 0) {
                    info.nPage = info.nMax + 1;
                }
                OS.SetScrollInfo(this.hwndParent, 1, info, true);
            }
        }
    }

    void unsubclass() {
        super.unsubclass();
        if (this.hwndHeader != 0) {
            OS.SetWindowLong(this.hwndHeader, -4, HeaderProc);
        }
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x20 | 4 | 1 | 0x4000;
        bits = (this.style & 0x10000) != 0 ? (bits |= 0x1000) : (bits |= 2);
        return bits | 0x10;
    }

    TCHAR windowClass() {
        return TreeClass;
    }

    int windowProc() {
        return TreeProc;
    }

    int windowProc(int hwnd, int msg, int wParam, int lParam) {
        if (this.hwndHeader != 0 && hwnd == this.hwndHeader) {
            switch (msg) {
                case 533: {
                    if (OS.COMCTL32_MAJOR >= 6 || lParam == 0 || lParam == this.hwndHeader) break;
                    OS.InvalidateRect(this.hwndHeader, null, true);
                    break;
                }
                case 78: {
                    NMHDR hdr = new NMHDR();
                    OS.MoveMemory(hdr, lParam, 12);
                    switch (hdr.code) {
                        case -530: 
                        case -522: 
                        case -521: 
                        case -520: {
                            return OS.SendMessage(this.handle, msg, wParam, lParam);
                        }
                    }
                }
            }
            return this.callWindowProc(hwnd, msg, wParam, lParam);
        }
        if (this.hwndParent != 0 && hwnd == this.hwndParent) {
            switch (msg) {
                case 3: {
                    this.sendEvent(10);
                    return 0;
                }
                case 5: {
                    this.setScrollWidth();
                    if (this.ignoreResize) {
                        return 0;
                    }
                    this.setResizeChildren(false);
                    int code = this.callWindowProc(hwnd, 5, wParam, lParam);
                    this.sendEvent(11);
                    if (this.isDisposed()) {
                        return 0;
                    }
                    if (this.layout != null) {
                        this.markLayout(false, false);
                        this.updateLayout(false, false);
                    }
                    this.setResizeChildren(true);
                    return code;
                }
                case 133: {
                    LRESULT result = this.wmNCPaint(hwnd, wParam, lParam);
                    if (result == null) break;
                    return result.value;
                }
                case 791: {
                    LRESULT result = this.wmPrint(hwnd, wParam, lParam);
                    if (result == null) break;
                    return result.value;
                }
                case 21: 
                case 78: 
                case 273: {
                    return OS.SendMessage(this.handle, msg, wParam, lParam);
                }
                case 276: {
                    if (this.horizontalBar != null && (lParam == 0 || lParam == this.hwndParent)) {
                        this.wmScroll(this.horizontalBar, true, this.hwndParent, 276, wParam, lParam);
                    }
                    this.setScrollWidth();
                    break;
                }
                case 277: {
                    SCROLLINFO info = new SCROLLINFO();
                    info.cbSize = 28;
                    info.fMask = 23;
                    OS.GetScrollInfo(this.hwndParent, 1, info);
                    if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && (wParam & 0xFFFF) == 5) {
                        info.nPos = info.nTrackPos;
                    }
                    OS.SetScrollInfo(this.handle, 1, info, true);
                    int code = OS.SendMessage(this.handle, 277, wParam, lParam);
                    OS.GetScrollInfo(this.handle, 1, info);
                    OS.SetScrollInfo(this.hwndParent, 1, info, true);
                    return code;
                }
            }
            return this.callWindowProc(hwnd, msg, wParam, lParam);
        }
        return super.windowProc(hwnd, msg, wParam, lParam);
    }

    LRESULT WM_CHAR(int wParam, int lParam) {
        LRESULT result = super.WM_CHAR(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch (wParam) {
            case 32: {
                int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
                if (hItem != 0) {
                    this.hAnchor = hItem;
                    OS.SendMessage(this.handle, 4372, 0, hItem);
                    TVITEM tvItem = new TVITEM();
                    tvItem.mask = 28;
                    tvItem.hItem = hItem;
                    if ((this.style & 0x20) != 0) {
                        tvItem.stateMask = 61440;
                        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                        int state = tvItem.state >> 12;
                        state = (state & 1) != 0 ? ++state : --state;
                        tvItem.state = state << 12;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        if (!OS.IsWinCE) {
                            int id = hItem;
                            if (OS.COMCTL32_MAJOR >= 6) {
                                id = OS.SendMessage(this.handle, 4395, hItem, 0);
                            }
                            OS.NotifyWinEvent(32773, this.handle, -4, id);
                        }
                    }
                    tvItem.stateMask = 2;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    tvItem.state = (this.style & 2) != 0 && OS.GetKeyState(17) < 0 ? ((tvItem.state & 2) != 0 ? (tvItem.state &= 0xFFFFFFFD) : (tvItem.state |= 2)) : (tvItem.state |= 2);
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    TreeItem item = this._getItem(hItem, tvItem.lParam);
                    Event event = new Event();
                    event.item = item;
                    this.postEvent(13, event);
                    if ((this.style & 0x20) != 0) {
                        event = new Event();
                        event.item = item;
                        event.detail = 32;
                        this.postEvent(13, event);
                    }
                }
                return LRESULT.ZERO;
            }
            case 13: {
                Event event = new Event();
                int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
                if (hItem != 0) {
                    event.item = this._getItem(hItem);
                }
                this.postEvent(14, event);
                return LRESULT.ZERO;
            }
            case 27: {
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    LRESULT WM_ERASEBKGND(int wParam, int lParam) {
        LRESULT result = super.WM_ERASEBKGND(wParam, lParam);
        if ((this.style & 0x20000000) != 0) {
            return LRESULT.ONE;
        }
        if (this.findImageControl() != null) {
            return LRESULT.ONE;
        }
        return result;
    }

    LRESULT WM_GETOBJECT(int wParam, int lParam) {
        if (((this.style & 0x20) != 0 || this.hwndParent != 0) && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(wParam, lParam);
    }

    LRESULT WM_KEYDOWN(int wParam, int lParam) {
        LRESULT result = super.WM_KEYDOWN(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch (wParam) {
            case 32: {
                return LRESULT.ZERO;
            }
            case 107: {
                if (OS.GetKeyState(17) >= 0 || this.hwndHeader == 0) break;
                int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
                TreeColumn[] newColumns = new TreeColumn[count];
                System.arraycopy(this.columns, 0, newColumns, 0, count);
                int i = 0;
                while (i < count) {
                    TreeColumn column = newColumns[i];
                    if (!column.isDisposed() && column.getResizable()) {
                        column.pack();
                    }
                    ++i;
                }
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: {
                int hItem;
                OS.SendMessage(this.handle, 295, 3, 0);
                if ((this.style & 4) != 0) break;
                if (OS.GetKeyState(16) < 0 && (hItem = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
                    if (this.hAnchor == 0) {
                        this.hAnchor = hItem;
                    }
                    this.ignoreDeselect = true;
                    this.ignoreSelect = true;
                    int code = this.callWindowProc(this.handle, 256, wParam, lParam);
                    this.ignoreDeselect = false;
                    this.ignoreSelect = false;
                    int hNewItem = OS.SendMessage(this.handle, 4362, 9, 0);
                    TVITEM tvItem = new TVITEM();
                    tvItem.mask = 24;
                    tvItem.stateMask = 2;
                    int hDeselectItem = hItem;
                    RECT rect1 = new RECT();
                    rect1.left = this.hAnchor;
                    OS.SendMessage(this.handle, 4356, 0, rect1);
                    RECT rect2 = new RECT();
                    rect2.left = hDeselectItem;
                    OS.SendMessage(this.handle, 4356, 0, rect2);
                    int flags = rect1.top < rect2.top ? 7 : 6;
                    while (hDeselectItem != this.hAnchor) {
                        tvItem.hItem = hDeselectItem;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        hDeselectItem = OS.SendMessage(this.handle, 4362, flags, hDeselectItem);
                    }
                    int hSelectItem = this.hAnchor;
                    rect1.left = hNewItem;
                    OS.SendMessage(this.handle, 4356, 0, rect1);
                    rect2.left = hSelectItem;
                    OS.SendMessage(this.handle, 4356, 0, rect2);
                    tvItem.state = 2;
                    flags = rect1.top < rect2.top ? 7 : 6;
                    while (hSelectItem != hNewItem) {
                        tvItem.hItem = hSelectItem;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        hSelectItem = OS.SendMessage(this.handle, 4362, flags, hSelectItem);
                    }
                    tvItem.hItem = hNewItem;
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    tvItem.mask = 20;
                    tvItem.hItem = hNewItem;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    Event event = new Event();
                    event.item = this._getItem(hNewItem, tvItem.lParam);
                    this.postEvent(13, event);
                    return new LRESULT(code);
                }
                if (OS.GetKeyState(17) < 0 && (hItem = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
                    TVITEM tvItem = new TVITEM();
                    tvItem.mask = 24;
                    tvItem.stateMask = 2;
                    tvItem.hItem = hItem;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    boolean oldSelected = (tvItem.state & 2) != 0;
                    int hNewItem = 0;
                    block5 : switch (wParam) {
                        case 38: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 7, hItem);
                            break;
                        }
                        case 40: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 6, hItem);
                            break;
                        }
                        case 36: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 0, 0);
                            break;
                        }
                        case 33: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 5, 0);
                            if (hNewItem != hItem) break;
                            OS.SendMessage(this.handle, 277, 2, 0);
                            hNewItem = OS.SendMessage(this.handle, 4362, 5, 0);
                            break;
                        }
                        case 34: {
                            int hVisible;
                            RECT rect = new RECT();
                            RECT clientRect = new RECT();
                            OS.GetClientRect(this.handle, clientRect);
                            hNewItem = OS.SendMessage(this.handle, 4362, 5, 0);
                            while ((hVisible = OS.SendMessage(this.handle, 4362, 6, hNewItem)) != 0) {
                                rect.left = hVisible;
                                OS.SendMessage(this.handle, 4356, 0, rect);
                                if (rect.bottom > clientRect.bottom) break block5;
                                hNewItem = hVisible;
                                if (hNewItem == hItem) {
                                    OS.SendMessage(this.handle, 277, 3, 0);
                                }
                                if (hNewItem != 0) continue;
                                break block5;
                            }
                            break;
                        }
                        case 35: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 10, 0);
                        }
                    }
                    if (hNewItem != 0) {
                        boolean redraw;
                        OS.SendMessage(this.handle, 4372, 0, hNewItem);
                        tvItem.hItem = hNewItem;
                        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                        boolean newSelected = (tvItem.state & 2) != 0;
                        boolean bl = redraw = !newSelected && this.drawCount == 0 && OS.IsWindowVisible(this.handle);
                        if (redraw) {
                            OS.UpdateWindow(this.handle);
                            OS.DefWindowProc(this.handle, 11, 0, 0);
                        }
                        this.hSelect = hNewItem;
                        this.ignoreSelect = true;
                        OS.SendMessage(this.handle, 4363, 9, hNewItem);
                        this.ignoreSelect = false;
                        this.hSelect = 0;
                        if (oldSelected) {
                            tvItem.state = 2;
                            tvItem.hItem = hItem;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        }
                        if (!newSelected) {
                            tvItem.state = 0;
                            tvItem.hItem = hNewItem;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        }
                        if (redraw) {
                            int fItemRect;
                            RECT rect1 = new RECT();
                            RECT rect2 = new RECT();
                            rect1.left = hItem;
                            rect2.left = hNewItem;
                            int n = fItemRect = (this.style & 0x10000) != 0 ? 0 : 1;
                            if (this.hooks(40) || this.hooks(42)) {
                                fItemRect = 0;
                            }
                            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                                fItemRect = 0;
                            }
                            OS.SendMessage(this.handle, 4356, fItemRect, rect1);
                            OS.SendMessage(this.handle, 4356, fItemRect, rect2);
                            OS.DefWindowProc(this.handle, 11, 1, 0);
                            OS.InvalidateRect(this.handle, rect1, true);
                            OS.InvalidateRect(this.handle, rect2, true);
                            OS.UpdateWindow(this.handle);
                        }
                        return LRESULT.ZERO;
                    }
                }
                int code = this.callWindowProc(this.handle, 256, wParam, lParam);
                this.hAnchor = OS.SendMessage(this.handle, 4362, 9, 0);
                return new LRESULT(code);
            }
        }
        return result;
    }

    LRESULT WM_KILLFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_KILLFOCUS(wParam, lParam);
        if ((this.style & 4) != 0) {
            return result;
        }
        OS.InvalidateRect(this.handle, null, false);
        return result;
    }

    LRESULT WM_LBUTTONDBLCLK(int wParam, int lParam) {
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = (short)(lParam & 0xFFFF);
        lpht.y = (short)(lParam >> 16);
        OS.SendMessage(this.handle, 4369, 0, lpht);
        if (lpht.hItem != 0 && (this.style & 0x20) != 0 && (lpht.flags & 0x40) != 0) {
            Display display = this.display;
            display.captureChanged = false;
            this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam);
            if (!this.sendMouseEvent(8, 1, this.handle, 515, wParam, lParam)) {
                if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                    OS.SetCapture(this.handle);
                }
                return LRESULT.ZERO;
            }
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            OS.SetFocus(this.handle);
            TVITEM tvItem = new TVITEM();
            tvItem.hItem = lpht.hItem;
            tvItem.mask = 28;
            tvItem.stateMask = 61440;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            int state = tvItem.state >> 12;
            state = (state & 1) != 0 ? ++state : --state;
            tvItem.state = state << 12;
            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            if (!OS.IsWinCE) {
                int id = tvItem.hItem;
                if (OS.COMCTL32_MAJOR >= 6) {
                    id = OS.SendMessage(this.handle, 4395, tvItem.hItem, 0);
                }
                OS.NotifyWinEvent(32773, this.handle, -4, id);
            }
            Event event = new Event();
            event.item = this._getItem(tvItem.hItem, tvItem.lParam);
            event.detail = 32;
            this.postEvent(13, event);
            return LRESULT.ZERO;
        }
        LRESULT result = super.WM_LBUTTONDBLCLK(wParam, lParam);
        if (result == LRESULT.ZERO) {
            return result;
        }
        if (lpht.hItem != 0 && ((this.style & 0x10000) != 0 || (lpht.flags & 0x46) != 0)) {
            Event event = new Event();
            event.item = this._getItem(lpht.hItem);
            this.postEvent(14, event);
        }
        return result;
    }

    LRESULT WM_LBUTTONDOWN(int wParam, int lParam) {
        int bits;
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = (short)(lParam & 0xFFFF);
        lpht.y = (short)(lParam >> 16);
        OS.SendMessage(this.handle, 4369, 0, lpht);
        if (lpht.hItem == 0 || (lpht.flags & 0x10) != 0) {
            int hSelection;
            Display display = this.display;
            display.captureChanged = false;
            if (!this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam)) {
                if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                    OS.SetCapture(this.handle);
                }
                return LRESULT.ZERO;
            }
            boolean fixSelection = false;
            boolean deselected = false;
            if (lpht.hItem != 0 && (this.style & 2) != 0 && (hSelection = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 24;
                tvItem.hItem = lpht.hItem;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                if ((tvItem.state & 0x20) != 0) {
                    fixSelection = true;
                    tvItem.stateMask = 2;
                    int hNext = OS.SendMessage(this.handle, 4362, 6, lpht.hItem);
                    while (hNext != 0) {
                        tvItem.hItem = hNext;
                        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                        if ((tvItem.state & 2) != 0) {
                            deselected = true;
                        }
                        tvItem.state = 0;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        int hItem = hNext = OS.SendMessage(this.handle, 4362, 6, hNext);
                        while (hItem != 0 && hItem != lpht.hItem) {
                            hItem = OS.SendMessage(this.handle, 4362, 3, hItem);
                        }
                        if (hItem == 0) break;
                    }
                }
            }
            this.gestureCompleted = false;
            this.dragStarted = false;
            if (fixSelection) {
                this.lockSelection = true;
                this.ignoreSelect = true;
                this.ignoreDeselect = true;
            }
            int code = this.callWindowProc(this.handle, 513, wParam, lParam);
            if (fixSelection) {
                this.lockSelection = false;
                this.ignoreSelect = false;
                this.ignoreDeselect = false;
            }
            if (this.dragStarted && !display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            if (deselected) {
                Event event = new Event();
                event.item = this._getItem(lpht.hItem);
                this.postEvent(13, event);
            }
            return new LRESULT(code);
        }
        if ((this.style & 0x20) != 0 && (lpht.flags & 0x40) != 0) {
            Display display = this.display;
            display.captureChanged = false;
            if (!this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam)) {
                if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                    OS.SetCapture(this.handle);
                }
                return LRESULT.ZERO;
            }
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            OS.SetFocus(this.handle);
            TVITEM tvItem = new TVITEM();
            tvItem.hItem = lpht.hItem;
            tvItem.mask = 28;
            tvItem.stateMask = 61440;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            int state = tvItem.state >> 12;
            state = (state & 1) != 0 ? ++state : --state;
            tvItem.state = state << 12;
            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            if (!OS.IsWinCE) {
                int id = tvItem.hItem;
                if (OS.COMCTL32_MAJOR >= 6) {
                    id = OS.SendMessage(this.handle, 4395, tvItem.hItem, 0);
                }
                OS.NotifyWinEvent(32773, this.handle, -4, id);
            }
            Event event = new Event();
            event.item = this._getItem(tvItem.hItem, tvItem.lParam);
            event.detail = 32;
            this.postEvent(13, event);
            return LRESULT.ZERO;
        }
        if ((this.style & 0x10000) == 0 && (lpht.flags & 0x46) == 0) {
            Display display = this.display;
            display.captureChanged = false;
            if (!this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam)) {
                if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                    OS.SetCapture(this.handle);
                }
                return LRESULT.ZERO;
            }
            int code = this.callWindowProc(this.handle, 513, wParam, lParam);
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return new LRESULT(code);
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 2;
        boolean hittestSelected = false;
        boolean focused = false;
        if ((this.style & 2) != 0) {
            tvItem.hItem = lpht.hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            hittestSelected = (tvItem.state & 2) != 0;
            focused = OS.GetFocus() == this.handle;
        }
        boolean redraw = false;
        int hOldItem = OS.SendMessage(this.handle, 4362, 9, 0);
        if ((this.style & 2) != 0) {
            tvItem.hItem = hOldItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if (hittestSelected || (wParam & 8) != 0) {
                boolean bl = redraw = focused && this.drawCount == 0 && OS.IsWindowVisible(this.handle);
                if (redraw) {
                    OS.UpdateWindow(this.handle);
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                }
            } else {
                this.deselectAll();
            }
        }
        Display display = this.display;
        display.captureChanged = false;
        if (!this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam)) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        this.hSelect = lpht.hItem;
        this.gestureCompleted = false;
        this.dragStarted = false;
        this.ignoreSelect = true;
        this.ignoreDeselect = true;
        int code = this.callWindowProc(this.handle, 513, wParam, lParam);
        int hNewItem = OS.SendMessage(this.handle, 4362, 9, 0);
        if ((this.style & 0x10000) != 0 && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x1000) == 0 && hNewItem == hOldItem && lpht.hItem != hOldItem) {
            OS.SendMessage(this.handle, 4363, 9, lpht.hItem);
            hNewItem = OS.SendMessage(this.handle, 4362, 9, 0);
        }
        this.ignoreSelect = false;
        this.ignoreDeselect = false;
        this.hSelect = 0;
        if (this.dragStarted && !display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if ((this.style & 4) != 0 && hOldItem == hNewItem) {
            tvItem.mask = 24;
            tvItem.state = 2;
            tvItem.stateMask = 2;
            tvItem.hItem = hNewItem;
            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
        }
        if ((this.style & 2) != 0) {
            if (hittestSelected || (wParam & 8) != 0) {
                if (hOldItem == hNewItem && hOldItem == lpht.hItem) {
                    if ((wParam & 8) != 0) {
                        tvItem.state ^= 2;
                        if (this.dragStarted) {
                            tvItem.state = 2;
                        }
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                } else {
                    if ((tvItem.state & 2) != 0) {
                        tvItem.state = 2;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                    if ((wParam & 8) != 0 && !this.dragStarted && hittestSelected) {
                        tvItem.state = 0;
                        tvItem.hItem = lpht.hItem;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                }
                if (redraw) {
                    int fItemRect;
                    RECT rect1 = new RECT();
                    RECT rect2 = new RECT();
                    rect1.left = hOldItem;
                    rect2.left = hNewItem;
                    int n = fItemRect = (this.style & 0x10000) != 0 ? 0 : 1;
                    if (this.hooks(40) || this.hooks(42)) {
                        fItemRect = 0;
                    }
                    if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                        fItemRect = 0;
                    }
                    OS.SendMessage(this.handle, 4356, fItemRect, rect1);
                    OS.SendMessage(this.handle, 4356, fItemRect, rect2);
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    OS.InvalidateRect(this.handle, rect1, true);
                    OS.InvalidateRect(this.handle, rect2, true);
                    OS.UpdateWindow(this.handle);
                }
            }
            if (!((wParam & 8) != 0 || hittestSelected && this.dragStarted)) {
                tvItem.state = 0;
                int oldProc = OS.GetWindowLong(this.handle, -4);
                OS.SetWindowLong(this.handle, -4, TreeProc);
                if ((this.style & 0x10000000) != 0) {
                    int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
                    this.deselect(hItem, tvItem, hNewItem);
                } else {
                    int i = 0;
                    while (i < this.items.length) {
                        TreeItem item = this.items[i];
                        if (item != null && item.handle != hNewItem) {
                            tvItem.hItem = item.handle;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        }
                        ++i;
                    }
                }
                tvItem.hItem = hNewItem;
                tvItem.state = 2;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                OS.SetWindowLong(this.handle, -4, oldProc);
                if ((wParam & 4) != 0) {
                    RECT rect1 = new RECT();
                    if (this.hAnchor == 0) {
                        this.hAnchor = hNewItem;
                    }
                    rect1.left = this.hAnchor;
                    if (OS.SendMessage(this.handle, 4356, 0, rect1) != 0) {
                        RECT rect2 = new RECT();
                        rect2.left = hNewItem;
                        OS.SendMessage(this.handle, 4356, 0, rect2);
                        int flags = rect1.top < rect2.top ? 6 : 7;
                        tvItem.state = 2;
                        int hItem = tvItem.hItem = this.hAnchor;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        while (hItem != hNewItem) {
                            tvItem.hItem = hItem;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                            hItem = OS.SendMessage(this.handle, 4362, flags, hItem);
                        }
                    }
                }
            }
        }
        if ((wParam & 4) == 0) {
            this.hAnchor = hNewItem;
        }
        if (!this.gestureCompleted) {
            tvItem.hItem = hNewItem;
            tvItem.mask = 20;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            Event event = new Event();
            event.item = this._getItem(tvItem.hItem, tvItem.lParam);
            this.postEvent(13, event);
        }
        this.gestureCompleted = false;
        if (this.dragStarted) {
            this.sendDragEvent((short)(lParam & 0xFFFF), (short)(lParam >> 16));
        } else {
            bits = OS.GetWindowLong(this.handle, -16);
            if ((bits & 0x10) == 0) {
                this.sendMouseEvent(4, 1, this.handle, 514, wParam, lParam);
            }
        }
        this.dragStarted = false;
        return new LRESULT(code);
    }

    LRESULT WM_MOUSEMOVE(int wParam, int lParam) {
        int mask;
        LRESULT result = super.WM_MOUSEMOVE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.itemToolTipHandle != 0 && this.hwndHeader != 0 && (wParam & 0xFFFF & (mask = 115)) == 0) {
            TVHITTESTINFO lpht = new TVHITTESTINFO();
            lpht.x = (short)(lParam & 0xFFFF);
            lpht.y = (short)(lParam >> 16);
            OS.SendMessage(this.handle, 4369, 0, lpht);
            if (lpht.hItem != 0) {
                int hDC = OS.GetDC(this.handle);
                int oldFont = 0;
                int newFont = OS.SendMessage(this.handle, 49, 0, 0);
                if (newFont != 0) {
                    oldFont = OS.SelectObject(hDC, newFont);
                }
                POINT pt = new POINT();
                pt.x = lpht.x;
                pt.y = lpht.y;
                RECT rect = new RECT();
                OS.GetClientRect(this.hwndParent, rect);
                OS.MapWindowPoints(this.hwndParent, this.handle, rect, 2);
                TreeItem item = this._getItem(lpht.hItem);
                int index = 0;
                int count = Math.max(1, OS.SendMessage(this.hwndHeader, 4608, 0, 0));
                int[] order = new int[count];
                OS.SendMessage(this.hwndHeader, 4625, count, order);
                while (index < count) {
                    int hFont;
                    int n = hFont = item.cellFont != null ? item.cellFont[order[index]] : -1;
                    if (hFont == -1) {
                        hFont = item.font;
                    }
                    if (hFont != -1) {
                        hFont = OS.SelectObject(hDC, hFont);
                    }
                    RECT cellRect = item.getBounds(order[index], true, false, true, false, true, hDC);
                    if (hFont != -1) {
                        OS.SelectObject(hDC, hFont);
                    }
                    if (cellRect.left > rect.right) break;
                    cellRect.right = Math.min(cellRect.right, rect.right);
                    if (OS.PtInRect(cellRect, pt)) {
                        RECT textRect = item.getBounds(order[index], true, false, false, false, false, hDC);
                        if (textRect.right <= cellRect.right) break;
                        TOOLINFO lpti = new TOOLINFO();
                        lpti.cbSize = TOOLINFO.sizeof;
                        lpti.hwnd = this.handle;
                        lpti.uId = this.handle;
                        lpti.uFlags = 272;
                        lpti.left = cellRect.left;
                        lpti.top = cellRect.top;
                        lpti.right = cellRect.right;
                        lpti.bottom = cellRect.bottom;
                        OS.SendMessage(this.itemToolTipHandle, OS.TTM_NEWTOOLRECT, 0, lpti);
                        break;
                    }
                    ++index;
                }
                if (newFont != 0) {
                    OS.SelectObject(hDC, oldFont);
                }
                OS.ReleaseDC(this.handle, hDC);
            }
        }
        return result;
    }

    LRESULT WM_MOVE(int wParam, int lParam) {
        if (this.ignoreResize) {
            return null;
        }
        return super.WM_MOVE(wParam, lParam);
    }

    LRESULT WM_NOTIFY(int wParam, int lParam) {
        RECT rect;
        NMHDR hdr = new NMHDR();
        OS.MoveMemory(hdr, lParam, 12);
        if (hdr.hwndFrom == this.itemToolTipHandle && this.hwndHeader != 0 && !OS.IsWinCE) {
            switch (hdr.code) {
                case -521: {
                    int pos = OS.GetMessagePos();
                    POINT pt = new POINT();
                    pt.x = (short)(pos & 0xFFFF);
                    pt.y = (short)(pos >> 16);
                    OS.ScreenToClient(this.handle, pt);
                    TVHITTESTINFO lpht = new TVHITTESTINFO();
                    lpht.x = pt.x;
                    lpht.y = pt.y;
                    OS.SendMessage(this.handle, 4369, 0, lpht);
                    if (lpht.hItem == 0) break;
                    int hDC = OS.GetDC(this.handle);
                    int oldFont = 0;
                    int newFont = OS.SendMessage(this.handle, 49, 0, 0);
                    if (newFont != 0) {
                        oldFont = OS.SelectObject(hDC, newFont);
                    }
                    LRESULT result = null;
                    rect = new RECT();
                    OS.GetClientRect(this.hwndParent, rect);
                    OS.MapWindowPoints(this.hwndParent, this.handle, rect, 2);
                    TreeItem item = this._getItem(lpht.hItem);
                    int index = 0;
                    int count = Math.max(1, OS.SendMessage(this.hwndHeader, 4608, 0, 0));
                    int[] order = new int[count];
                    OS.SendMessage(this.hwndHeader, 4625, count, order);
                    while (index < count) {
                        int hFont;
                        int n = hFont = item.cellFont != null ? item.cellFont[order[index]] : -1;
                        if (hFont == -1) {
                            hFont = item.font;
                        }
                        if (hFont != -1) {
                            hFont = OS.SelectObject(hDC, hFont);
                        }
                        RECT cellRect = item.getBounds(order[index], true, false, true, false, true, hDC);
                        if (hFont != -1) {
                            OS.SelectObject(hDC, hFont);
                        }
                        if (cellRect.left > rect.right) break;
                        cellRect.right = Math.min(cellRect.right, rect.right);
                        if (OS.PtInRect(cellRect, pt)) {
                            RECT textRect = item.getBounds(order[index], true, false, false, false, false, hDC);
                            if (textRect.right <= cellRect.right) break;
                            OS.MapWindowPoints(this.handle, 0, textRect, 2);
                            int flags = 21;
                            this.SetWindowPos(this.itemToolTipHandle, 0, textRect.left, textRect.top, 0, 0, flags);
                            result = LRESULT.ONE;
                            break;
                        }
                        ++index;
                    }
                    if (newFont != 0) {
                        OS.SelectObject(hDC, oldFont);
                    }
                    OS.ReleaseDC(this.handle, hDC);
                    if (result == null) break;
                    return result;
                }
            }
        }
        if (hdr.hwndFrom == this.hwndHeader) {
            switch (hdr.code) {
                case -326: 
                case -325: 
                case -306: 
                case -305: {
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    TreeColumn column = this.columns[phdn.iItem];
                    if (column != null && !column.getResizable()) {
                        return LRESULT.ONE;
                    }
                    this.ignoreColumnMove = true;
                    switch (hdr.code) {
                        case -325: 
                        case -305: {
                            if (column == null) break;
                            column.pack();
                        }
                    }
                    break;
                }
                case -16: {
                    TreeColumn column;
                    if (!this.ignoreColumnMove) {
                        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
                        int i = 0;
                        while (i < count) {
                            column = this.columns[i];
                            column.updateToolTip(i);
                            ++i;
                        }
                        this.updateImageList();
                    }
                    this.ignoreColumnMove = false;
                    break;
                }
                case -310: {
                    TreeColumn column;
                    if (this.ignoreColumnMove) {
                        return LRESULT.ONE;
                    }
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    if (phdn.iItem == -1 || (column = this.columns[phdn.iItem]) == null || column.getMoveable()) break;
                    this.ignoreColumnMove = true;
                    return LRESULT.ONE;
                }
                case -311: {
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    if (phdn.iItem == -1 || phdn.pitem == 0) break;
                    HDITEM pitem = new HDITEM();
                    OS.MoveMemory(pitem, phdn.pitem, HDITEM.sizeof);
                    if ((pitem.mask & 0x80) == 0 || pitem.iOrder == -1) break;
                    int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
                    int[] order = new int[count];
                    OS.SendMessage(this.hwndHeader, 4625, count, order);
                    int index = 0;
                    while (index < order.length) {
                        if (order[index] == phdn.iItem) break;
                        ++index;
                    }
                    if (index == order.length) {
                        index = 0;
                    }
                    if (index == pitem.iOrder) break;
                    int start = Math.min(index, pitem.iOrder);
                    int end = Math.max(index, pitem.iOrder);
                    rect = new RECT();
                    RECT headerRect = new RECT();
                    OS.GetClientRect(this.handle, rect);
                    OS.SendMessage(this.hwndHeader, 4615, order[start], headerRect);
                    rect.left = Math.max(rect.left, headerRect.left);
                    OS.SendMessage(this.hwndHeader, 4615, order[end], headerRect);
                    rect.right = Math.min(rect.right, headerRect.right);
                    OS.InvalidateRect(this.handle, rect, true);
                    this.ignoreColumnMove = false;
                    int i = start;
                    while (i <= end) {
                        TreeColumn column = this.columns[order[i]];
                        if (!column.isDisposed()) {
                            column.postEvent(10);
                        }
                        ++i;
                    }
                    break;
                }
                case -320: 
                case -300: {
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    if (phdn.pitem == 0) break;
                    HDITEM newItem = new HDITEM();
                    OS.MoveMemory(newItem, phdn.pitem, HDITEM.sizeof);
                    if ((newItem.mask & 1) == 0) break;
                    RECT rect2 = new RECT();
                    OS.GetClientRect(this.handle, rect2);
                    RECT headerRect = new RECT();
                    int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
                    int index = OS.SendMessage(this.hwndHeader, 4623, count - 1, 0);
                    OS.SendMessage(this.hwndHeader, 4615, index, headerRect);
                    rect2.right = Math.max(rect2.right, headerRect.right);
                    OS.SendMessage(this.hwndHeader, 4615, phdn.iItem, headerRect);
                    int gridWidth = this.getLinesVisible() ? 1 : 0;
                    rect2.left = headerRect.right - gridWidth;
                    if (this.findImageControl() != null || this.hooks(40) || this.hooks(42)) {
                        OS.InvalidateRect(this.handle, rect2, true);
                    } else {
                        HDITEM oldItem = new HDITEM();
                        oldItem.mask = 1;
                        OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, phdn.iItem, oldItem);
                        int deltaX = newItem.cxy - oldItem.cxy;
                        int flags = 6;
                        OS.ScrollWindowEx(this.handle, deltaX, 0, rect2, null, 0, null, flags);
                    }
                    if (OS.SendMessage(this.hwndHeader, 4623, phdn.iItem, 0) != 0) {
                        rect2.left = headerRect.left;
                        rect2.right = headerRect.right;
                        OS.InvalidateRect(this.handle, rect2, true);
                    }
                    this.setScrollWidth();
                    break;
                }
                case -321: 
                case -301: {
                    TreeColumn column;
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    if (phdn.pitem == 0) break;
                    HDITEM pitem = new HDITEM();
                    OS.MoveMemory(pitem, phdn.pitem, HDITEM.sizeof);
                    if ((pitem.mask & 1) != 0) {
                        if ((this.style & 0x20000000) == 0 && this.ignoreColumnMove) {
                            int oldStyle = this.style;
                            this.style |= 0x20000000;
                            OS.UpdateWindow(this.handle);
                            this.style = oldStyle;
                        }
                        if ((column = this.columns[phdn.iItem]) != null) {
                            column.updateToolTip(phdn.iItem);
                            column.sendEvent(11);
                            if (this.isDisposed()) {
                                return LRESULT.ZERO;
                            }
                            int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
                            TreeColumn[] newColumns = new TreeColumn[count];
                            System.arraycopy(this.columns, 0, newColumns, 0, count);
                            int[] order = new int[count];
                            OS.SendMessage(this.hwndHeader, 4625, count, order);
                            boolean moved = false;
                            int i = 0;
                            while (i < count) {
                                TreeColumn nextColumn = newColumns[order[i]];
                                if (moved && !nextColumn.isDisposed()) {
                                    nextColumn.updateToolTip(order[i]);
                                    nextColumn.sendEvent(10);
                                }
                                if (nextColumn == column) {
                                    moved = true;
                                }
                                ++i;
                            }
                        }
                    }
                    this.setScrollWidth();
                    break;
                }
                case -322: 
                case -302: {
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    TreeColumn column = this.columns[phdn.iItem];
                    if (column == null) break;
                    column.postEvent(13);
                    break;
                }
                case -323: 
                case -303: {
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    TreeColumn column = this.columns[phdn.iItem];
                    if (column == null) break;
                    column.postEvent(14);
                }
            }
        }
        return super.WM_NOTIFY(wParam, lParam);
    }

    LRESULT WM_RBUTTONDOWN(int wParam, int lParam) {
        Display display = this.display;
        display.captureChanged = false;
        if (!this.sendMouseEvent(3, 3, this.handle, 516, wParam, lParam)) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        this.setFocus();
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = (short)(lParam & 0xFFFF);
        lpht.y = (short)(lParam >> 16);
        OS.SendMessage(this.handle, 4369, 0, lpht);
        if (lpht.hItem != 0) {
            int flags = 6;
            if (((this.style & 0x10000) != 0 || (lpht.flags & flags) != 0) && (wParam & 0xC) == 0) {
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 24;
                tvItem.stateMask = 2;
                tvItem.hItem = lpht.hItem;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                if ((tvItem.state & 2) == 0) {
                    this.ignoreSelect = true;
                    OS.SendMessage(this.handle, 4363, 9, 0);
                    this.ignoreSelect = false;
                    OS.SendMessage(this.handle, 4363, 9, lpht.hItem);
                }
            }
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PAINT(int wParam, int lParam) {
        if (this.shrink && !this.ignoreShrink) {
            int count = this.items.length - 1;
            while (count >= 0) {
                if (this.items[count] != null) break;
                --count;
            }
            if (this.items.length > 4 && this.items.length - ++count > 3) {
                int length = Math.max(4, (count + 3) / 4 * 4);
                TreeItem[] newItems = new TreeItem[length];
                System.arraycopy(this.items, 0, newItems, 0, count);
                this.items = newItems;
            }
            this.shrink = false;
        }
        if ((this.style & 0x20000000) != 0 || this.findImageControl() != null) {
            GC gc = null;
            int paintDC = 0;
            PAINTSTRUCT ps = new PAINTSTRUCT();
            if (this.hooks(9)) {
                GCData data = new GCData();
                data.ps = ps;
                data.hwnd = this.handle;
                gc = GC.win32_new(this, data);
                paintDC = gc.handle;
            } else {
                paintDC = OS.BeginPaint(this.handle, ps);
            }
            this.forceResize();
            RECT rect = new RECT();
            OS.GetClientRect(this.handle, rect);
            int x = rect.left;
            int y = rect.top;
            int width = rect.right - rect.left;
            int height = rect.bottom - rect.top;
            int hDC = OS.CreateCompatibleDC(paintDC);
            int hBitmap = OS.CreateCompatibleBitmap(paintDC, width, height);
            int hOldBitmap = OS.SelectObject(hDC, hBitmap);
            this.drawBackground(hDC, rect);
            int code = this.callWindowProc(this.handle, 15, hDC, 0);
            OS.BitBlt(paintDC, x, y, width, height, hDC, 0, 0, 0xCC0020);
            OS.SelectObject(hDC, hOldBitmap);
            OS.DeleteObject(hBitmap);
            OS.DeleteObject(hDC);
            if (this.hooks(9)) {
                Event event = new Event();
                event.gc = gc;
                event.x = ps.left;
                event.y = ps.top;
                event.width = ps.right - ps.left;
                event.height = ps.bottom - ps.top;
                this.sendEvent(9, event);
                event.gc = null;
                gc.dispose();
            } else {
                OS.EndPaint(this.handle, ps);
            }
            return new LRESULT(code);
        }
        return super.WM_PAINT(wParam, lParam);
    }

    LRESULT WM_PRINTCLIENT(int wParam, int lParam) {
        LRESULT result = super.WM_PRINTCLIENT(wParam, lParam);
        if (result != null) {
            return result;
        }
        this.printClient = true;
        int code = this.callWindowProc(this.handle, 792, wParam, lParam);
        this.printClient = false;
        return new LRESULT(code);
    }

    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        if ((this.style & 4) != 0) {
            return result;
        }
        OS.InvalidateRect(this.handle, null, false);
        return result;
    }

    LRESULT WM_SETFONT(int wParam, int lParam) {
        LRESULT result = super.WM_SETFONT(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.hwndHeader != 0) {
            OS.SendMessage(this.hwndHeader, 48, wParam, lParam);
        }
        if (this.itemToolTipHandle != 0) {
            OS.SendMessage(this.itemToolTipHandle, 48, wParam, lParam);
        }
        if (this.headerToolTipHandle != 0) {
            OS.SendMessage(this.headerToolTipHandle, 48, wParam, lParam);
        }
        return result;
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0x8000) != 0 && !OS.IsWinCE) {
            OS.ShowScrollBar(this.handle, 0, false);
        }
        if (this.ignoreResize) {
            return null;
        }
        return super.WM_SIZE(wParam, lParam);
    }

    LRESULT WM_SYSCOLORCHANGE(int wParam, int lParam) {
        LRESULT result = super.WM_SYSCOLORCHANGE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
        return result;
    }

    LRESULT wmColorChild(int wParam, int lParam) {
        if (this.findImageControl() != null) {
            if (OS.COMCTL32_MAJOR < 6) {
                return super.wmColorChild(wParam, lParam);
            }
            return new LRESULT(OS.GetStockObject(5));
        }
        return null;
    }

    LRESULT wmNotifyChild(int wParam, int lParam) {
        NMHDR hdr = new NMHDR();
        OS.MoveMemory(hdr, lParam, 12);
        switch (hdr.code) {
            case -452: 
            case -403: {
                TreeItem item;
                NMTVDISPINFO lptvdi = new NMTVDISPINFO();
                OS.MoveMemory(lptvdi, lParam, 52);
                if ((this.style & 0x10000000) != 0) {
                    boolean checkVisible = true;
                    if (!this.ignoreShrink && this.items != null && lptvdi.lParam != -1 && this.items[lptvdi.lParam] != null && this.items[lptvdi.lParam].cached) {
                        checkVisible = false;
                    }
                    if (checkVisible) {
                        if (this.drawCount != 0 || !OS.IsWindowVisible(this.handle)) break;
                        RECT itemRect = new RECT();
                        itemRect.left = lptvdi.hItem;
                        if (OS.SendMessage(this.handle, 4356, 0, itemRect) == 0) break;
                        RECT rect = new RECT();
                        OS.GetClientRect(this.handle, rect);
                        if (!OS.IntersectRect(rect, rect, itemRect)) break;
                        if (this.ignoreShrink) {
                            OS.InvalidateRect(this.handle, rect, true);
                            break;
                        }
                    }
                }
                if (this.items == null) break;
                int id = lptvdi.lParam;
                if ((this.style & 0x10000000) != 0 && id == -1) {
                    TVITEM tvItem = new TVITEM();
                    tvItem.mask = 20;
                    tvItem.hItem = lptvdi.hItem;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    id = tvItem.lParam;
                }
                if ((item = this._getItem(lptvdi.hItem, id)) == null || item.isDisposed()) break;
                if (!item.cached) {
                    if ((this.style & 0x10000000) != 0 && !this.checkData(item, false)) break;
                    if (this.painted) {
                        item.cached = true;
                    }
                }
                int index = 0;
                if (this.hwndHeader != 0) {
                    index = OS.SendMessage(this.hwndHeader, 4623, 0, 0);
                }
                if ((lptvdi.mask & 1) != 0) {
                    String string = null;
                    if (index == 0) {
                        string = item.text;
                    } else {
                        String[] strings = item.strings;
                        if (strings != null) {
                            string = strings[index];
                        }
                    }
                    if (string != null) {
                        TCHAR buffer = new TCHAR(this.getCodePage(), string, false);
                        int byteCount = Math.min(buffer.length(), lptvdi.cchTextMax - 1) * TCHAR.sizeof;
                        OS.MoveMemory(lptvdi.pszText, buffer, byteCount);
                        OS.MoveMemory(lptvdi.pszText + byteCount, new byte[TCHAR.sizeof], TCHAR.sizeof);
                        lptvdi.cchTextMax = Math.min(lptvdi.cchTextMax, string.length() + 1);
                    }
                }
                if ((lptvdi.mask & 0x22) != 0) {
                    Image image = null;
                    if (index == 0) {
                        image = item.image;
                    } else {
                        Image[] images = item.images;
                        if (images != null) {
                            image = images[index];
                        }
                    }
                    lptvdi.iSelectedImage = -2;
                    lptvdi.iImage = -2;
                    if (image != null) {
                        lptvdi.iImage = lptvdi.iSelectedImage = this.imageIndex(image, index);
                    }
                }
                OS.MoveMemory(lParam, lptvdi, 52);
                break;
            }
            case -12: {
                if (hdr.hwndFrom == this.hwndHeader) break;
                if (this.hooks(41) && this.hwndHeader == 0) {
                    this.createParent();
                }
                if (!this.customDraw && this.findImageControl() == null && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (this.sortColumn == null || this.sortDirection == 0)) break;
                NMTVCUSTOMDRAW nmcd = new NMTVCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, NMTVCUSTOMDRAW.sizeof);
                switch (nmcd.dwDrawStage) {
                    case 1: {
                        return this.CDDS_PREPAINT(wParam, lParam);
                    }
                    case 65537: {
                        return this.CDDS_ITEMPREPAINT(wParam, lParam);
                    }
                    case 65538: {
                        return this.CDDS_ITEMPOSTPAINT(wParam, lParam);
                    }
                    case 2: {
                        return this.CDDS_POSTPAINT(wParam, lParam);
                    }
                }
                break;
            }
            case -3: {
                if (!this.hooks(14)) break;
                return LRESULT.ONE;
            }
            case -451: 
            case -402: {
                int offset;
                TVITEM tvItem;
                if ((this.style & 2) != 0 && this.lockSelection) {
                    if (this.oldSelected) {
                        tvItem = new TVITEM();
                        offset = 16;
                        OS.MoveMemory(tvItem, lParam + offset, 40);
                        tvItem.mask = 8;
                        tvItem.stateMask = 2;
                        tvItem.state = 2;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                    if (!this.newSelected && this.ignoreSelect) {
                        tvItem = new TVITEM();
                        offset = 56;
                        OS.MoveMemory(tvItem, lParam + offset, 40);
                        tvItem.mask = 8;
                        tvItem.stateMask = 2;
                        tvItem.state = 0;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                }
                if (!this.ignoreSelect) {
                    tvItem = new TVITEM();
                    offset = 56;
                    OS.MoveMemory(tvItem, lParam + offset, 40);
                    this.hAnchor = tvItem.hItem;
                    Event event = new Event();
                    event.item = this._getItem(tvItem.hItem, tvItem.lParam);
                    this.postEvent(13, event);
                }
                this.updateScrollBar();
                break;
            }
            case -417: 
            case -416: {
                if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(6, 0) || (this.style & 2) == 0) break;
                if (this.hSelect != 0) {
                    NMTVITEMCHANGE pItemChange = new NMTVITEMCHANGE();
                    OS.MoveMemory(pItemChange, lParam, NMTVITEMCHANGE.sizeof);
                    if (this.hSelect == pItemChange.hItem) break;
                    return LRESULT.ONE;
                }
                if (!this.lockSelection) break;
                return LRESULT.ONE;
            }
            case -450: 
            case -401: {
                if ((this.style & 2) != 0 && this.lockSelection) {
                    TVITEM tvItem = new TVITEM();
                    int offset1 = 16;
                    OS.MoveMemory(tvItem, lParam + offset1, 40);
                    this.oldSelected = (tvItem.state & 2) != 0;
                    int offset2 = 56;
                    OS.MoveMemory(tvItem, lParam + offset2, 40);
                    boolean bl = this.newSelected = (tvItem.state & 2) != 0;
                }
                if (this.ignoreSelect || this.ignoreDeselect) break;
                this.hAnchor = 0;
                if ((this.style & 2) == 0) break;
                this.deselectAll();
                break;
            }
            case -454: 
            case -405: {
                boolean runExpanded = false;
                if ((this.style & 0x10000000) != 0) {
                    this.style &= 0xDFFFFFFF;
                }
                if (this.hooks(40) || this.hooks(42)) {
                    this.style &= 0xDFFFFFFF;
                }
                if (this.findImageControl() != null && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                }
                if (this.hInsert != 0) {
                    OS.SendMessage(this.handle, 4378, 0, 0);
                }
                if (!this.ignoreExpand) {
                    TreeItem item;
                    TVITEM tvItem = new TVITEM();
                    int offset = 56;
                    OS.MoveMemory(tvItem, lParam + offset, 40);
                    if (this.items == null || (item = this._getItem(tvItem.hItem, tvItem.lParam)) == null) break;
                    Event event = new Event();
                    event.item = item;
                    int[] action = new int[1];
                    OS.MoveMemory(action, lParam + 12, 4);
                    switch (action[0]) {
                        case 2: {
                            if ((tvItem.state & 0x20) != 0) break;
                            this.sendEvent(17, event);
                            if (!this.isDisposed()) break;
                            return LRESULT.ZERO;
                        }
                        case 1: {
                            this.sendEvent(18, event);
                            if (!this.isDisposed()) break;
                            return LRESULT.ZERO;
                        }
                    }
                    int hFirstItem = OS.SendMessage(this.handle, 4362, 4, tvItem.hItem);
                    boolean bl = runExpanded = hFirstItem == 0;
                }
                if (!runExpanded) break;
            }
            case -455: 
            case -406: {
                if ((this.style & 0x10000000) != 0) {
                    this.style |= 0x20000000;
                }
                if (this.hooks(40) || this.hooks(42)) {
                    this.style |= 0x20000000;
                }
                if (this.findImageControl() != null && this.drawCount == 0) {
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    OS.InvalidateRect(this.handle, null, true);
                }
                if (this.hInsert != 0) {
                    OS.SendMessage(this.handle, 4378, this.insertAfter ? 1 : 0, this.hInsert);
                }
                this.updateScrollBar();
                break;
            }
            case -457: 
            case -456: 
            case -408: 
            case -407: {
                TVITEM tvItem = new TVITEM();
                int offset = 56;
                OS.MoveMemory(tvItem, lParam + offset, 40);
                if (tvItem.hItem != 0 && (tvItem.state & 2) == 0) {
                    this.hSelect = tvItem.hItem;
                    this.ignoreDeselect = true;
                    this.ignoreSelect = true;
                    OS.SendMessage(this.handle, 4363, 9, tvItem.hItem);
                    this.ignoreDeselect = false;
                    this.ignoreSelect = false;
                    this.hSelect = 0;
                }
                this.dragStarted = true;
                break;
            }
            case -16: {
                boolean hasMenu;
                if (!OS.IsPPC) break;
                boolean bl = hasMenu = this.menu != null && !this.menu.isDisposed();
                if (hasMenu || this.hooks(35)) break;
                return LRESULT.ONE;
            }
            case 1000: {
                boolean hasMenu;
                if (!OS.IsPPC) break;
                boolean bl = hasMenu = this.menu != null && !this.menu.isDisposed();
                if (!hasMenu && !this.hooks(35)) break;
                NMRGINFO nmrg = new NMRGINFO();
                OS.MoveMemory(nmrg, lParam, NMRGINFO.sizeof);
                this.showMenu(nmrg.x, nmrg.y);
                this.gestureCompleted = true;
                return LRESULT.ONE;
            }
        }
        return super.wmNotifyChild(wParam, lParam);
    }
}

