/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.osgi.framework.debug.Debug;

public abstract class BundleEntry {
    protected static final int BUF_SIZE = 8192;

    public abstract InputStream getInputStream() throws IOException;

    public abstract long getSize();

    public abstract String getName();

    public abstract long getTime();

    public abstract URL getLocalURL();

    public abstract URL getFileURL();

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes() throws IOException {
        byte[] classbytes;
        InputStream in = this.getInputStream();
        int length = (int)this.getSize();
        int bytesread = 0;
        if (Debug.DEBUG_LOADER) {
            Debug.println("  about to read " + length + " bytes from " + this.getName());
        }
        try {
            byte[] oldbytes;
            if (length > 0) {
                int readcount;
                classbytes = new byte[length];
                while (bytesread < length && (readcount = in.read(classbytes, bytesread, length - bytesread)) > 0) {
                    bytesread += readcount;
                }
            } else {
                length = 8192;
                classbytes = new byte[length];
                while (true) {
                    if (bytesread >= length) {
                        oldbytes = classbytes;
                        classbytes = new byte[length += 8192];
                        System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
                        continue;
                    }
                    int readcount = in.read(classbytes, bytesread, length - bytesread);
                    if (readcount <= 0) break;
                    bytesread += readcount;
                }
            }
            if (classbytes.length > bytesread) {
                oldbytes = classbytes;
                classbytes = new byte[bytesread];
                System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        try {}
        catch (IOException iOException) {
            return classbytes;
        }
        in.close();
        return classbytes;
    }
}

