/*
 * SampleTest.cpp
 *
 * Test Framework ̃TvvOB
 */

// for Leak Check
#include <cppunit/cudebug.h>

#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestRunner.h>
#include <string.h>

USING_NAMESPACE_CPPUNIT

/**
 * runTest() ㏑B
 */
class SampleTest1 : public TestCase
{
  public:
	/// ܂̃RXgN^B
	explicit SampleTest1(const char* name) : TestCase(name) {}

	/// eXg{̂sB
	virtual void runTest() {
		// ɃeXgB
		short num = 12;
		TEST_ASSERT_EQUALS(12, num);
		const char* str = "abc";
		TEST_ASSERT_EQUALS("ABC", str);
	}
};

/**
 * TEST_CASE }NgpB
 * seXg𑮐ƂĎĂB
 *
 * @see TEST_CASE() (in TestCase.h)
 */
class SampleTest2 : public TestCase
{
	// RXgN^ArunTest() ̒`B
	TEST_CASE_COMMON(SampleTest2)

  public:
	/// eXgB
	virtual void setUp() {
		m_num = new int(12);
		strcpy(m_str, "abc");
	}

	/// eXǧЕtB
	virtual void tearDown() {
		delete m_num;
	}

	/// l̔reXgB
	void testNumberEquals() {
		TEST_ASSERT_EQUALS(13, *m_num);
	}

	/// ̔reXgB
	void testStringEquals() {
		TEST_ASSERT_EQUALS("abc", m_str);
	}

	/// SẴeXg̏WԂB`Ăƕ֗B
	static Test* suite() {
		TestSuite* suite = new TestSuite("SampleTest2");
		// TEST_CASE }NgpăeXgIuWFNg𐶐B
		suite->addTest(new TEST_CASE(SampleTest2, testNumberEquals));
		suite->addTest(new TEST_CASE(SampleTest2, testStringEquals));
		return suite;
	}

  private:
	int* m_num;
	char m_str[80];
};

/**
 * TestCaller gpB
 *
 * @see TestCaller
 */
class SampleTest3 : public TestCase
{
  public:
	/// ܂̃RXgN^B
	explicit SampleTest3(const char* name) : TestCase(name) {}

	/// eXgB
	virtual void setUp() {
		m_num = new int(12);
		strcpy(m_str, "abc");
	}

	/// eXǧЕtB
	virtual void tearDown() {
		delete m_num;
	}

	/// l̔reXgB
	void testNumberEquals() {
		TEST_ASSERT_EQUALS(13, *m_num);
	}

	/// ̔reXgB
	void testStringEquals() {
		TEST_ASSERT_EQUALS("abc", m_str);
	}

	/// ̃eXgB
	void testNotImplemented() {
		TEST_ERROR("not implemented yet");
	}

	/// SẴeXg̏WԂB`Ăƕ֗B
	static Test* suite();

  private:
	int* m_num;
	char m_str[80];
};

// template gpłȂł͂ǉB
DECLARE_TEST_CALLER(SampleTest3)

/**
 * SẴeXg̏WԂB
 */
Test* SampleTest3::suite()
{
	TestSuite* suite = new TestSuite("SampleTest3");
	// TestCaller ̋Lq̓}NgpƊȒPɂȂB
	suite->addTest(new TEST_CALLER(SampleTest3, testNumberEquals));
	suite->addTest(new TEST_CALLER(SampleTest3, testStringEquals));
	suite->addTest(new TEST_CALLER(SampleTest3, testNotImplemented));
	return suite;
}

/**
 * TṽC֐B
 */
int main(int argc, char* argv[])
{
#if defined(ENABLE_LEAK_CHECKER) && !defined(_MSC_VER)
	LeakChecker checker;
#endif

	// TestRunner ɃeXgǉĎsB
	TestRunner runner;
	runner.addTest("SampleTest1", new SampleTest1("SampleTest1"));
	runner.addTest("SampleTest2", SampleTest2::suite());
	runner.addTest("SampleTest3", SampleTest3::suite());
	return runner.run(argc, argv);
}

// ȉ̋Lq̓fobOpȂ̂ŖĂB
#ifdef USE_DEBUGTOOLS
#  include <debug/debugtools.cpp>
#endif

#if defined(ENABLE_LEAK_CHECKER) && defined(_MSC_VER)
#  pragma warning(disable:4073)
#  pragma init_seg(lib)
LeakChecker g_leakChecker;
#endif
