/*
 * DebugUtility.cpp
 *
 * Copyright (C) 2001-2002 by Ito Yoshiichi.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "dgconfig.h"
#include "DebugUtility.h"
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

extern "C" {

void dg_assert(const char* file, int line, const char* message)
{
	fprintf(stderr, "\n%s(%d): assertion failed: %s\n",
			DebugUtility::trimFileName(file), line, message);
	abort();
}

void dg_trace(const char* file, int line, const char* format, ...)
{
	va_list ap;
	va_start(ap, format);
	fprintf(stderr, "%s(%d): ", DebugUtility::trimFileName(file), line);
	vfprintf(stderr, format, ap);
	va_end(ap);
}

} /* extern "C" */

dg_NAMESPACE_BEGIN(debug)

const char* DebugUtility::trimFileName(const char* fileName)
{
	for (const char* p = fileName; *p != 0; ++p) {
		if (*p == '/' || *p == '\\' || *p == ':') {
			fileName = p + 1;
		}
	}
	return fileName;
}

dg_NAMESPACE_END
