/*
 * DebugUtility.h
 *
 * Copyright (C) 2001-2002 by Ito Yoshiichi.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef debug_DebugUtility_h
#define debug_DebugUtility_h

#include "dgconfig.h"

#ifdef DEBUG
#  define ENABLE_TRACE
#  define dg_IFDEBUG(e) (e)
#else
#  define dg_IFDEBUG(e) ((void)0)
#endif
#ifndef NDEBUG
#  define ENABLE_ASSERT
#endif

#ifdef ENABLE_ASSERT
#  define ASSERT(e)      ((e) ? (void)0 : dg_assert(__FILE__, __LINE__, #e))
#  define VERIFY(e)      ASSERT(e)
#  define EXEC_ASSERT(e) ASSERT(e)		/**< @deprecated */
#else
#  define ASSERT(e)      ((void)0)
#  define VERIFY(e)      ((void)(e))
#  define EXEC_ASSERT(e) ((void)(e))	/**< @deprecated */
#endif

#ifdef ENABLE_TRACE
#  define dg_IFTRACE(e) (e)
#else
#  define dg_IFTRACE(e) ((void)0)
#endif

#define TRACE(s) \
	dg_IFTRACE(dg_trace(__FILE__, __LINE__, "%s", s))
#define TRACE1(f, p1) \
	dg_IFTRACE(dg_trace(__FILE__, __LINE__, f, p1))
#define TRACE2(f, p1, p2) \
	dg_IFTRACE(dg_trace(__FILE__, __LINE__, f, p1, p2))
#define TRACE3(f, p1, p2, p3) \
	dg_IFTRACE(dg_trace(__FILE__, __LINE__, f, p1, p2, p3))
#define TRACE4(f, p1, p2, p3, p4) \
	dg_IFTRACE(dg_trace(__FILE__, __LINE__, f, p1, p2, p3, p4))
#define TRACE5(f, p1, p2, p3, p4, p5) \
	dg_IFTRACE(dg_trace(__FILE__, __LINE__, f, p1, p2, p3, p4, p5))
#define TRACE6(f, p1, p2, p3, p4, p5, p6) \
	dg_IFTRACE(dg_trace(__FILE__, __LINE__, f, p1, p2, p3, p4, p5, p6))
#define TRACE7(f, p1, p2, p3, p4, p5, p6, p7) \
	dg_IFTRACE(dg_trace(__FILE__, __LINE__, f, p1, p2, p3, p4, p5, p6, p7))
#define TRACE8(f, p1, p2, p3, p4, p5, p6, p7, p8) \
	dg_IFTRACE(dg_trace(__FILE__, __LINE__, f, p1, p2, p3, p4, p5, p6, p7, p8))

#ifdef __cplusplus
extern "C" {
#endif

void dg_assert(const char* file, int line, const char* message);
void dg_trace(const char* file, int line, const char* format, ...);

#ifdef __cplusplus
} /* extern "C" */
#endif

#ifdef __cplusplus

dg_NAMESPACE_BEGIN(debug)

/**
 * [eBeBB
 */
class DebugUtility
{
  public:
	/** t@CfBNg菜B */
	static const char* trimFileName(const char* fileName);
};

dg_NAMESPACE_END

#endif /* __cplusplus */

#endif /* !debug_DebugUtility_h */
