/*
 * dgconfig.h
 *
 * Copyright (C) 2001-2002 by Ito Yoshiichi.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef debug_dgconfig_h
#define debug_dgconfig_h

/*
 * JƂ̐ݒB
 *
 * << Compilers >>
 * _MSC_VER     : Microsoft Visual C++
 * __BORLANDC__ : Borland C++
 * __GNUC__     : GNU C/C++
 *
 * << Platforms >>
 * _WIN32       : Win32
 * __unix__     : Unix
 * __linux__    : Linux
 * __CYGWIN__   : Cygwin
 * __MINGW32__  : Mingw32
 * VxWorks      : VxWorks
 *
 * dg_ Ŏn܂}N͓IɎgp̂Ȃ̂ŁA
 * [U̎gp͏サȂB
 */
#include <stddef.h>
#if defined(__INCvxANSIh) && !defined(VxWorks)
#  define VxWorks
#endif

#if 0
  /* RXgN^ŗOƂA
     new ƈΉ delete Ă΂ȂB */
#  define dg_NO_OPERATOR_DELETE_OVERLOADING
  /* deallocate()  void* vB */
#  define dg_DEALLOCATE_NEEDS_VOID_PTR
#endif

#ifdef MINIMUM_SET
#  define dg_NO_MEMBER_TEMPLATE_CLASSES
#  define dg_NO_NAMESPACES
#  define dg_NO_NAMESPACE_STD
#  define dg_NO_EXCEPTIONS
#endif

#ifdef _MSC_VER
  /* ufobOŎʎq 255 ɐ؂̂Ă܂v OFFB */
#  pragma warning(disable:4786)
#  define dg_DEALLOCATE_NEEDS_VOID_PTR
#endif

#ifdef __BORLANDC__
  /* u`̓CCWJłȂv OFFB */
#  pragma warn -inl
#  define dg_NO_OPERATOR_DELETE_OVERLOADING
#endif

#ifdef __GNUC__
  /* ȉ2_AVer.3 ŖmFB */
#  define dg_DEALLOCATE_NEEDS_VOID_PTR
#  define dg_ALLOCATOR_STATIC static
#  if __GNUC__ < 3
#    define char_traits string_char_traits
#  endif
#endif

#ifdef _WIN32
#  define dg_USE_WIN32_THREADS
#endif

#ifdef __unix__
#  define dg_USE_POSIX_THREADS
#endif

#ifdef VxWorks
#  define dg_NO_MEMBER_TEMPLATE_CLASSES
#  define dg_NO_NAMESPACES
#  define dg_NO_NAMESPACE_STD
#  define dg_NO_OPERATOR_DELETE_OVERLOADING
#  define dg_USE_VXW_THREADS
#endif

#ifdef NO_THREADS
#  undef  dg_USE_WIN32_THREADS
#  undef  dg_USE_POSIX_THREADS
#  undef  dg_USE_VXW_THREADS
#endif

/*
 * C++ T|[g֘A̒`B
 */
#ifndef dg_NO_NAMESPACES
#  define dg_NAMESPACE_BEGIN(ns) namespace ns {
#  define dg_NAMESPACE_END       }
#  define dg_USING_NAMESPACE(ns) using namespace ns;
#  define dg_USING(name)         using name;
#  define dg_NAMESPACE(ns)       ns
#else
#  define dg_NAMESPACE_BEGIN(ns)
#  define dg_NAMESPACE_END
#  define dg_USING_NAMESPACE(ns)
#  define dg_USING(name)
#  define dg_NAMESPACE(ns)
#endif

#ifndef dg_NO_NAMESPACE_STD
#  define dg_NAMESPACE_STD_BEGIN namespace std {
#  define dg_NAMESPACE_STD_END   }
#  define dg_USING_NAMESPACE_STD using namespace std;
#  define dg_USING_STD(name)     using std::name;
#  define dg_STD                 std
#else
#  define dg_NAMESPACE_STD_BEGIN
#  define dg_NAMESPACE_STD_END
#  define dg_USING_NAMESPACE_STD
#  define dg_USING_STD(name)
#  define dg_STD
#endif

#ifndef dg_NO_EXCEPTIONS
#  define dg_TRY       try
#  define dg_CATCH_ALL catch (...)
#  define dg_THROW(e)  throw (e)
#  define dg_RETHROW   throw
#  define dg_NOTHROW   throw()
#else
#  define dg_TRY
#  define dg_CATCH_ALL if (false)
#  define dg_THROW(e)
#  define dg_RETHROW
#  define dg_NOTHROW
#endif

/*
 * Debug ֌W̒`B
 */
#ifdef __cplusplus
dg_NAMESPACE_BEGIN(debug)
dg_NAMESPACE_END
dg_USING_NAMESPACE(debug)
#endif

#ifndef dg_ALLOCATOR_STATIC
#  define dg_ALLOCATOR_STATIC
#endif

#endif /* !debug_dgconfig_h */
