/*
 * ContainersTest.h
 */

#ifndef samples_ContainersTest_h
#define samples_ContainersTest_h

#include <debug/dgconfig.h>
#include <utility>
#include <iostream>

dg_USING_NAMESPACE_STD

/**
 * STL ReĩeXgB
 */
template <class Traits>
class ContainersTest
{
  public:
	static void testSeq();
	static void testSet();
	static void testMap();

  protected:
	typedef typename Traits::String String;
	static pair<const String, int> make_pair(const char* p, int n)
		{ return dg_STD::make_pair(String(p), n); }
};

/**
 * vectorAlistAdeque eXgB
 */
template <class Traits>
void ContainersTest<Traits>::testSeq()
{
	typename Traits::Vector v;
	typename Traits::List   l;
	typename Traits::Deque  d;

	// eReiB
	for (int i = 0; i < 10; ++i) {
		v.push_back(i);
		l.push_back(i);
		d.push_back(i);
	}

	// vector ̊evf\B
	cout << "vector:" << endl;
	for (typename Traits::Vector::const_iterator
			vi = v.begin(); vi != v.end(); ++vi) {
		cout << ' ' << *vi;
	}
	cout << endl;

	// list ̊evf\B
	cout << "list:" << endl;
	for (typename Traits::List::const_iterator
			li = l.begin(); li != l.end(); ++li) {
		cout << ' ' << *li;
	}
	cout << endl;

	// deque ̊evf\B
	cout << "deque:" << endl;
	for (typename Traits::Deque::const_iterator
			di = d.begin(); di != d.end(); ++di) {
		cout << ' ' << *di;
	}
	cout << endl;
}

/**
 * setAmultiset eXgB
 */
template <class Traits>
void ContainersTest<Traits>::testSet()
{
	typename Traits::Set      s;
	typename Traits::Multiset ms;

	// eReiB
	s.insert(1); ms.insert(1);
	s.insert(1); ms.insert(1);
	s.insert(2); ms.insert(2);
	s.insert(3); ms.insert(3);
	s.insert(5); ms.insert(5);

	// set ̊evf\B
	cout << "set:" << endl;
	for (typename Traits::Set::const_iterator
			si = s.begin(); si != s.end(); ++si) {
		cout << ' ' << *si;
	}
	cout << endl;

	// multiset ̊evf\B
	cout << "multiset:" << endl;
	for (typename Traits::Multiset::const_iterator
			msi = ms.begin(); msi != ms.end(); ++msi) {
		cout << ' ' << *msi;
	}
	cout << endl;
}

/**
 * mapAmultimap eXgB
 */
template <class Traits>
void ContainersTest<Traits>::testMap()
{
	typename Traits::Map      m;
	typename Traits::Multimap mm;

	// eReiB
	m.insert(make_pair("1", 1)); mm.insert(make_pair("1", 1));
	m.insert(make_pair("1", 1)); mm.insert(make_pair("1", 1));
	m.insert(make_pair("2", 2)); mm.insert(make_pair("2", 2));
	m.insert(make_pair("3", 3)); mm.insert(make_pair("3", 3));
	m.insert(make_pair("5", 5)); mm.insert(make_pair("5", 5));

	// map ̊evf\B
	cout << "map:" << endl;
	for (typename Traits::Map::const_iterator
			mi = m.begin(); mi != m.end(); ++mi) {
		cout << ' ' << mi->first << ':' << mi->second;
	}
	cout << endl;

	// multimap ̊evf\B
	cout << "multimap:" << endl;
	for (typename Traits::Multimap::const_iterator
			mmi = mm.begin(); mmi != mm.end(); ++mmi) {
		cout << ' ' << mmi->first << ':' << mmi->second;
	}
	cout << endl;
}

#endif /* !samples_ContainersTest_h */
