/*
 * DebugUtilityTest.cpp
 */

#ifndef NDEBUG
#  define DEBUG
#endif

#include <debug/DebugUtility.h>
#include <debug/DebugUtility.cpp>
#include <stdarg.h>

extern "C" {
int isFail(const char* s);
// C  ASSERTATRACE eXgB
void testDebugUtility(int argc, char* argv[]);
}

void main2(int argc, ...)
{
	TRACE1("main2(%d, ...)\n", argc);
	// ψ argcAargv ɒuB
	va_list ap;
	va_start(ap, argc);
	char** argv = new char*[argc + 1];
	int index = 0;
	while (index < argc) {
		argv[index++] = va_arg(ap, char*);
	}
	argv[index] = 0;
	// C ł ASSERTATRACE ̃eXgB
	testDebugUtility(argc, argv);
	delete[] argv;
	va_end(ap);
}

int main(int argc, char* argv[])
{
	// C++ ł TRACE ̃eXgB
	TRACE("%%% DebugUtilityTest %%%\n");
	TRACE1("main(%d, *)\n", argc);
	if (argc > 0) {
		// DebugUtility::trimFileName() ̃eXgB
		TRACE1("program = %s\n", DebugUtility::trimFileName(argv[0]));
	}
	// C ł ASSERTATRACE ̃eXgB
	switch (argc) {
	  case 0:  main2(argc); break;
	  case 1:  main2(argc, argv[0]); break;
	  case 2:  main2(argc, argv[0], argv[1]); break;
	  default: testDebugUtility(argc, argv); break;
	}
	// C++ ł ASSERT ̃eXgB
	ASSERT(argc <= 2 || !isFail(argv[2]));
	VERIFY(argc <= 3 || !isFail(argv[3]));
	return 0;
}
