/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.trix.cuery.css.AbstractCSSConsumer;
import org.trix.cuery.parser.CueryParser;
import org.trix.cuery.property.PropertyDefinition;
import org.trix.cuery.property.PropertyRegistry;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.util.I18nUtil;
import org.trix.cuery.value.CSSValue;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;

public class CSSValidator {
    private static final CueryParser PARSER = new CueryParser();
    private Option option = new Option();

    public void allowUnderscoreHack(boolean permission) {
        this.option.underscoreHack = permission;
    }

    public CSSParseException[] validate(InputSource source) throws IOException {
        ValidatableConsumer consumer = new ValidatableConsumer(this.option);
        PARSER.setDocumentHandler(consumer);
        PARSER.parseStyleSheet(source);
        return consumer.container.toArray(new CSSParseException[consumer.container.size()]);
    }

    private static class ValidatableConsumer
    extends AbstractCSSConsumer {
        private List container = new ArrayList();
        private Option option;

        public ValidatableConsumer(Option option) {
            this.option = option;
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            PropertyDefinition definition;
            if (this.option.underscoreHack && name.charAt(0) == '_') {
                name = name.substring(1);
            }
            if ((definition = PropertyRegistry.getDefinition(name)) == null) {
                this.addError(I18nUtil.getText("validator.propertyNotDefined", name));
                return;
            }
            CSSValue cssValue = CSSUtil.convert(value);
            Map result = definition.parse(cssValue);
            if (result == null) {
                this.addError(I18nUtil.getText("validator.invalidValue", name, CSSUtil.toString(cssValue)));
                return;
            }
        }

        public void error(CSSParseException exception) throws CSSException {
            this.addError(exception);
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            this.addError(exception);
        }

        public void warning(CSSParseException exception) throws CSSException {
            this.addError(exception);
        }

        private void addError(String message) {
            CSSParseException exception = new CSSParseException(message, PARSER.getLocator());
            this.container.add(exception);
        }

        private void addError(CSSParseException ex) {
            String message = ex.getException() == null ? ex.getLocalizedMessage() : ex.getException().getMessage();
            this.container.add(new CSSParseException(message, ex.getURI(), ex.getLineNumber(), ex.getColumnNumber()));
        }
    }

    private static class Option {
        private boolean underscoreHack = false;

        Option() {
        }
    }
}

