/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.property;

import java.util.LinkedList;
import org.trix.cuery.property.AbstractProperty;
import org.trix.cuery.property.Property;
import org.trix.cuery.property.PropertyDefinition;
import org.trix.cuery.property.PropertyRegistry;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.value.CSSValue;
import org.w3c.dom.Element;

public class CascadableProperty
extends AbstractProperty {
    public static final int ORIGIN_AGENT = 1;
    public static final int ORIGIN_USER = 2;
    public static final int ORIGIN_AUTHOR = 3;
    private LinkedList properties = new LinkedList();
    private int author = 0;
    private int user = 0;
    private Element parent;

    public CascadableProperty() {
    }

    public CascadableProperty(Element parent) {
        this.parent = parent;
    }

    public CSSValue getValue(String name, int state) {
        PropertyDefinition definition = PropertyRegistry.getDefinition(name);
        CSSValue value = this.getSpecifiedValue(definition, state);
        Property parent = CSSUtil.getProperty(this.parent);
        if (parent == null) {
            return definition.getComputedValue(value, this, RootProperty.SINGLETON);
        }
        return definition.getComputedValue(value, this, parent);
    }

    private CSSValue getSpecifiedValue(PropertyDefinition definition, int state) {
        String name = definition.getName();
        CSSValue result = this.search(name, state, this.author, this.user, true);
        if (result != null) {
            return result;
        }
        result = this.search(name, state, 0, this.author, true);
        if (result != null) {
            return result;
        }
        result = this.search(name, state, 0, this.author, false);
        if (result != null) {
            return result;
        }
        result = this.search(name, state, this.author, this.user, false);
        if (result != null) {
            return result;
        }
        result = this.search(name, state, this.user, this.properties.size(), false);
        if (result != null) {
            return result;
        }
        if (this.parent != null && definition.isInheritable()) {
            return CSSUtil.getProperty(this.parent).getValue(name);
        }
        return definition.getInitialValue();
    }

    private CSSValue search(String name, int state, int start, int end, boolean importance) {
        int i = start;
        while (i < end) {
            CSSValue value;
            PropertyWeightSet set = (PropertyWeightSet)this.properties.get(i);
            Property property = set.property;
            if ((!importance || property.isImportant(name)) && (value = property.getValue(name)) != null && (state == 0 ? set.state == 0 : (state & set.state) == set.state || set.state == 0)) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public boolean isImportant(String name) {
        return false;
    }

    public void addProperty(Property property, int origin, int specificity, int position) {
        this.addProperty(property, origin, specificity, position, 0);
    }

    public void addProperty(Property property, int origin, int specificity, int position, int state) {
        switch (origin) {
            case 3: {
                this.addProperty(property, specificity, position, state, 0, this.author);
                ++this.author;
                ++this.user;
                break;
            }
            case 2: {
                this.addProperty(property, specificity, position, state, this.author, this.user);
                ++this.user;
                break;
            }
            case 1: {
                this.addProperty(property, specificity, position, state, this.user, this.properties.size());
                break;
            }
        }
    }

    private void addProperty(Property property, int specificity, int position, int state, int start, int end) {
        PropertyWeightSet set = new PropertyWeightSet();
        set.position = position;
        set.property = property;
        set.specificity = specificity;
        set.state = state;
        int i = start;
        while (i < end) {
            PropertyWeightSet target = (PropertyWeightSet)this.properties.get(i);
            if (specificity > target.specificity) {
                this.properties.add(i, set);
                return;
            }
            if (specificity == target.specificity && position > target.position) {
                this.properties.add(i, set);
                return;
            }
            ++i;
        }
        this.properties.add(end, set);
    }

    private class PropertyWeightSet {
        private Property property;
        private int position;
        private int specificity;
        private int state;

        PropertyWeightSet() {
        }
    }

    private static class RootProperty
    extends AbstractProperty {
        private static final RootProperty SINGLETON = new RootProperty();

        RootProperty() {
        }

        public CSSValue getValue(String name, int state) {
            PropertyDefinition definition = PropertyRegistry.getDefinition(name);
            return definition.getComputedValue(definition.getInitialValue(), this, this);
        }

        public boolean isImportant(String name) {
            return false;
        }
    }
}

