/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import org.trix.cuery.util.DOMUtil;

import org.w3c.css.sac.CSSException;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: FirstNumeralFilter.java,v 1.0 2005/07/27 16:03:12 Teletha Exp $
 */
public class FirstNumeralFilter extends AbstractNumeralFilter {

    /**
     * Create FirstNumeralFilter instance.
     * 
     * @param argument An argument.
     * @throws CSSException If the argument is invalid pattern.
     */
    public FirstNumeralFilter(String argument) throws CSSException {
        super(argument);
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return ":nth-child(" + argument + ")";
    }

    /**
     * @see org.trix.cuery.filter.AbstractNumeralFilter#getPosition(org.w3c.dom.Element)
     */
    protected int getPosition(Element target) {
        return DOMUtil.getPosition(target);
    }

}
