/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import org.trix.cuery.property.Property;

import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: PseudoFilter.java,v 1.01 2005/09/11 7:44:02 Teletha Exp $
 */
public class PseudoFilter extends AbstractPseudoFilter {

    /** The state pool. */
    private static final Map STATES = new HashMap();

    // initialize
    static {
        Field[] fields = Property.class.getDeclaredFields();

        for (int i = 0; i < fields.length; i++) {
            try {
                STATES.put(fields[i].getName().toLowerCase(), fields[i].get(null));
            } catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    /** The pseudo name. */
    protected String name;

    /**
     * Create PseudoFilter instance.
     * 
     * @param name A pseudo name.
     */
    public PseudoFilter(String name) {
        this.name = name;
    }

    /**
     * @see org.trix.cuery.filter.AbstractPseudoFilter#getState()
     */
    public int getState() {
        Integer integer = (Integer) STATES.get(name);

        if (integer == null) {
            return 0;
        }
        return integer.intValue();
    }

    /**
     * @see org.trix.cuery.filter.AbstractPseudoFilter#getPseudoName()
     */
    protected String getPseudoName() {
        return name;
    }

    /**
     * @see org.trix.cuery.filter.Filter#accept(org.w3c.dom.Element)
     */
    public boolean accept(Element target) {
        return true;
    }

}
