/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValueList;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSValue.java,v 1.1 2005/08/02 10:07:17 Teletha Exp $
 */
public interface CSSValue extends LexicalUnit, CSSPrimitiveValue, CSSValueList {

    /** The inherit keyword. */
    String INHERIT = "inherit";

    /** The initial keyword. */
    String INITIAL = "initial";

    /**
     * Return a css value by index.
     * 
     * @param index A index.
     * @return A css value.
     */
    CSSValue get(int index);

    /**
     * Return class type.
     * 
     * @return A class type.
     */
    Class getType();

    /**
     * Return next css value.
     * 
     * @return A next css value.
     */
    CSSValue getNextValue();

    /**
     * Return a previous css value.
     * 
     * @return A previous css value.
     */
    CSSValue getPreviousValue();

}
