/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property.css2;

import junit.framework.TestCase;

import org.trix.cuery.property.SimpleProperty;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.value.CSSColor;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.Identifier;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: BorderColorDefinitionTest.java,v 1.0 2005/08/30 19:52:40 Teletha Exp $
 */
public class BorderColorDefinitionTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderColorDefinition.parseValue(CSSValue)'
     */
    public void testParseValue1() {
        CSSValue value = new Identifier("inherit", null);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-color", value, false);

        assertEquals("inherit", property.getValueAsString("border-top-color"));
        assertEquals("inherit", property.getValueAsString("border-bottom-color"));
        assertEquals("inherit", property.getValueAsString("border-right-color"));
        assertEquals("inherit", property.getValueAsString("border-left-color"));

        assertEquals("inherit", CSSUtil.toString(property.getValue("border-color")));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderColorDefinition.parseValue(CSSValue)'
     */
    public void testParseValue2() {
        CSSValue value = new Identifier("transparent", null);
        new CSSColor(0, 0, 0, value);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-color", value, false);

        assertEquals("transparent", property.getValueAsString("border-top-color"));
        assertEquals("transparent", property.getValueAsString("border-bottom-color"));
        assertEquals("#000000", property.getValueAsString("border-right-color"));
        assertEquals("#000000", property.getValueAsString("border-left-color"));

        assertEquals("transparent rgb(0, 0, 0)", CSSUtil.toString(property.getValue("border-color")));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderColorDefinition.parseValue(CSSValue)'
     */
    public void testParseValue3() {
        CSSValue value = new Identifier("transparent", null);
        CSSValue value2 = new CSSColor(1, 1, 1, value);
        new CSSColor(0, 0, 0, value2);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-color", value, false);

        assertEquals("transparent", property.getValueAsString("border-top-color"));
        assertEquals("#000000", property.getValueAsString("border-bottom-color"));
        assertEquals("#010101", property.getValueAsString("border-right-color"));
        assertEquals("#010101", property.getValueAsString("border-left-color"));

        assertEquals("transparent rgb(1, 1, 1) rgb(0, 0, 0)", CSSUtil.toString(property.getValue("border-color")));
    }
    
    /*
     * Test method for 'org.trix.cuery.property.css2.BorderColorDefinition.parseValue(CSSValue)'
     */
    public void testParseValue4() {
        CSSValue value = new Identifier("transparent", null);
        CSSValue value2 = new CSSColor(1, 1, 1, value);
        CSSValue value3 = new CSSColor(2, 2, 2, value2);
        new CSSColor(0, 0, 0, value3);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-color", value, false);

        assertEquals("transparent", property.getValueAsString("border-top-color"));
        assertEquals("#020202", property.getValueAsString("border-bottom-color"));
        assertEquals("#010101", property.getValueAsString("border-right-color"));
        assertEquals("#000000", property.getValueAsString("border-left-color"));

        assertEquals("transparent rgb(1, 1, 1) rgb(2, 2, 2) rgb(0, 0, 0)", CSSUtil.toString(property.getValue("border-color")));
    }
}
