/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.trix.cuery.property.Property;
import org.trix.cuery.value.CSSPercentage;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.CentimeterLength;
import org.trix.cuery.value.DegreeAngle;
import org.trix.cuery.value.EMLength;
import org.trix.cuery.value.EXLength;
import org.trix.cuery.value.GradianAngle;
import org.trix.cuery.value.HertzFrequency;
import org.trix.cuery.value.Identifier;
import org.trix.cuery.value.InchLength;
import org.trix.cuery.value.KiloHertzFrequency;
import org.trix.cuery.value.MillimeterLength;
import org.trix.cuery.value.MillisecondTime;
import org.trix.cuery.value.PicaLength;
import org.trix.cuery.value.PixelLength;
import org.trix.cuery.value.PointLength;
import org.trix.cuery.value.RadianAngle;
import org.trix.cuery.value.SecondTime;

public abstract class PropertyDefinition {
    protected String name;
    protected boolean inherited;
    protected CSSValue initialValue;
    protected List acceptables = new ArrayList();
    static /* synthetic */ Class class$0;

    public final String getName() {
        return this.name;
    }

    public final CSSValue getInitialValue() {
        return this.initialValue;
    }

    public final boolean isInheritable() {
        return this.inherited;
    }

    public Map parse(CSSValue value) {
        if (value == null) {
            return null;
        }
        int i = 0;
        while (i < this.acceptables.size()) {
            Object acceptable = this.acceptables.get(i);
            if (acceptable instanceof String) {
                String identifier = (String)acceptable;
                if (identifier.equals(value.getStringValue())) {
                    return Collections.EMPTY_MAP;
                }
            } else if (acceptable instanceof Class) {
                Class clazz = (Class)acceptable;
                if (clazz.isAssignableFrom(value.getType())) {
                    return Collections.EMPTY_MAP;
                }
                String string = clazz.getName();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.trix.cuery.value.CSSLength");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (string.equals(clazz2.getName()) && value.getLexicalUnitType() == 13 && value.getIntegerValue() == 0) {
                    return Collections.EMPTY_MAP;
                }
            }
            ++i;
        }
        return null;
    }

    public CSSValue getComputedValue(CSSValue value, Property property, Property parent) {
        switch (value.getLexicalUnitType()) {
            case 19: {
                return this.computeCentimeterLength((CentimeterLength)value, property, parent);
            }
            case 28: {
                return this.computeDegreeAngle((DegreeAngle)value, property, parent);
            }
            case 15: {
                return this.computeEMLength((EMLength)value, property, parent);
            }
            case 16: {
                return this.computeEXLength((EXLength)value, property, parent);
            }
            case 29: {
                return this.computeGradianAngle((GradianAngle)value, property, parent);
            }
            case 33: {
                return this.computeHertzFrequency((HertzFrequency)value, property, parent);
            }
            case 35: {
                return this.computeIdentifier((Identifier)value, property, parent);
            }
            case 18: {
                return this.computeInchLength((InchLength)value, property, parent);
            }
            case 34: {
                return this.computeKiloHertzFrequency((KiloHertzFrequency)value, property, parent);
            }
            case 20: {
                return this.computeMillimeterLength((MillimeterLength)value, property, parent);
            }
            case 31: {
                return this.computeMillisecondTime((MillisecondTime)value, property, parent);
            }
            case 23: {
                return this.computePercentage((CSSPercentage)value, property, parent);
            }
            case 22: {
                return this.computePicaLength((PicaLength)value, property, parent);
            }
            case 17: {
                return this.computePixelLength((PixelLength)value, property, parent);
            }
            case 21: {
                return this.computePointLength((PointLength)value, property, parent);
            }
            case 30: {
                return this.computeRadianAngle((RadianAngle)value, property, parent);
            }
            case 32: {
                return this.computeSecondTime((SecondTime)value, property, parent);
            }
        }
        return value;
    }

    protected void setup(String name, boolean inherited, CSSValue initialValue) {
        this.name = name;
        this.inherited = inherited;
        this.initialValue = initialValue;
    }

    protected void addAcceptable(Object acceptable) {
        if (acceptable == null || this.acceptables.contains(acceptable)) {
            return;
        }
        this.acceptables.add(acceptable);
    }

    protected CSSValue computeCentimeterLength(CentimeterLength length, Property property, Property parent) {
        return length;
    }

    protected CSSValue computeDegreeAngle(DegreeAngle angle, Property property, Property parent) {
        return angle;
    }

    protected CSSValue computeEMLength(EMLength length, Property property, Property parent) {
        return length;
    }

    protected CSSValue computeEXLength(EXLength length, Property property, Property parent) {
        return length;
    }

    protected CSSValue computeGradianAngle(GradianAngle angle, Property property, Property parent) {
        return angle;
    }

    protected CSSValue computeHertzFrequency(HertzFrequency frequency, Property property, Property parent) {
        return frequency;
    }

    protected CSSValue computeIdentifier(Identifier identifier, Property property, Property parent) {
        return identifier;
    }

    protected CSSValue computeInchLength(InchLength length, Property property, Property parent) {
        return length;
    }

    protected CSSValue computeKiloHertzFrequency(KiloHertzFrequency frequency, Property property, Property parent) {
        return frequency;
    }

    protected CSSValue computeMillimeterLength(MillimeterLength length, Property property, Property parent) {
        return length;
    }

    protected CSSValue computeMillisecondTime(MillisecondTime time, Property property, Property parent) {
        return time;
    }

    protected CSSValue computePercentage(CSSPercentage percentage, Property property, Property parent) {
        return percentage;
    }

    protected CSSValue computePicaLength(PicaLength length, Property property, Property parent) {
        return length;
    }

    protected CSSValue computePixelLength(PixelLength length, Property property, Property parent) {
        return length;
    }

    protected CSSValue computePointLength(PointLength length, Property property, Property parent) {
        return length;
    }

    protected CSSValue computeRadianAngle(RadianAngle angle, Property property, Property parent) {
        return angle;
    }

    protected CSSValue computeSecondTime(SecondTime time, Property property, Property parent) {
        return time;
    }

    public String toString() {
        return String.valueOf(this.name) + " [inheritable='" + Boolean.toString(this.inherited) + "', initial='" + this.initialValue + "']";
    }
}

