/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.property;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.trix.cuery.property.PropertyDefinition;
import org.trix.cuery.property.SimplePropertyDefinition;
import org.trix.cuery.property.config.DefaultFontConfiguration;
import org.trix.cuery.property.config.FontConfiguration;
import org.trix.cuery.value.AbstractCSSValue;
import org.trix.cuery.value.CSSPercentage;
import org.trix.cuery.value.Identifier;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PropertyRegistry {
    private static FontConfiguration fontConfiguration = new DefaultFontConfiguration();
    private static final String PATH = "org/trix/cuery/property/css2/definition.xml";
    private static final Map DEFINITIONS = new HashMap();
    private static SAXParser parser;

    static {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            parser = factory.newSAXParser();
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(PATH);
            PropertyRegistry.readPropertyDefinition(new InputSource(stream));
        }
        catch (Exception e) {
            System.out.println("PropertyRegistery initialization phase   " + e);
        }
    }

    private PropertyRegistry() {
    }

    public static FontConfiguration getFontConfiguration() {
        return fontConfiguration;
    }

    public static void setFontConfiguration(FontConfiguration fontConfiguration) {
        if (fontConfiguration == null) {
            return;
        }
        PropertyRegistry.fontConfiguration = fontConfiguration;
    }

    public static PropertyDefinition getDefinition(String name) {
        return (PropertyDefinition)DEFINITIONS.get(name);
    }

    public static void readPropertyDefinition(InputSource source) throws IOException {
        try {
            parser.parse(source, (DefaultHandler)new DefinitionReader());
        }
        catch (SAXException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    private static class DefinitionReader
    extends DefaultHandler {
        private static final Map CLASSTYPES = new HashMap();
        private PropertyDefinition current;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;
        static /* synthetic */ Class class$5;
        static /* synthetic */ Class class$6;
        static /* synthetic */ Class class$7;
        static /* synthetic */ Class class$8;
        static /* synthetic */ Class class$9;
        static /* synthetic */ Class class$10;
        static /* synthetic */ Class class$11;
        static /* synthetic */ Class class$12;
        static /* synthetic */ Class class$13;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.trix.cuery.value.CSSAngle");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("angle", clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.trix.cuery.value.AttrFunction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("attr", clazz2);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.trix.cuery.value.CSSColor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("color", clazz3);
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("org.trix.cuery.value.CounterFunction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("counter", clazz4);
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = class$4 = Class.forName("org.trix.cuery.value.CountersFunction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("counters", clazz5);
            Class<?> clazz6 = class$5;
            if (clazz6 == null) {
                try {
                    clazz6 = class$5 = Class.forName("org.trix.cuery.value.CSSFrequency");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("frequency", clazz6);
            Class<?> clazz7 = class$6;
            if (clazz7 == null) {
                try {
                    clazz7 = class$6 = Class.forName("org.trix.cuery.value.Identifier");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("ident", clazz7);
            Class<?> clazz8 = class$7;
            if (clazz8 == null) {
                try {
                    clazz8 = class$7 = Class.forName("org.trix.cuery.value.CSSNumber");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("integer", clazz8);
            Class<?> clazz9 = class$8;
            if (clazz9 == null) {
                try {
                    clazz9 = class$8 = Class.forName("org.trix.cuery.value.CSSLength");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("length", clazz9);
            Class<?> clazz10 = class$7;
            if (clazz10 == null) {
                try {
                    clazz10 = class$7 = Class.forName("org.trix.cuery.value.CSSNumber");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("number", clazz10);
            Class<?> clazz11 = class$9;
            if (clazz11 == null) {
                try {
                    clazz11 = class$9 = Class.forName("org.trix.cuery.value.CSSPercentage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("percentage", clazz11);
            Class<?> clazz12 = class$10;
            if (clazz12 == null) {
                try {
                    clazz12 = class$10 = Class.forName("org.trix.cuery.value.RectFunction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("rect", clazz12);
            Class<?> clazz13 = class$11;
            if (clazz13 == null) {
                try {
                    clazz13 = class$11 = Class.forName("org.trix.cuery.value.CSSString");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("string", clazz13);
            Class<?> clazz14 = class$12;
            if (clazz14 == null) {
                try {
                    clazz14 = class$12 = Class.forName("org.trix.cuery.value.CSSTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("time", clazz14);
            Class<?> clazz15 = class$13;
            if (clazz15 == null) {
                try {
                    clazz15 = class$13 = Class.forName("org.trix.cuery.value.CSSURI");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CLASSTYPES.put("uri", clazz15);
        }

        DefinitionReader() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
            PropertyDefinition definition;
            if (qName.equals("property-def")) {
                PropertyDefinition definition2;
                String name = attributes.getValue("name");
                String inherited = attributes.getValue("inherited");
                String initialValue = attributes.getValue("initial");
                String className = attributes.getValue("class");
                if (className == null) {
                    definition2 = new SimplePropertyDefinition();
                } else {
                    try {
                        definition2 = (PropertyDefinition)Class.forName(className).newInstance();
                    }
                    catch (InstantiationException e) {
                        System.out.println(e);
                        return;
                    }
                    catch (IllegalAccessException e) {
                        System.out.println(e);
                        return;
                    }
                    catch (ClassNotFoundException e) {
                        System.out.println(e);
                        return;
                    }
                }
                AbstractCSSValue initial = null;
                initial = initialValue == null ? new Identifier(initialValue, null) : (initialValue.endsWith("%") ? new CSSPercentage(initialValue, null) : new Identifier(initialValue, null));
                definition2.setup(name, inherited.equals("yes"), initial);
                if (!DEFINITIONS.containsKey(name)) {
                    DEFINITIONS.put(name, definition2);
                }
                this.current = definition2;
            } else if (qName.equals("keyword")) {
                this.current.addAcceptable(attributes.getValue("name"));
            } else if (qName.equals("datatype")) {
                Class clazz = (Class)CLASSTYPES.get(attributes.getValue("name"));
                if (clazz != null) {
                    this.current.addAcceptable(clazz);
                }
            } else if (qName.equals("function")) {
                Class clazz = (Class)CLASSTYPES.get(attributes.getValue("name"));
                if (clazz != null) {
                    this.current.addAcceptable(clazz);
                }
            } else if (qName.equals("property") && (definition = (PropertyDefinition)DEFINITIONS.get(attributes.getValue("name"))) != null) {
                this.current.addAcceptable(definition);
            }
        }
    }
}

