/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.trix.cuery.filter.AbstractPseudoFilter;
import org.trix.cuery.filter.AcceptFilter;
import org.trix.cuery.filter.AttributeFilter;
import org.trix.cuery.filter.ChildFilter;
import org.trix.cuery.filter.ClassFilter;
import org.trix.cuery.filter.DescendantFilter;
import org.trix.cuery.filter.DirectAdjacentFilter;
import org.trix.cuery.filter.ElementFilter;
import org.trix.cuery.filter.EmptyFilter;
import org.trix.cuery.filter.Filter;
import org.trix.cuery.filter.FirstChildFilter;
import org.trix.cuery.filter.FirstTypedFilter;
import org.trix.cuery.filter.HyphenTokensFilter;
import org.trix.cuery.filter.IDFilter;
import org.trix.cuery.filter.LastChildFilter;
import org.trix.cuery.filter.LastTypedFilter;
import org.trix.cuery.filter.MultipleFilter;
import org.trix.cuery.filter.OnlyChildFilter;
import org.trix.cuery.filter.OnlyTypedFilter;
import org.trix.cuery.filter.PseudoElementFilter;
import org.trix.cuery.filter.PseudoFilter;
import org.trix.cuery.filter.RootFilter;
import org.trix.cuery.filter.TokensFilter;
import org.trix.cuery.property.InheritableProperty;
import org.trix.cuery.property.Property;
import org.trix.cuery.util.DOMUtil;
import org.trix.cuery.util.I18nUtil;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.EMLength;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public final class CSSUtil {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private static final int ENCODING_BUFFER_SIZE = 100;
    private static final Pattern ENCODING_PATTERN = Pattern.compile("^@charset\\s[\"']([^\\s]+)[\"']");
    private static final Map PSEUDO = new HashMap();
    private static final String[] PSEUDO_ELEMENTS = new String[]{"after", "before", "first-letter", "first-line", "selection"};
    private static final String[] PSEUDO_CLASSES = new String[]{"enabled", "disabled", "checked", "indeterminate", "link", "visited", "active", "hover", "focus", "target"};

    static {
        CSSUtil.addFilter(FirstChildFilter.SINGLETON);
        CSSUtil.addFilter(FirstTypedFilter.SINGLETON);
        CSSUtil.addFilter(LastChildFilter.SINGLETON);
        CSSUtil.addFilter(LastTypedFilter.SINGLETON);
        CSSUtil.addFilter(OnlyChildFilter.SINGLETON);
        CSSUtil.addFilter(OnlyTypedFilter.SINGLETON);
        CSSUtil.addFilter(EmptyFilter.SINGLETON);
        CSSUtil.addFilter(RootFilter.SINGLETON);
        Arrays.sort(PSEUDO_ELEMENTS);
        Arrays.sort(PSEUDO_CLASSES);
    }

    private CSSUtil() {
    }

    public static InputSource getSource(String uri) throws IOException {
        if (uri == null || uri.length() == 0) {
            throw new IOException("This input uri is null.");
        }
        if (uri.startsWith("file:")) {
            uri = uri.substring(5);
        }
        try {
            URL url = new URL(uri);
            return CSSUtil.getSource(url.openStream(), uri);
        }
        catch (MalformedURLException e) {
            return CSSUtil.getSource(new FileInputStream(uri), uri);
        }
        catch (IOException e) {
            throw new IOException("This input uri can't open stream. '" + uri + "'");
        }
    }

    public static InputSource getSource(File file) throws IOException {
        if (file == null) {
            throw new IOException("This input is null file.");
        }
        String uri = file.getPath();
        if (uri.startsWith("file:")) {
            uri = uri.substring(5);
        }
        return CSSUtil.getSource(new FileInputStream(file), uri);
    }

    public static InputSource getSource(InputStream input) throws IOException {
        return CSSUtil.getSource(input, null);
    }

    public static InputSource getSource(InputStream input, String uri) throws IOException {
        InputStreamReader reader;
        if (input == null) {
            throw new IOException("This input is null input stream.");
        }
        PushbackInputStream pushback = null;
        pushback = input instanceof PushbackInputStream ? (PushbackInputStream)input : new PushbackInputStream(input, 100);
        byte[] buffer = new byte[100];
        int length = pushback.read(buffer, 0, buffer.length);
        pushback.unread(buffer, 0, length);
        InputSource source = new InputSource();
        Matcher matcher = ENCODING_PATTERN.matcher(new String(buffer, 0, length, "ASCII"));
        if (matcher.lookingAt()) {
            reader = new InputStreamReader((InputStream)pushback, matcher.group(1));
            source.setEncoding(matcher.group(1));
        } else {
            reader = new InputStreamReader((InputStream)pushback, DEFAULT_ENCODING);
            source.setEncoding(DEFAULT_ENCODING);
        }
        source.setCharacterStream((Reader)new BufferedReader(reader));
        source.setURI(uri);
        return source;
    }

    public static Filter convert(Condition condition) {
        if (condition instanceof Filter) {
            return (Filter)condition;
        }
        switch (condition.getConditionType()) {
            case 0: {
                CombinatorCondition combo = (CombinatorCondition)condition;
                return new MultipleFilter(CSSUtil.convert(combo.getFirstCondition()), CSSUtil.convert(combo.getSecondCondition()));
            }
            case 4: {
                AttributeCondition attr = (AttributeCondition)condition;
                return new AttributeFilter(attr.getLocalName(), attr.getValue());
            }
            case 9: {
                AttributeCondition clazz = (AttributeCondition)condition;
                return new ClassFilter(clazz.getValue());
            }
            case 5: {
                AttributeCondition id = (AttributeCondition)condition;
                return new IDFilter(id.getValue());
            }
            case 8: {
                AttributeCondition hyphen = (AttributeCondition)condition;
                return new HyphenTokensFilter(hyphen.getLocalName(), hyphen.getValue());
            }
            case 7: {
                AttributeCondition one = (AttributeCondition)condition;
                return new TokensFilter(one.getLocalName(), one.getValue());
            }
            case 6: {
                LangCondition lang = (LangCondition)condition;
                return new HyphenTokensFilter("xml:lang", lang.getLang());
            }
            case 10: {
                AttributeCondition pseudo = (AttributeCondition)condition;
                return CSSUtil.createPseudoFilter(pseudo.getValue());
            }
        }
        return AcceptFilter.SINGLETON;
    }

    public static Filter convert(Selector selector) {
        if (selector instanceof Filter) {
            return (Filter)selector;
        }
        switch (selector.getSelectorType()) {
            case 0: {
                ConditionalSelector conditional = (ConditionalSelector)selector;
                return new MultipleFilter(CSSUtil.convert((Selector)conditional.getSimpleSelector()), CSSUtil.convert(conditional.getCondition()));
            }
            case 4: {
                ElementSelector element = (ElementSelector)selector;
                return new ElementFilter(null, element.getNamespaceURI(), element.getLocalName());
            }
            case 11: {
                DescendantSelector child = (DescendantSelector)selector;
                return new ChildFilter(child.getAncestorSelector(), child.getSimpleSelector());
            }
            case 10: {
                DescendantSelector descendant = (DescendantSelector)selector;
                return new DescendantFilter(descendant.getAncestorSelector(), descendant.getSimpleSelector());
            }
            case 12: {
                SiblingSelector sibling = (SiblingSelector)selector;
                return new DirectAdjacentFilter(sibling.getNodeType(), sibling.getSelector(), sibling.getSiblingSelector());
            }
        }
        return AcceptFilter.SINGLETON;
    }

    public static CSSValue convert(LexicalUnit unit) {
        if (unit == null) {
            return null;
        }
        if (unit instanceof CSSValue) {
            return (CSSValue)unit;
        }
        switch (unit.getLexicalUnitType()) {
            case 15: {
                return new EMLength(unit.getStringValue(), CSSUtil.convert(unit.getPreviousLexicalUnit()));
            }
        }
        return null;
    }

    public static Filter createPseudoFilter(String name) throws CSSException {
        Filter filter = (Filter)PSEUDO.get(name);
        if (filter != null) {
            return filter;
        }
        if (ArrayUtils.indexOf((Object[])PSEUDO_CLASSES, (Object)name) != -1) {
            return new PseudoFilter(name);
        }
        if (ArrayUtils.indexOf((Object[])PSEUDO_ELEMENTS, (Object)name) != -1) {
            return new PseudoElementFilter(name);
        }
        throw new CSSException(I18nUtil.getText("parser.invalidPseudo", name));
    }

    private static void addFilter(AbstractPseudoFilter filter) {
        PSEUDO.put(filter.getValue(), filter);
    }

    public static String displayFloat(float value) {
        int intValue = (int)value;
        if (value == (float)intValue) {
            return Integer.toString(intValue, 10);
        }
        return Float.toString(value);
    }

    public static boolean isPseudoElement(String name) {
        return ArrayUtils.indexOf((Object[])PSEUDO_ELEMENTS, (Object)name) != -1;
    }

    public static String getErrorMessage(CSSParseException exception) {
        StringBuffer buffer = new StringBuffer("CSS parsing error is occured in '");
        buffer.append(exception.getURI());
        buffer.append("' at line ");
        buffer.append(exception.getLineNumber());
        buffer.append(", column ");
        buffer.append(exception.getColumnNumber());
        buffer.append(".");
        buffer.append(SEPARATOR);
        buffer.append("Message : ");
        buffer.append(exception.getMessage());
        if (exception.getException() != null) {
            buffer.append(SEPARATOR);
            buffer.append("Caused by : ");
            buffer.append(exception.getException().getMessage());
        }
        return buffer.toString();
    }

    public static Property getProperty(Element target) {
        if (target == null) {
            return null;
        }
        Property property = (Property)target.getUserData(Property.KEY);
        if (property != null) {
            return property;
        }
        Element parent = DOMUtil.getParentElement(target);
        if (parent == null) {
            return null;
        }
        property = new InheritableProperty(CSSUtil.getProperty(parent));
        target.setUserData(Property.KEY, property, null);
        return property;
    }

    public static String toString(CSSValue value) {
        if (value == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        CSSValue current = value;
        while (current != null) {
            buffer.append(current.toString());
            short type = current.getLexicalUnitType();
            if (type == 4) {
                current = current.getNextValue();
                continue;
            }
            if ((current = current.getNextValue()) == null || (type = current.getLexicalUnitType()) == 4 || type == 0) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static CSSValue singleValue(CSSValue value) {
        if (value.getLength() == 1) {
            return value;
        }
        return new SingleValue(value);
    }

    private static final class SingleValue
    implements CSSValue {
        private CSSValue value;

        public SingleValue(CSSValue value) {
            this.value = value;
        }

        public CSSValue get(int index) {
            if (index != 1) {
                return null;
            }
            return this.value;
        }

        public Counter getCounterValue() throws DOMException {
            return this.value.getCounterValue();
        }

        public String getCssText() {
            return this.value.getCssText();
        }

        public short getCssValueType() {
            return this.value.getCssValueType();
        }

        public String getDimensionUnitText() {
            return this.value.getDimensionUnitText();
        }

        public float getFloatValue() {
            return this.value.getFloatValue();
        }

        public float getFloatValue(short arg0) throws DOMException {
            return this.value.getFloatValue(arg0);
        }

        public String getFunctionName() {
            return this.value.getFunctionName();
        }

        public int getIntegerValue() {
            return this.value.getIntegerValue();
        }

        public int getLength() {
            return 1;
        }

        public short getLexicalUnitType() {
            return this.value.getLexicalUnitType();
        }

        public LexicalUnit getNextLexicalUnit() {
            return null;
        }

        public CSSValue getNextValue() {
            return null;
        }

        public LexicalUnit getParameters() {
            return this.value.getParameters();
        }

        public LexicalUnit getPreviousLexicalUnit() {
            return null;
        }

        public CSSValue getPreviousValue() {
            return null;
        }

        public short getPrimitiveType() {
            return this.value.getPrimitiveType();
        }

        public Rect getRectValue() throws DOMException {
            return this.value.getRectValue();
        }

        public RGBColor getRGBColorValue() throws DOMException {
            return this.value.getRGBColorValue();
        }

        public String getStringValue() {
            return this.value.getStringValue();
        }

        public LexicalUnit getSubValues() {
            return this.value.getSubValues();
        }

        public Class getType() {
            return this.value.getType();
        }

        public org.w3c.dom.css.CSSValue item(int index) {
            if (index != 1) {
                return null;
            }
            return this.value;
        }

        public void setCssText(String arg0) throws DOMException {
            this.value.setCssText(arg0);
        }

        public void setFloatValue(short arg0, float arg1) throws DOMException {
            this.value.setFloatValue(arg0, arg1);
        }

        public void setStringValue(short arg0, String arg1) throws DOMException {
            this.value.setStringValue(arg0, arg1);
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

