/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.css;

import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: AbstractCSSConsumer.java,v 1.0 2005/08/05 17:29:13 Teletha Exp $
 */
public abstract class AbstractCSSConsumer implements CSSConsumer {

    /**
     * @see org.w3c.css.sac.DocumentHandler#startDocument(org.w3c.css.sac.InputSource)
     */
    public void startDocument(InputSource source) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#endDocument(org.w3c.css.sac.InputSource)
     */
    public void endDocument(InputSource source) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#comment(java.lang.String)
     */
    public void comment(String data) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#ignorableAtRule(java.lang.String)
     */
    public void ignorableAtRule(String data) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#namespaceDeclaration(java.lang.String, java.lang.String)
     */
    public void namespaceDeclaration(String prefix, String namespaceURI) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#importStyle(java.lang.String,
     *      org.w3c.css.sac.SACMediaList, java.lang.String)
     */
    public void importStyle(String uri, SACMediaList mediaList, String defaultNamespaceURI) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#startMedia(org.w3c.css.sac.SACMediaList)
     */
    public void startMedia(SACMediaList mediaList) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#endMedia(org.w3c.css.sac.SACMediaList)
     */
    public void endMedia(SACMediaList mediaList) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#startPage(java.lang.String, java.lang.String)
     */
    public void startPage(String name, String page) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#endPage(java.lang.String, java.lang.String)
     */
    public void endPage(String name, String page) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#startFontFace()
     */
    public void startFontFace() throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#endFontFace()
     */
    public void endFontFace() throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#startSelector(org.w3c.css.sac.SelectorList)
     */
    public void startSelector(SelectorList selectorList) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#endSelector(org.w3c.css.sac.SelectorList)
     */
    public void endSelector(SelectorList selectorList) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.DocumentHandler#property(java.lang.String, org.w3c.css.sac.LexicalUnit,
     *      boolean)
     */
    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.ErrorHandler#error(org.w3c.css.sac.CSSParseException)
     */
    public void error(CSSParseException exception) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.ErrorHandler#fatalError(org.w3c.css.sac.CSSParseException)
     */
    public void fatalError(CSSParseException exception) throws CSSException {
    }

    /**
     * @see org.w3c.css.sac.ErrorHandler#warning(org.w3c.css.sac.CSSParseException)
     */
    public void warning(CSSParseException exception) throws CSSException {
    }

}
