/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import org.w3c.css.sac.Condition;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: AcceptFilter.java,v 1.0 2005/07/26 1:47:09 Teletha Exp $
 */
public final class AcceptFilter implements Filter {

    /** The singleton instance. */
    public static final AcceptFilter SINGLETON = new AcceptFilter();

    /**
     * Avoid creating AcceptFilter instance.
     */
    private AcceptFilter() {
    }

    /**
     * @see org.trix.cuery.filter.Filter#accept(org.w3c.dom.Element)
     */
    public boolean accept(Element target) {
        return true;
    }

    /**
     * @see org.trix.cuery.filter.Filter#getSpecificity()
     */
    public int getSpecificity() {
        return 0;
    }

    /**
     * @see org.trix.cuery.filter.Filter#getState()
     */
    public int getState() {
        return 0;
    }

    /**
     * @see org.w3c.css.sac.Condition#getConditionType()
     */
    public short getConditionType() {
        return Condition.SAC_NEGATIVE_CONDITION;
    }

    /**
     * @see org.w3c.css.sac.Selector#getSelectorType()
     */
    public short getSelectorType() {
        return SAC_NEGATIVE_SELECTOR;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "";
    }

}
