/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import java.util.Set;

import org.trix.cuery.util.DOMUtil;

import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: DirectAdjacentFilter.java,v 1.1 2005/08/04 22:35:32 Teletha Exp $
 */
public class DirectAdjacentFilter extends AbstractProcessingFilter implements SiblingSelector {

    /** The node type. */
    protected short nodeType;

    /**
     * Create DirectAdjacentFilter instance.
     * 
     * @param nodeType A node type.
     * @param parent A parent selector.
     * @param current A current selector.
     */
    public DirectAdjacentFilter(short nodeType, Selector parent, SimpleSelector current) {
        super(parent, current);
        this.nodeType = nodeType;
    }

    /**
     * @see org.trix.cuery.filter.ProcessingFilter#process(java.util.Set, org.w3c.dom.Element)
     */
    public void process(Set container, Element source) {
        Element next = DOMUtil.getNextElement(source);

        if (next != null && current.accept(next)) {
            container.add(next);
        }
    }

    /**
     * @see org.w3c.css.sac.Selector#getSelectorType()
     */
    public short getSelectorType() {
        return SAC_DIRECT_ADJACENT_SELECTOR;
    }

    /**
     * @see org.w3c.css.sac.SiblingSelector#getNodeType()
     */
    public short getNodeType() {
        return nodeType;
    }

    /**
     * @see org.w3c.css.sac.SiblingSelector#getSiblingSelector()
     */
    public SimpleSelector getSiblingSelector() {
        return getSimpleSelector();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return parent + " + " + current;
    }
}
