/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: RootFilter.java,v 1.0 2005/07/27 16:05:24 Teletha Exp $
 */
public final class RootFilter extends AbstractPseudoFilter {

    /** The singleton instance. */
    public static final RootFilter SINGLETON = new RootFilter();

    /**
     * Avoid creating RootFilter instance.
     */
    private RootFilter() {
    }

    /**
     * @see org.trix.cuery.filter.Filter#accept(org.w3c.dom.Element)
     */
    public boolean accept(Element target) {
        return target.getOwnerDocument().getDocumentElement() == target;
    }

    /**
     * @see org.trix.cuery.filter.AbstractPseudoFilter#getPseudoName()
     */
    protected String getPseudoName() {
        return "root";
    }
}
