/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import java.util.Map;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: BoxModelPropertyDefinition.java,v 1.0 2005/09/01 7:09:46 Teletha Exp $
 */
public class BoxModelPropertyDefinition extends ShorthandPropertyDefinition {

    /**
     * @see org.trix.cuery.property.ShorthandPropertyDefinition#validate(java.util.Map)
     */
    protected Map validate(Map result) {
        Object property1;
        Object property2;

        PropertyDefinition definition1 = (PropertyDefinition) definitions.get(0);
        PropertyDefinition definition2 = (PropertyDefinition) definitions.get(1);
        PropertyDefinition definition3 = (PropertyDefinition) definitions.get(2);
        PropertyDefinition definition4 = (PropertyDefinition) definitions.get(3);

        switch (result.size()) {
        case 1:
            property1 = result.get(definition1.getName());

            result.put(definition2.getName(), property1);
            result.put(definition3.getName(), property1);
            result.put(definition4.getName(), property1);
            break;

        case 2:
            property1 = result.get(definition1.getName());
            property2 = result.get(definition2.getName());

            result.put(definition3.getName(), property1);
            result.put(definition4.getName(), property2);
            break;

        case 3:
            property2 = result.get(definition2.getName());

            result.put(definition4.getName(), property2);
            break;

        default:
        }
        return result;
    }
}
