/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import org.trix.cuery.value.CSSValue;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: InheritableProperty.java,v 1.0 2005/08/19 3:44:46 Teletha Exp $
 */
public class InheritableProperty extends AbstractProperty {

    /** The parent property. */
    private Property parent;

    /**
     * Create InheritableProperty instance.
     * 
     * @param parent A parent property.
     */
    public InheritableProperty(Property parent) {
        this.parent = parent;
    }

    /**
     * @see org.trix.cuery.property.Property#getValue(java.lang.String, int)
     */
    public CSSValue getValue(String name, int state) {
        PropertyDefinition definition = PropertyRegistry.getDefinition(name);

        if (parent != null && definition.isInheritable()) {
            return parent.getValue(name, state);
        }
        return definition.getComputedValue(definition.getInitialValue(), this, parent);
    }

    /**
     * @see org.trix.cuery.property.Property#isImportant(java.lang.String)
     */
    public boolean isImportant(String name) {
        PropertyDefinition definition = PropertyRegistry.getDefinition(name);

        if (parent != null && definition.isInheritable()) {
            return parent.isImportant(name);
        }
        return false;
    }

}
