/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import org.trix.cuery.util.CSSUtil;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSNumber.java,v 1.01 2005/08/13 17:26:15 Teletha Exp $
 */
public class CSSNumber extends AbstractCSSValue {

    /**
     * Create CSSNumber instance.
     * 
     * @param number A integer number.
     * @param previous A previous value of this value.
     */
    public CSSNumber(float number, CSSValue previous) {
        super(previous);

        this.stringValue = CSSUtil.displayFloat(number);
        this.floatValue = number;
    }

    /**
     * Create CSSNumber instance.
     * 
     * @param number A number value as a string.
     * @param previous A previous value of this value.
     */
    public CSSNumber(String number, CSSValue previous) {
        super(previous);

        this.stringValue = number;
        this.floatValue = Float.parseFloat(number);
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getLexicalUnitType()
     */
    public short getLexicalUnitType() {
        if (floatValue > (int) floatValue) {
            return SAC_REAL;
        } else {
            return SAC_INTEGER;
        }
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getFloatValue()
     */
    public float getFloatValue() {
        return floatValue;
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getStringValue()
     */
    public String getStringValue() {
        return stringValue;
    }

    /**
     * @see org.w3c.dom.css.CSSPrimitiveValue#getPrimitiveType()
     */
    public short getPrimitiveType() {
        return CSS_NUMBER;
    }
}
