/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import org.w3c.css.sac.CSSException;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSOperator.java,v 1.0 2005/08/10 11:40:37 Teletha Exp $
 */
public class CSSOperator extends AbstractCSSValue {

    /** The comma operator. */
    private static final char COMMA = ',';

    /** The minus operator. */
    private static final char MINUS = '-';

    /** The plus operator. */
    private static final char PLUS = '+';

    /** The slash operator. */
    private static final char SLASH = '/';

    /** The operator. */
    private char operator;

    /**
     * Create CSSOperator instance.
     * 
     * @param operator A operator.
     * @param previous A previous value.
     */
    public CSSOperator(String operator, CSSValue previous) {
        super(previous);

        if (operator == null || operator.length() != 1) {
            throw new CSSException("This value is invalid for operator. [" + operator + "]");
        }
        this.stringValue = operator;
        this.operator = operator.charAt(0);
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getLexicalUnitType()
     */
    public short getLexicalUnitType() {
        switch (operator) {
        case COMMA:
            return SAC_OPERATOR_COMMA;

        case SLASH:
            return SAC_OPERATOR_SLASH;

        case PLUS:
            return SAC_OPERATOR_PLUS;

        case MINUS:
            return SAC_OPERATOR_MINUS;

        default:
            return SAC_OPERATOR_EXP;
        }
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getFloatValue()
     */
    public float getFloatValue() {
        throw new UnsupportedOperationException(getClass() + " can't execute this method.");
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getStringValue()
     */
    public String getStringValue() {
        return stringValue;
    }

    /**
     * @see org.w3c.dom.css.CSSPrimitiveValue#getPrimitiveType()
     */
    public short getPrimitiveType() {
        return CSS_UNKNOWN;
    }

}
