/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import junit.framework.TestCase;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: PropertyDefinitionTest.java,v 1.0 2005/08/16 3:32:01 Teletha Exp $
 */
public class PropertyDefinitionTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.property.PropertyDefinition.getDefinition(String)'
     */
    public void testGetDefinition() {
        PropertyDefinition definition = PropertyRegistry.getDefinition("overflow");
        assertNotNull(definition);
        assertFalse(definition.isInheritable());
        assertEquals("visible", definition.getInitialValue().getStringValue());
    }

}
