/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.util;

import junit.framework.TestCase;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSUtilTest.java,v 1.01 2005/07/30 8:38:22 Teletha Exp $
 */
public class CSSUtilTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.util.CSSUtil.getCharset(InputStream)'
     */
    public void testGetSource() throws Exception {
        String input = "src/test/org/trix/cuery/parser/charset-Shift_JIS.css";
        assertEquals("Shift_JIS", CSSUtil.getSource(input).getEncoding());

        input = "src/test/org/trix/cuery/parser/charset-JIS.css";
        assertEquals("JIS", CSSUtil.getSource(input).getEncoding());

        input = "src/test/org/trix/cuery/parser/charset-EUC-JP.css";
        assertEquals("EUC-JP", CSSUtil.getSource(input).getEncoding());
    }
}
