/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import junit.framework.TestCase;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: ValueUtilTest.java,v 1.0 2005/09/09 21:12:07 Teletha Exp $
 */
public class ValueUtilTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.value.ValueUtil.divide(CSSLength, float)'
     */
    public void testDivide() {
        CSSLength length = new PointLength(10);
        assertEquals(100, ValueUtil.divide(length, 0.1f).getFloatValue(), 0);

        length = new PointLength(10.4f);
        assertEquals(23.1f, ValueUtil.divide(length, 0.45f).getFloatValue(), 0);
    }

    /*
     * Test method for 'org.trix.cuery.value.ValueUtil.isCSSLength(CSSValue)'
     */
    public void testIsCSSLength() {
        assertTrue(ValueUtil.isCSSLength(new PointLength(10)));
        assertTrue(ValueUtil.isCSSLength(new EMLength(10)));
        assertFalse(ValueUtil.isCSSLength(new Identifier("false")));
    }

    /*
     * Test method for 'org.trix.cuery.value.ValueUtil.isAbsoluteCSSLength(CSSValue)'
     */
    public void testIsAbsoluteCSSLength() {
        assertTrue(ValueUtil.isAbsoluteCSSLength(new PointLength(10)));
        assertFalse(ValueUtil.isAbsoluteCSSLength(new EMLength(10)));
    }

    /*
     * Test method for 'org.trix.cuery.value.ValueUtil.multiply(CSSLength, CSSPercentage)'
     */
    public void testMultiplyCSSLengthCSSPercentage() {
        CSSLength length = new PointLength(10);
        CSSPercentage percentage = new CSSPercentage(10);
        assertEquals(1f, ValueUtil.multiply(length, percentage).getFloatValue(), 0);

        length = new PointLength(100);
        percentage = new CSSPercentage(10.5f);
        assertEquals(10.5f, ValueUtil.multiply(length, percentage).getFloatValue(), 0);

        length = new PointLength(50.9f);
        percentage = new CSSPercentage(10.5f);
        assertEquals(5.3f, ValueUtil.multiply(length, percentage).getFloatValue(), 0);
    }

    /*
     * Test method for 'org.trix.cuery.value.ValueUtil.multiply(CSSLength, float)'
     */
    public void testMultiplyCSSLengthFloat() {
        CSSLength length = new PointLength(10);
        assertEquals(1f, ValueUtil.multiply(length, 0.1f).getFloatValue(), 0);
    }

    /*
     * Test method for 'org.trix.cuery.value.ValueUtil.round(float)'
     */
    public void testRound() {
        assertEquals(1.4f, ValueUtil.round(1.43f), 0);
        assertEquals(1.5f, ValueUtil.round(1.451f), 0);
    }

}
