/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.css;

import java.io.IOException;
import org.trix.cuery.css.AbstractCSSPipe;
import org.trix.cuery.parser.CueryParser;
import org.trix.cuery.util.URIUtil;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.SACMediaList;

public class ImportablePipe
extends AbstractCSSPipe {
    private String base;

    public ImportablePipe(String base) {
        this.base = base;
    }

    public void importStyle(String uri, SACMediaList mediaList, String defaultNamespaceURI) throws CSSException {
        String normalizedURI = URIUtil.getNormalizedURI(this.base, uri);
        if (normalizedURI == null || normalizedURI.length() == 0) {
            throw new CSSException("This uri is invalid.");
        }
        try {
            ImportablePipe pipe = new ImportablePipe(normalizedURI);
            pipe.setConsumer(this.consumer);
            CueryParser parser = new CueryParser();
            parser.setDocumentHandler(pipe);
            parser.parseStyleSheet(normalizedURI);
        }
        catch (IOException e) {
            throw new CSSException(e.getMessage());
        }
    }
}

