/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.css;

import org.trix.cuery.css.AbstractCSSPipe;
import org.trix.cuery.sac.SACMediaListImpl;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;

public class MediaAwarePipe
extends AbstractCSSPipe {
    private SACMediaListImpl awareList = new SACMediaListImpl();
    private boolean aware = true;

    public void setAwareMedia(String media) {
        this.awareList.appendMedium(media);
    }

    public void startDocument(InputSource inputSource) throws CSSException {
        super.startDocument(inputSource);
    }

    public void endDocument(InputSource inputSource) throws CSSException {
        super.endDocument(inputSource);
    }

    public void comment(String comment) throws CSSException {
        if (this.aware) {
            super.comment(comment);
        }
    }

    public void ignorableAtRule(String atRule) throws CSSException {
        if (this.aware) {
            super.ignorableAtRule(atRule);
        }
    }

    public void namespaceDeclaration(String prefix, String namespaceURI) throws CSSException {
        if (this.aware) {
            super.namespaceDeclaration(prefix, namespaceURI);
        }
    }

    public void importStyle(String uri, SACMediaList mediaList, String defaultNamespaceURI) throws CSSException {
        if (this.aware && this.isAware(mediaList)) {
            super.importStyle(uri, mediaList, defaultNamespaceURI);
        }
    }

    public void startMedia(SACMediaList mediaList) throws CSSException {
        this.aware = this.isAware(mediaList);
        if (this.aware) {
            super.startMedia(mediaList);
        }
    }

    public void endMedia(SACMediaList mediaList) throws CSSException {
        if (this.aware) {
            super.endMedia(mediaList);
        }
        this.aware = true;
    }

    public void startPage(String name, String pseudoPage) throws CSSException {
        if (this.aware) {
            super.startPage(name, pseudoPage);
        }
    }

    public void endPage(String name, String pseudoPage) throws CSSException {
        if (this.aware) {
            super.endPage(name, pseudoPage);
        }
    }

    public void startFontFace() throws CSSException {
        if (this.aware) {
            super.startFontFace();
        }
    }

    public void endFontFace() throws CSSException {
        if (this.aware) {
            super.endFontFace();
        }
    }

    public void startSelector(SelectorList selectors) throws CSSException {
        if (this.aware) {
            super.startSelector(selectors);
        }
    }

    public void endSelector(SelectorList selectors) throws CSSException {
        if (this.aware) {
            super.endSelector(selectors);
        }
    }

    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        if (this.aware) {
            super.property(name, value, important);
        }
    }

    private boolean isAware(SACMediaList mediaList) {
        if (mediaList == null) {
            return false;
        }
        int i = 0;
        while (i < mediaList.getLength()) {
            String mediaType = mediaList.item(i);
            if (mediaType.equalsIgnoreCase("all")) {
                return true;
            }
            int j = 0;
            while (j < this.awareList.getLength()) {
                if (mediaType.equalsIgnoreCase(this.awareList.item(j))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

