/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.value;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import org.trix.cuery.property.PropertyRegistry;
import org.trix.cuery.value.CSSLength;
import org.trix.cuery.value.CSSPercentage;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.CentimeterLength;
import org.trix.cuery.value.EMLength;
import org.trix.cuery.value.EXLength;
import org.trix.cuery.value.InchLength;
import org.trix.cuery.value.MillimeterLength;
import org.trix.cuery.value.PicaLength;
import org.trix.cuery.value.PixelLength;
import org.trix.cuery.value.PointLength;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public final class ValueUtil {
    public static final PixelLength ZERO_PIXEL = new PixelLength(0.0f);
    private static final int SCALE = 1;
    static /* synthetic */ Class class$0;

    private ValueUtil() {
    }

    public static PixelLength convertToPixelLength(CSSLength length) {
        return new PixelLength(ValueUtil.convertToPixelLength(length.getFloatValue(), length.getLexicalUnitType()));
    }

    public static float convertToPixelLength(float value, short type) {
        float result;
        int dpi = PropertyRegistry.getFontConfiguration().getDisplayDPI();
        switch (type) {
            case 19: {
                result = value * (float)dpi / 15.24f;
                break;
            }
            case 18: {
                result = value * (float)dpi;
                break;
            }
            case 20: {
                result = value * (float)dpi / 152.4f;
                break;
            }
            case 22: {
                result = value * (float)dpi / 6.0f;
                break;
            }
            case 17: {
                result = value;
                break;
            }
            case 21: {
                result = value * (float)dpi / 72.0f;
                break;
            }
            default: {
                result = value;
            }
        }
        return ValueUtil.round(result);
    }

    public static CSSLength divide(CSSLength length, float scale) {
        if (length == null) {
            return ZERO_PIXEL;
        }
        return ValueUtil.createCSSLength(length.getLexicalUnitType(), ValueUtil.round(length.getFloatValue() / scale));
    }

    public static boolean isCSSLength(CSSValue value) {
        short type = value.getPrimitiveType();
        return 3 <= type && type <= 10;
    }

    public static boolean isAbsoluteCSSLength(CSSValue value) {
        short type = value.getPrimitiveType();
        return 5 <= type && type <= 10;
    }

    public static CSSLength multiply(CSSLength length, CSSPercentage percentage) {
        if (percentage == null) {
            return ValueUtil.multiply(length, 1.0f);
        }
        return ValueUtil.multiply(length, percentage.floatValue / 100.0f);
    }

    public static CSSLength multiply(CSSLength length, float scale) {
        if (length == null) {
            return ZERO_PIXEL;
        }
        return ValueUtil.createCSSLength(length.getLexicalUnitType(), ValueUtil.round(length.getFloatValue() * scale));
    }

    public static CSSValue replace(CSSValue current, CSSValue newValue) {
        Field length = null;
        Field position = null;
        Field next = null;
        Field previous = null;
        try {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.trix.cuery.value.AbstractCSSValue");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                length = clazz.getDeclaredField("length");
                length.setAccessible(true);
                length.setInt(newValue, length.getInt(current));
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.trix.cuery.value.AbstractCSSValue");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                position = clazz2.getDeclaredField("position");
                position.setAccessible(true);
                position.setInt(newValue, position.getInt(current));
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("org.trix.cuery.value.AbstractCSSValue");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                next = clazz3.getDeclaredField("next");
                next.setAccessible(true);
                Class<?> clazz4 = class$0;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$0 = Class.forName("org.trix.cuery.value.AbstractCSSValue");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                previous = clazz4.getDeclaredField("previous");
                previous.setAccessible(true);
                if (current.getPreviousValue() != null) {
                    next.set(current.getPreviousValue(), newValue);
                    previous.set(newValue, current.getPreviousValue());
                }
                if (current.getNextValue() != null) {
                    next.set(newValue, current.getNextValue());
                    previous.set(current.getNextValue(), newValue);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        finally {
            if (length != null) {
                length.setAccessible(false);
            }
            if (position != null) {
                position.setAccessible(false);
            }
            if (next != null) {
                next.setAccessible(false);
            }
            if (previous != null) {
                previous.setAccessible(false);
            }
        }
        return newValue;
    }

    public static float round(float value) {
        return new BigDecimal(String.valueOf(value)).setScale(1, 6).floatValue();
    }

    public static CSSValue singleValue(CSSValue value) {
        if (value.getLength() == 1) {
            return value;
        }
        return new SingleValue(value);
    }

    public static String toString(CSSValue value) {
        if (value == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        CSSValue current = value;
        while (current != null) {
            buffer.append(current.toString());
            short type = current.getLexicalUnitType();
            if (type == 4) {
                current = current.getNextValue();
                continue;
            }
            if ((current = current.getNextValue()) == null || (type = current.getLexicalUnitType()) == 4 || type == 0) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }

    private static CSSLength createCSSLength(short type, float value) {
        switch (type) {
            case 19: {
                return new CentimeterLength(value);
            }
            case 15: {
                return new EMLength(value);
            }
            case 16: {
                return new EXLength(value);
            }
            case 18: {
                return new InchLength(value);
            }
            case 20: {
                return new MillimeterLength(value);
            }
            case 22: {
                return new PicaLength(value);
            }
            case 17: {
                return new PixelLength(value);
            }
            case 21: {
                return new PointLength(value);
            }
        }
        return ZERO_PIXEL;
    }

    private static final class SingleValue
    implements CSSValue {
        private CSSValue value;

        public SingleValue(CSSValue value) {
            this.value = value;
        }

        public CSSValue get(int index) {
            if (index != 1) {
                return null;
            }
            return this.value;
        }

        public Counter getCounterValue() throws DOMException {
            return this.value.getCounterValue();
        }

        public String getCssText() {
            return this.value.getCssText();
        }

        public short getCssValueType() {
            return this.value.getCssValueType();
        }

        public String getDimensionUnitText() {
            return this.value.getDimensionUnitText();
        }

        public float getFloatValue() {
            return this.value.getFloatValue();
        }

        public float getFloatValue(short arg0) throws DOMException {
            return this.value.getFloatValue(arg0);
        }

        public String getFunctionName() {
            return this.value.getFunctionName();
        }

        public int getIntegerValue() {
            return this.value.getIntegerValue();
        }

        public int getLength() {
            return 1;
        }

        public short getLexicalUnitType() {
            return this.value.getLexicalUnitType();
        }

        public LexicalUnit getNextLexicalUnit() {
            return null;
        }

        public CSSValue getNextValue() {
            return null;
        }

        public LexicalUnit getParameters() {
            return this.value.getParameters();
        }

        public int getPosition() {
            return 0;
        }

        public LexicalUnit getPreviousLexicalUnit() {
            return null;
        }

        public CSSValue getPreviousValue() {
            return null;
        }

        public short getPrimitiveType() {
            return this.value.getPrimitiveType();
        }

        public Rect getRectValue() throws DOMException {
            return this.value.getRectValue();
        }

        public RGBColor getRGBColorValue() throws DOMException {
            return this.value.getRGBColorValue();
        }

        public String getStringValue() {
            return this.value.getStringValue();
        }

        public LexicalUnit getSubValues() {
            return this.value.getSubValues();
        }

        public Class getType() {
            return this.value.getType();
        }

        public org.w3c.dom.css.CSSValue item(int index) {
            if (index != 1) {
                return null;
            }
            return this.value;
        }

        public void setCssText(String arg0) throws DOMException {
            this.value.setCssText(arg0);
        }

        public void setFloatValue(short arg0, float arg1) throws DOMException {
            this.value.setFloatValue(arg0, arg1);
        }

        public void setStringValue(short arg0, String arg1) throws DOMException {
            this.value.setStringValue(arg0, arg1);
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

