/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.ElementSelector;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: AbstractPseudoFilter.java,v 1.1 2005/08/02 19:14:39 Teletha Exp $
 */
public abstract class AbstractPseudoFilter implements Filter, AttributeCondition, ElementSelector {

    /**
     * @see org.trix.cuery.filter.Filter#getSpecificity()
     */
    public int getSpecificity() {
        return 10;
    }

    /**
     * @see org.trix.cuery.filter.Filter#getState()
     */
    public int getState() {
        return 0;
    }

    /**
     * @see org.w3c.css.sac.Condition#getConditionType()
     */
    public short getConditionType() {
        return SAC_PSEUDO_CLASS_CONDITION;
    }

    /**
     * @see org.w3c.css.sac.Selector#getSelectorType()
     */
    public short getSelectorType() {
        return SAC_PSEUDO_ELEMENT_SELECTOR;
    }

    /**
     * @see org.w3c.css.sac.AttributeCondition#getLocalName()
     */
    public String getLocalName() {
        return getPseudoName();
    }

    /**
     * @see org.w3c.css.sac.AttributeCondition#getNamespaceURI()
     */
    public String getNamespaceURI() {
        return null;
    }

    /**
     * @see org.w3c.css.sac.AttributeCondition#getSpecified()
     */
    public boolean getSpecified() {
        return false;
    }

    /**
     * @see org.w3c.css.sac.AttributeCondition#getValue()
     */
    public String getValue() {
        return getPseudoName();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return ":" + getPseudoName();
    }

    /**
     * Return pseudo class name.
     * 
     * @return A name.
     */
    protected abstract String getPseudoName();
}
