/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import org.trix.cuery.value.CSSValue;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: AbstractProperty.java,v 1.02 2005/09/11 7:10:00 Teletha Exp $
 */
public abstract class AbstractProperty implements Property {

    /** The key for UI element states pseudo-classes. */
    protected static final int NORMAL = 0;

    /**
     * @see org.trix.cuery.property.Property#getValue(java.lang.String)
     */
    public CSSValue getValue(String name) {
        return getValue(name, NORMAL);
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsString(java.lang.String)
     */
    public String getValueAsString(String name) {
        return getValueAsString(name, null, NORMAL);
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsString(java.lang.String, java.lang.String)
     */
    public String getValueAsString(String name, String defaultValue) {
        return getValueAsString(name, defaultValue, NORMAL);
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsString(java.lang.String, int)
     */
    public String getValueAsString(String name, int state) {
        return getValueAsString(name, null, state);
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsString(java.lang.String, java.lang.String,
     *      int)
     */
    public String getValueAsString(String name, String defaultValue, int state) {
        CSSValue value = getValue(name, state);

        if (value == null) {
            return defaultValue;
        }
        return value.getStringValue();
    }

    /**
     * @see org.trix.cuery.property.Property#isImportant(java.lang.String)
     */
    public boolean isImportant(String name) {
        return false;
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsFloat(java.lang.String)
     */
    public float getValueAsFloat(String name) {
        return getValueAsFloat(name, 0, NORMAL);
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsFloat(java.lang.String, float)
     */
    public float getValueAsFloat(String name, float defaultValue) {
        return getValueAsFloat(name, defaultValue, NORMAL);
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsFloat(java.lang.String, int)
     */
    public float getValueAsFloat(String name, int state) {
        return getValueAsFloat(name, 0, state);
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsFloat(java.lang.String, float, int)
     */
    public float getValueAsFloat(String name, float defaultValue, int state) {
        CSSValue value = getValue(name, state);

        if (value == null) {
            return defaultValue;
        }
        return value.getFloatValue();
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsInteger(java.lang.String)
     */
    public int getValueAsInteger(String name) {
        return getValueAsInteger(name, 0, NORMAL);
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsInteger(java.lang.String, int)
     */
    public int getValueAsInteger(String name, int defaultValue) {
        return getValueAsInteger(name, defaultValue, NORMAL);
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsIntegerWithState(java.lang.String, int)
     */
    public int getValueAsIntegerWithState(String name, int state) {
        return getValueAsInteger(name, 0, state);
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsInteger(java.lang.String, int, int)
     */
    public int getValueAsInteger(String name, int defaultValue, int state) {
        CSSValue value = getValue(name, state);

        if (value == null) {
            return defaultValue;
        }
        return value.getIntegerValue();
    }

}
