/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import org.trix.cuery.value.CSSLength;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.EMLength;
import org.trix.cuery.value.ValueUtil;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: SimplePropertyDefinition.java,v 1.01 2005/09/20 06:16:33 Teletha Exp $
 */
public class SimplePropertyDefinition extends PropertyDefinition {

    /**
     * @see org.trix.cuery.property.PropertyDefinition#computeEMLength(org.trix.cuery.value.EMLength,
     *      org.trix.cuery.property.Property, org.trix.cuery.property.Property)
     */
    protected CSSValue computeEMLength(EMLength length, Property property, Property parent) {
        CSSLength fontSize = (CSSLength) property.getValue("font-size");
        return ValueUtil.multiply(fontSize, length.getFloatValue());
    }
}
