/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property.config;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: FontConfiguration.java,v 1.01 2005/08/26 4:03:03 Teletha Exp $
 */
public interface FontConfiguration {

    /**
     * @return A size.
     */
    int getDisplayDPI();

    /**
     * Return a scaling factors for line height.
     * 
     * @return A factor.
     */
    float getLineHeightFactor();

    /**
     * Return a point value.
     * 
     * @return A size.
     */
    float getMediumFontSize();

    /**
     * Return a scaling factors for font size.
     * 
     * @return A factor.
     */
    float getScalingFactor();
}
