/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: AbstractCSSAngle.java,v 1.01 2005/09/14 22:16:47 Teletha Exp $
 */
public abstract class AbstractCSSAngle extends AbstractCSSValue implements CSSAngle {

    /**
     * Create AbstractCSSAngle instance.
     * 
     * @param angle An angle.
     * @param previous A previous token.
     */
    public AbstractCSSAngle(String angle, CSSValue previous) {
        super(previous);

        // check unit
        String unit = getDimensionUnitText();

        if (angle.endsWith(unit)) {
            angle = angle.substring(0, angle.length() - unit.length());
        }

        this.stringValue = angle;
        this.floatValue = Float.parseFloat(angle);
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getFloatValue()
     */
    public float getFloatValue() {
        return floatValue;
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getStringValue()
     */
    public String getStringValue() {
        return stringValue;
    }

    /**
     * @see org.trix.cuery.value.AbstractCSSValue#getCssText()
     */
    public String getCssText() {
        return stringValue + getDimensionUnitText();
    }

}
