/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery;

import java.io.IOException;

import junit.framework.TestCase;

import org.trix.cuery.property.Property;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.util.DOMUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSWeaverTest.java,v 1.03 2005/08/25 21:47:39 Teletha Exp $
 */
public class CSSWeaverTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.CSSWeaver.apply(Document)'
     */
    public void testApply1() throws IOException {
        CSSWeaver weaver = new CSSWeaver();
        weaver.addAuthorStylesheet(CSSUtil.getSource("src/test/org/trix/cuery/cssWeaverAuthor.css"));
        weaver.addUserStylesheet(CSSUtil.getSource("src/test/org/trix/cuery/cssWeaverUser.css"));
        Document document = weaver.apply("src/test/org/trix/cuery/cssWeaver.xml");

        Element heading1 = DOMUtil.getElementById(document, "heading1");
        Property property = CSSUtil.getProperty(heading1);
        assertEquals("24px", property.getValue("text-indent").getCssText());
        assertEquals("24px", property.getValue("font-size").getCssText());
        assertEquals("italic", property.getValue("font-style").getCssText());
        assertEquals("normal", property.getValue("font-weight").getCssText());

        Element p = DOMUtil.getElementById(document, "p");
        property = CSSUtil.getProperty(p);
        // check position weight
        assertEquals("10.8px", property.getValue("font-size").getCssText());

        // check initial value
        assertEquals("visible", property.getValue("overflow").getCssText());

        Element em = DOMUtil.getElementById(document, "em");
        property = CSSUtil.getProperty(em);

        // check inherit
        assertEquals("10.8px", property.getValue("font-size").getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.CSSWeaver.apply(Document)'
     */
    public void testApply2() throws IOException {
        CSSWeaver weaver = new CSSWeaver();
        weaver.awareXmlStylesheet(true);
        Document document = weaver.apply("src/test/org/trix/cuery/cssWeaverInline.xml");

        Element heading1 = DOMUtil.getElementById(document, "heading1");
        Property property = CSSUtil.getProperty(heading1);
        assertEquals("12px", property.getValue("text-indent").getCssText());
        assertEquals("12px", property.getValue("font-size").getCssText());
        assertEquals("italic", property.getValue("font-style").getCssText());
        assertEquals("normal", property.getValue("font-weight").getCssText());

        Element p = DOMUtil.getElementById(document, "p");
        property = CSSUtil.getProperty(p);
        // check position weight
        assertEquals("10.8px", property.getValue("font-size").getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.CSSWeaver.apply(Document)'
     */
    public void testApply3() throws IOException {
        CSSWeaver weaver = new CSSWeaver();
        weaver.awareXmlStylesheet(true);
        Document prev = weaver.apply("src/test/org/trix/cuery/cssWeaverInline.xml");

        // next document with no style
        Document document = weaver.apply("src/test/org/trix/cuery/cssWeaver.xml");

        Element p = DOMUtil.getElementById(document, "p");
        Property property = CSSUtil.getProperty(p);
        assertEquals("12px", property.getValue("font-size").getCssText());

        p = DOMUtil.getElementById(prev, "p");
        property = CSSUtil.getProperty(p);
        assertEquals("10.8px", property.getValue("font-size").getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.CSSWeaver.apply(Document)'
     */
    public void testApply4() throws IOException {
        CSSWeaver weaver = new CSSWeaver();
        weaver.addAuthorStylesheet(CSSUtil.getSource("src/test/org/trix/cuery/cssWeaverAuthor.css"));
        Document document = weaver.apply("src/test/org/trix/cuery/cssWeaver.xml");

        Element address = DOMUtil.getElementById(document, "address");
        Property property = CSSUtil.getProperty(address);
        assertEquals("45px", property.getValue("text-indent").getCssText());

        Element strong = DOMUtil.getElementById(document, "strong");
        property = CSSUtil.getProperty(strong);
        assertEquals("18.8px", property.getValue("font-size").getCssText());
        assertEquals("45px", property.getValue("text-indent").getCssText());
    }
    
    /*
     * Test method for 'org.trix.cuery.CSSWeaver.apply(Document)'
     */
    public void testApply5() throws IOException {
        CSSWeaver weaver = new CSSWeaver();
        weaver.addUserStylesheet(CSSUtil.getSource("src/test/org/trix/cuery/cssWeaverHover.css"));
        Document document = weaver.apply("src/test/org/trix/cuery/cssWeaver.xml");

        Element heading = DOMUtil.getElementById(document, "heading1");
        Property property = CSSUtil.getProperty(heading);
        assertEquals("1pt", property.getValue("text-indent").getCssText());
        assertEquals("2pt", property.getValue("text-indent", Property.HOVER).getCssText());
        
        assertEquals("right", property.getValue("text-align").getCssText());
        assertEquals("right", property.getValue("text-align", Property.HOVER).getCssText());
        
        assertEquals("none", property.getValue("text-decoration").getCssText());
        assertEquals("underline", property.getValue("text-decoration", Property.HOVER).getCssText());
        
        Element address = DOMUtil.getElementById(document, "address");
        property = CSSUtil.getProperty(address);
        
        assertEquals("inline", property.getValue("display", Property.HOVER).getCssText());
        assertEquals("inline", property.getValue("display", Property.TARGET).getCssText());
        assertEquals("block", property.getValue("display", Property.HOVER | Property.TARGET).getCssText());
    }
}
