/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.css;

import junit.framework.TestCase;

import org.trix.cuery.parser.CueryParser;

import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.LexicalUnit;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: ImportablePipeTest.java,v 1.0 2005/08/10 23:49:41 Teletha Exp $
 */
public class ImportablePipeTest extends TestCase {

    /** The test parser. */
    private static CueryParser parser = new CueryParser();

    private static TestConsumer consumer = new TestConsumer();

    private static CSSPipe pipe = new ImportablePipe("src/test/org/trix/cuery/css/import.css");

    // initialize
    static {
        pipe.setConsumer(consumer);
        parser.setDocumentHandler(pipe);
    }

    /*
     * Test method for 'org.trix.cuery.css.ImportablePipe.ImportableCSSPipe(Parser)'
     */
    public void testImportableCSSPipe() throws Exception {
        parser.parseStyleSheet("src/test/org/trix/cuery/css/import.css");
        assertEquals(2, consumer.getCount());
    }

    /**
     * DOCUMENT.
     * 
     * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
     * @version $ Id: TestConsumer.java,v 1.0 2005/08/10 2:57:29 Teletha Exp $
     */
    private static class TestConsumer extends AbstractCSSConsumer {

        private int count = 0;

        /**
         * @see org.trix.cuery.css.ValidatableCSSPipe#property(java.lang.String,
         *      org.w3c.css.sac.LexicalUnit, boolean)
         */
        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            count++;
        }

        private int getCount() {
            int i = count;
            count = 0;
            return i;
        }
    }

}
