/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property.css2;

import junit.framework.TestCase;

import org.trix.cuery.property.SimpleProperty;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.Identifier;
import org.trix.cuery.value.ValueUtil;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: BorderStyleDefinitionTest.java,v 1.0 2005/08/30 18:20:24 Teletha Exp $
 */
public class BorderStyleDefinitionTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderStyleDefinition.parseValue'
     */
    public void testParseValue1() {
        CSSValue value = new Identifier("solid", null);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-style", value, false);

        assertEquals("solid", property.getValueAsString("border-top-style"));
        assertEquals("solid", property.getValueAsString("border-bottom-style"));
        assertEquals("solid", property.getValueAsString("border-right-style"));
        assertEquals("solid", property.getValueAsString("border-left-style"));

        assertEquals("solid", ValueUtil.toString(property.getValue("border-style")));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderStyleDefinition.parseValue'
     */
    public void testParseValue2() {
        CSSValue value = new Identifier("solid", null);
        new Identifier("double", value);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-style", value, false);

        assertEquals("solid", property.getValueAsString("border-top-style"));
        assertEquals("solid", property.getValueAsString("border-bottom-style"));
        assertEquals("double", property.getValueAsString("border-right-style"));
        assertEquals("double", property.getValueAsString("border-left-style"));

        assertEquals("solid double", ValueUtil.toString(property.getValue("border-style")));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderStyleDefinition.parseValue'
     */
    public void testParseValue3() {
        CSSValue value = new Identifier("solid", null);
        CSSValue value2 = new Identifier("double", value);
        new Identifier("dotted", value2);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-style", value, false);

        assertEquals("solid", property.getValueAsString("border-top-style"));
        assertEquals("dotted", property.getValueAsString("border-bottom-style"));
        assertEquals("double", property.getValueAsString("border-right-style"));
        assertEquals("double", property.getValueAsString("border-left-style"));

        assertEquals("solid double dotted", ValueUtil.toString(property.getValue("border-style")));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderStyleDefinition.parseValue'
     */
    public void testParseValue4() {
        CSSValue value = new Identifier("solid", null);
        CSSValue value2 = new Identifier("double", value);
        CSSValue value3 = new Identifier("dotted", value2);
        new Identifier("groove", value3);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-style", value, false);

        assertEquals("solid", property.getValueAsString("border-top-style"));
        assertEquals("dotted", property.getValueAsString("border-bottom-style"));
        assertEquals("double", property.getValueAsString("border-right-style"));
        assertEquals("groove", property.getValueAsString("border-left-style"));

        assertEquals("solid double dotted groove", ValueUtil.toString(property.getValue("border-style")));
    }
}
