/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.trix.cuery.css.AbstractCSSConsumer;
import org.trix.cuery.parser.CueryParser;
import org.trix.cuery.property.PropertyDefinition;
import org.trix.cuery.property.PropertyRegistry;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.util.I18nUtil;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.ValueUtil;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;

public class CSSValidator {
    private static final CueryParser PARSER = new CueryParser();
    private Option option = new Option();

    public void allowUnderscoreHack(boolean permission) {
        this.option.underscoreHack = permission;
    }

    public CSSParseException[] validate(InputSource source) throws IOException {
        ValidatableConsumer consumer = new ValidatableConsumer();
        consumer.option = this.option;
        PARSER.setDocumentHandler(consumer);
        PARSER.parseStyleSheet(source);
        return consumer.container.toArray(new CSSParseException[consumer.container.size()]);
    }

    private static class ValidatableConsumer
    extends AbstractCSSConsumer {
        private List container = new ArrayList();
        private Option option;
        private LinkedList imports = new LinkedList();

        ValidatableConsumer() {
        }

        public void endDocument(InputSource source) throws CSSException {
            if (this.imports.size() == 0) {
                return;
            }
            try {
                URL url = (URL)this.imports.removeFirst();
                PARSER.parseStyleSheet(url.toExternalForm());
            }
            catch (CSSException e) {
                System.out.println((Object)e);
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }

        public void importStyle(String uri, SACMediaList mediaList, String defaultNamespaceURI) throws CSSException {
            if (uri == null || uri.length() == 0) {
                return;
            }
            try {
                URL url = new URL(new URL(PARSER.getLocator().getURI()), uri);
                System.out.println(url);
                this.imports.add(url);
            }
            catch (MalformedURLException e) {
                System.out.println(e);
            }
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            if (this.option.underscoreHack && name.charAt(0) == '_') {
                name = name.substring(1);
            }
            try {
                PropertyDefinition definition = PropertyRegistry.getDefinition(name);
                CSSValue cssValue = CSSUtil.convert(value);
                Map result = definition.parse(cssValue);
                if (result == null) {
                    this.addError(I18nUtil.getText("validator.invalidValue", name, ValueUtil.toString(cssValue)));
                }
            }
            catch (IllegalArgumentException e) {
                this.addError(I18nUtil.getText("validator.propertyNotDefined", name));
            }
        }

        public void error(CSSParseException exception) throws CSSException {
            this.addError(exception);
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            this.addError(exception);
        }

        public void warning(CSSParseException exception) throws CSSException {
            this.addError(exception);
        }

        private void addError(String message) {
            CSSParseException exception = new CSSParseException(message, PARSER.getLocator());
            this.container.add(exception);
        }

        private void addError(CSSParseException ex) {
            String message = ex.getException() == null ? ex.getLocalizedMessage() : ex.getException().getMessage();
            this.container.add(new CSSParseException(message, ex.getURI(), ex.getLineNumber(), ex.getColumnNumber()));
        }
    }

    private static class Option {
        private boolean underscoreHack = false;

        Option() {
        }
    }
}

